## ----global_settings, echo = FALSE, message = FALSE-----------------------------------------------
library(markdown)
options(markdown.HTML.options = c(options('markdown.HTML.options')[[1]], "toc"))

library(knitr)
knitr::opts_chunk$set(
    error = FALSE,
    tidy  = FALSE,
    message = FALSE,
    fig.align = "center",
    fig.width = 5,
    fig.height = 5)
options(markdown.HTML.stylesheet = "custom.css")

options(width = 100)

## ----legend_default, fig.width = 8, fig.keep = "all"----------------------------------------------
library(ComplexHeatmap)
library(circlize)

set.seed(123)
mat = matrix(rnorm(80, 2), 8, 10)
mat = rbind(mat, matrix(rnorm(40, -2), 4, 10))
rownames(mat) = paste0("R", 1:12)
colnames(mat) = paste0("C", 1:10)

ha_column = HeatmapAnnotation(df = data.frame(type1 = c(rep("a", 5), rep("b", 5))), 
    col = list(type1 = c("a" =  "red", "b" = "blue")))
ha_row = rowAnnotation(df = data.frame(type2 = c(rep("A", 6), rep("B", 6))), 
    col = list(type2 = c("A" =  "green", "B" = "orange")), width = unit(1, "cm"))

ht1 = Heatmap(mat, name = "ht1", column_title = "Heatmap 1", top_annotation = ha_column)
ht2 = Heatmap(mat, name = "ht2", column_title = "Heatmap 2")
ht_list = ht1 + ht2 + ha_row

draw(ht_list)

## ----legend_side, fig.width = 8, fig.keep = "all"-------------------------------------------------
draw(ht_list, heatmap_legend_side = "left", annotation_legend_side = "bottom")

## ----legend_show, fig.width = 8, fig.keep = "all"-------------------------------------------------
draw(ht_list, show_heatmap_legend = FALSE, show_annotation_legend = FALSE)

## ----legend_show_part, fig.width = 10-------------------------------------------------------------
ha_column = HeatmapAnnotation(df = data.frame(type1 = c(rep("a", 5), rep("b", 5))), 
    col = list(type1 = c("a" =  "red", "b" = "blue")), show_legend = FALSE)
ha_row = rowAnnotation(df = data.frame(type2 = c(rep("A", 6), rep("B", 6))), 
    col = list(type2 = c("A" =  "green", "B" = "orange")), show_legend = FALSE, width = unit(1, "cm"))

ht1 = Heatmap(mat, name = "ht1", column_title = "Heatmap 1", top_annotation = ha_column)
ht2 = Heatmap(mat, name = "ht2", column_title = "Heatmap 2", show_heatmap_legend = FALSE)
ht1 + ht2 + ha_row

## ----heatmap_list_advanced, fig.width = 10--------------------------------------------------------
df = data.frame(type = c(rep("a", 5), rep("b", 5)))
ha = HeatmapAnnotation(df = df, col = list(type = c("a" =  "red", "b" = "blue")),
    annotation_legend_param = list(type = list(title = "TYPE", title_gp = gpar(fontsize = 14), 
                                               labels_gp = gpar(fontsize = 8))))
ht1 = Heatmap(mat, name = "ht1", column_title = "Heatmap 1", top_annotation = ha)
ht2 = Heatmap(mat, name = "ht2", column_title = "Heatmap 2", 
    heatmap_legend_param = list(title = "Heatmap2", title_gp = gpar(fontsize = 8), 
        labels_gp = gpar(fontsize = 14)))
ht1 + ht2

## ----self_define_heatmap_legend, fig.width = 10---------------------------------------------------
ha = HeatmapAnnotation(df = df, col = list(type = c("a" =  "red", "b" = "blue")),
    annotation_legend_param = list(type = list(title = "TYPE", title_gp = gpar(fontsize = 14), 
        labels_gp = gpar(fontsize = 8), at = c("a", "b"), labels = c("A", "B"))))
ht1 = Heatmap(mat, name = "ht1", column_title = "Heatmap 1", top_annotation = ha,
    heatmap_legend_param = list(at = c(-3, 0, 3), labels = c("-three", "zero", "+three")))
ht1 + ht2

## ---- fig.width = 6-------------------------------------------------------------------------------
ha_chr = rowAnnotation(chr = sample(paste0("chr", 1:20), nrow(mat), replace = TRUE),
    annotation_legend_param = list(chr = list(ncol = 2, title = "chromosome", title_position = "topcenter")),
    width = unit(5, "mm"))
ht1 = Heatmap(mat, name = "ht1")
ht1 + ha_chr

## ---- fig.width = 6-------------------------------------------------------------------------------
ha_chr = rowAnnotation(chr = sample(paste0("chr", 1:20), nrow(mat), replace = TRUE),
    annotation_legend_param = list(chr = list(nrow = 2, title = "chr", title_position = "leftcenter")),
    width = unit(5, "mm"))
ht1 = Heatmap(mat, name = "ht1", show_heatmap_legend = FALSE)
draw(ht1 + ha_chr, heatmap_legend_side = "bottom")

## -------------------------------------------------------------------------------------------------
ha = HeatmapAnnotation(df = data.frame(value = runif(10)), 
    col = list(value = colorRamp2(c(0, 1), c("white", "blue"))), 
    annotation_legend_param = list(color_bar = "discrete", at = c(0, 0.5, 1)))
Heatmap(mat, name = "ht1", top_annotation = ha, heatmap_legend_param = list(color_bar = "discrete"))

## -------------------------------------------------------------------------------------------------
ht = Heatmap(mat, name = "ht1", heatmap_legend_param = list(legend_direction = "horizontal",
    legend_width = unit(5, "cm"), title_position = "lefttop"))
draw(ht, heatmap_legend_side = "bottom")

## -------------------------------------------------------------------------------------------------
Heatmap(mat, name = "ht1", heatmap_legend_param = list(legend_height = unit(5, "cm")))

## ---- fig.width = 10------------------------------------------------------------------------------
ht_global_opt(heatmap_legend_title_gp = gpar(fontsize = 16), annotation_legend_labels_gp = gpar(fontface = "italic"))
ha = HeatmapAnnotation(df = data.frame(value = runif(10)), 
    col = list(value = colorRamp2(c(0, 1), c("white", "blue"))))
ht1 = Heatmap(mat, name = "ht1", column_title = "Heatmap 1", top_annotation = ha)
ht2 = Heatmap(mat, name = "ht2", column_title = "Heatmap 2", heatmap_legend_param = list(title_gp = gpar(fontsize = 8)))
ht1 + ht2
ht_global_opt(RESET = TRUE)

## ----self_defined_annotation_legend, fig.width = 10-----------------------------------------------
ha = HeatmapAnnotation(points = anno_points(rnorm(10)))
ht2 = Heatmap(mat, name = "ht2", column_title = "Heatmap 2", top_annotation = ha, show_heatmap_legend = FALSE)
lgd = legendGrob(c("dots"), pch = 16)
draw(ht1 + ht2, annotation_legend_list = list(lgd))

## -------------------------------------------------------------------------------------------------
ha = HeatmapAnnotation(points = anno_points(rnorm(10), gp = gpar(col = rep(2:3, each = 5))))
ht = Heatmap(mat, name = "ht2", column_title = "Heatmap 2", top_annotation = ha)
lgd = Legend(at = c("class1", "class2"), title = "points", type = "points", legend_gp = gpar(col = 2:3))
draw(ht, annotation_legend_list = list(lgd))

## -------------------------------------------------------------------------------------------------
sessionInfo()

