## ----style, echo = FALSE, results = 'asis'---------------------------------
BiocStyle::markdown()

## ----library, message=FALSE------------------------------------------------
library(ExperimentHub)

## ----ExperiemntHub---------------------------------------------------------
eh = ExperimentHub()

## ----show------------------------------------------------------------------
eh

## ----dataprovider----------------------------------------------------------
unique(eh$dataprovider)

## ----species---------------------------------------------------------------
head(unique(eh$species))

## ----rdataclass------------------------------------------------------------
head(unique(eh$rdataclass))

## ----alpine----------------------------------------------------------------
apData <- query(eh, "alpineData")
apData

## ----show2-----------------------------------------------------------------
apData$preparerclass
df <- mcols(apData)

## ----length----------------------------------------------------------------
length(eh)

## ----subset----------------------------------------------------------------
mm <- query(eh, "mus musculus")
mm

## ----display, eval=FALSE---------------------------------------------------
#  d <- display(eh)

## ----dm2-------------------------------------------------------------------
apData
apData["EH166"]

## ----dm3-------------------------------------------------------------------
apData[["EH166"]]

## ----show-2----------------------------------------------------------------
eh

## ----snapshot--------------------------------------------------------------
snapshotDate(eh)

## ----possibleDates---------------------------------------------------------
pd <- possibleDates(eh)
pd

## ----setdate, eval=FALSE---------------------------------------------------
#  snapshotDate(ah) <- pd[1]

## ----sessionInfo-----------------------------------------------------------
sessionInfo()

