/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.CompositeRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Renderer;
import com.sun.glf.ShapeLayer;
import com.sun.glf.StrokeRenderer;
import com.sun.glf.goodies.ShapeStroke;
import com.sun.glf.goodies.WaveStroke;
import com.sun.glf.util.CompositionComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class CompositeStroke
implements Stroke {
    private Stroke strokeA;
    private Stroke strokeB;
    public static final String USAGE = "java com.sun.glf.goodies.CompositeStroke <ellipse|triangle|square|textShape> <gap>";

    public Stroke[] getComponentStrokes() {
        return new Stroke[]{this.strokeA, this.strokeB};
    }

    public CompositeStroke(Stroke stroke, Stroke stroke2) {
        if (stroke == null || stroke2 == null) {
            throw new IllegalArgumentException();
        }
        this.strokeA = stroke;
        this.strokeB = stroke2;
    }

    public Shape createStrokedShape(Shape shape) {
        return this.strokeB.createStrokedShape(this.strokeA.createStrokedShape(shape));
    }

    public static void main(String[] stringArray) {
        Hashtable<String, Shape> hashtable = new Hashtable<String, Shape>();
        Ellipse2D.Float float_ = new Ellipse2D.Float(0.0f, 0.0f, 200.0f, 200.0f);
        hashtable.put("ellipse", float_);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(100.0f, 0.0f);
        generalPath.lineTo(200.0f, 200.0f);
        generalPath.lineTo(0.0f, 200.0f);
        generalPath.closePath();
        hashtable.put("triangle", generalPath);
        hashtable.put("square", new Rectangle(0, 0, 200, 200));
        Font font = new Font("Times New Roman", 0, 200);
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        Shape shape = font.createGlyphVector(fontRenderContext, "Hi!").getOutline();
        hashtable.put("textShape", shape);
        Ellipse2D.Float float_2 = new Ellipse2D.Float(0.0f, 0.0f, 8.0f, 8.0f);
        Rectangle rectangle = new Rectangle(0, 0, 8, 8);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(4.0f, 0.0f);
        generalPath2.lineTo(8.0f, 8.0f);
        generalPath2.lineTo(0.0f, 8.0f);
        generalPath2.closePath();
        Shape shape2 = null;
        int n = 0;
        try {
            shape2 = (Shape)hashtable.get(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            System.out.println(USAGE);
            System.exit(0);
        }
        JFrame jFrame = new JFrame("ShapeStroke unit testing");
        jFrame.getContentPane().setBackground(Color.white);
        jFrame.getContentPane().setLayout(new GridLayout(0, 2));
        Rectangle rectangle2 = shape2.getBounds();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-rectangle2.x + 20, -rectangle2.y + 20);
        shape2 = affineTransform.createTransformedShape(shape2);
        Dimension dimension = new Dimension(rectangle2.width + 40, rectangle2.height + 40);
        Shape[] shapeArray = new Shape[]{generalPath2, float_2, rectangle};
        ShapeStroke shapeStroke = new ShapeStroke(shapeArray, (float)n);
        BasicStroke basicStroke = new BasicStroke(1.0f);
        WaveStroke waveStroke = new WaveStroke(4.0f);
        CompositeStroke compositeStroke = new CompositeStroke(shapeStroke, basicStroke);
        CompositeStroke compositeStroke2 = new CompositeStroke(waveStroke, basicStroke);
        Renderer renderer = new StrokeRenderer((Paint)Color.black, basicStroke);
        jFrame.getContentPane().add(CompositeStroke.makeNewComponent(dimension, renderer, shape2, "BasicStroke"));
        Color color = new Color(153, 153, 204);
        renderer = new CompositeRenderer(new Renderer[]{new StrokeRenderer((Paint)color, shapeStroke), new StrokeRenderer((Paint)Color.black, compositeStroke)});
        jFrame.getContentPane().add(CompositeStroke.makeNewComponent(dimension, renderer, shape2, "ShapeStroke & CompositeStroke"));
        renderer = new StrokeRenderer((Paint)color, waveStroke);
        jFrame.getContentPane().add(CompositeStroke.makeNewComponent(dimension, renderer, shape2, "WaveStroke"));
        renderer = new StrokeRenderer((Paint)Color.black, compositeStroke2);
        jFrame.getContentPane().add(CompositeStroke.makeNewComponent(dimension, renderer, shape2, "CompositeStroke : WaveStroke -> BasicStroke"));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static JComponent makeNewComponent(Dimension dimension, Renderer renderer, Shape shape, String string) {
        LayerComposition layerComposition = new LayerComposition(dimension);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        layerComposition.setRenderingHints(renderingHints);
        ShapeLayer shapeLayer = new ShapeLayer(layerComposition, shape, renderer);
        layerComposition.setLayers(new Layer[]{shapeLayer});
        CompositionComponent compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText(string);
        return compositionComponent;
    }
}

