/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.data.ExpressionData;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;

class ImportExpressionDataTask
implements Task {
    private TaskMonitor taskMonitor;
    private String filename;
    private String keyAttributeName;

    public ImportExpressionDataTask(String filename, String keyAttributeName) {
        this.filename = filename;
        this.keyAttributeName = keyAttributeName;
    }

    public void run() {
        this.taskMonitor.setStatus("Analyzing Expression Data File...");
        try {
            ExpressionData expressionData = new ExpressionData(this.filename, this.keyAttributeName, this.taskMonitor);
            Cytoscape.setExpressionData(expressionData);
            this.taskMonitor.setStatus("Mapping Expression Data to Nodes according to " + this.keyAttributeName);
            expressionData.copyToAttribs(Cytoscape.getNodeAttributes(), this.taskMonitor);
            Cytoscape.firePropertyChange(Cytoscape.ATTRIBUTES_CHANGED, null, null);
            Cytoscape.firePropertyChange(Cytoscape.EXPRESSION_DATA_LOADED, null, expressionData);
            this.taskMonitor.setPercentCompleted(100);
            this.taskMonitor.setStatus(expressionData.getDescription());
        }
        catch (Exception e) {
            this.taskMonitor.setException(e, "Unable to load expression matrix file.");
        }
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Loading Gene Expression Data");
    }
}

