/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SetNestedNetworkDialog
extends JDialog
implements ListSelectionListener {
    NodeView nodeView;
    private JButton btnCancel;
    private JButton btnOK;
    private JScrollPane jScrollPane1;
    private JLabel lbTitle;
    private JList lstNetwork;
    private JPanel pnlButtons;
    private CyNetwork selectedNetwork = null;
    private static final Color SELECTED_CELL_COLOR = new Color(0, 100, 255, 40);

    public SetNestedNetworkDialog(JFrame parent, boolean modal, NodeView nodeView) {
        super(parent, "Set Nested Network for " + nodeView.getNode().getIdentifier(), modal);
        this.init(nodeView);
    }

    public SetNestedNetworkDialog(JFrame parent, boolean modal) {
        super(parent, "Set Nested Network for new node", modal);
        this.init(null);
    }

    private void init(NodeView nodeView) {
        this.nodeView = nodeView;
        this.initComponents();
        this.lstNetwork.addListSelectionListener(this);
        this.lstNetwork.setCellRenderer(new MyCellRenderer());
        this.btnOK.setEnabled(false);
        Set<CyNetwork> networkSet = Cytoscape.getNetworkSet();
        Object[] objs = networkSet.toArray();
        CyNetwork[] networkArray = new CyNetwork[objs.length];
        for (int i = 0; i < networkArray.length; ++i) {
            networkArray[i] = (CyNetwork)objs[i];
        }
        this.lstNetwork.setListData(networkArray);
        this.setSize(new Dimension(500, 300));
    }

    private void initComponents() {
        this.lbTitle = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstNetwork = new JList();
        this.pnlButtons = new JPanel();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.lbTitle.setFont(new Font("Tahoma", 1, 14));
        this.lbTitle.setText("Please choose a network");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.lbTitle, gridBagConstraints);
        this.lstNetwork.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstNetwork.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lstNetwork);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SetNestedNetworkDialog.this.btnOKActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.btnOK);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SetNestedNetworkDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.btnCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.pack();
    }

    public CyNetwork getSelectedNetwork() {
        return this.selectedNetwork;
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.selectedNetwork = (CyNetwork)this.lstNetwork.getSelectedValue();
        if (this.nodeView != null) {
            this.nodeView.getNode().setNestedNetwork(this.selectedNetwork);
        }
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.lstNetwork.getSelectedIndex() == -1) {
            this.btnOK.setEnabled(false);
        } else {
            this.btnOK.setEnabled(true);
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CyNetwork cyNetwork = (CyNetwork)value;
            this.setText(cyNetwork.getTitle());
            this.setBackground(isSelected ? SELECTED_CELL_COLOR : Color.white);
            this.setForeground(isSelected ? Color.BLACK : Color.black);
            return this;
        }
    }
}

