/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.util.AbstractScaler;

class LinearScaler
extends AbstractScaler {
    LinearScaler() {
    }

    public double[] scale(double[] values, double a, double b) throws IllegalArgumentException {
        if (values.length < 2) {
            throw new IllegalArgumentException("need at least 2 values for scaling!");
        }
        if (a >= b) {
            throw new IllegalArgumentException("bad bounds!");
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (double d : values) {
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        if (min == max) {
            throw new IllegalArgumentException("input values are all identical!");
        }
        double c = (a - b) / (min - max);
        double d = a - c * min;
        double[] scaledValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            scaledValues[i] = c * values[i] + d;
        }
        return scaledValues;
    }
}

