/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import cytoscape.Cytoscape;
import cytoscape.ding.DingNetworkView;
import cytoscape.util.export.Exporter;
import cytoscape.view.CyNetworkView;
import cytoscape.view.InternalFrameComponent;
import java.awt.Graphics2D;
import java.io.FileOutputStream;
import java.io.IOException;

public class PDFExporter
implements Exporter {
    private boolean exportTextAsFont = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(CyNetworkView view, FileOutputStream stream) throws IOException {
        DingNetworkView dView = (DingNetworkView)view;
        dView.setPrintingTextAsShape(!this.exportTextAsFont);
        InternalFrameComponent ifc = Cytoscape.getDesktop().getNetworkViewManager().getInternalFrameComponent(view);
        Rectangle pageSize = PageSize.LETTER;
        Document document = new Document(pageSize);
        try {
            PdfWriter writer = PdfWriter.getInstance(document, stream);
            try {
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                Graphics2D g = null;
                g = this.exportTextAsFont ? cb.createGraphics(pageSize.getWidth(), pageSize.getHeight(), new DefaultFontMapper()) : cb.createGraphicsShapes(pageSize.getWidth(), pageSize.getHeight());
                double imageScale = Math.min((double)pageSize.getWidth() / (double)ifc.getWidth(), (double)pageSize.getHeight() / (double)ifc.getHeight());
                g.scale(imageScale, imageScale);
                ifc.print(g);
                g.dispose();
                Object var13_12 = null;
                if (document != null) {
                    document.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (document != null) {
                    document.close();
                }
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
        }
        catch (DocumentException exp) {
            throw new IOException(exp.getMessage());
        }
    }

    public void setExportTextAsFont(boolean pExportTextAsFont) {
        this.exportTextAsFont = pExportTextAsFont;
    }
}

