/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.intr.test;

import cytoscape.util.intr.IntBTree;
import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.IntStack;
import java.io.IOException;
import java.io.InputStream;

public class IntBTreePerformance {
    static IntBTree _THE_TREE_ = null;
    static IntStack _THE_STACK_ = null;

    public static void main(String[] args) throws Exception {
        int read;
        int N = Integer.parseInt(args[0]);
        int[] elements = new int[N];
        InputStream in = System.in;
        byte[] buff = new byte[4];
        int inx = 0;
        int off = 0;
        while (inx < N && (read = in.read(buff, off, buff.length - off)) > 0) {
            if ((off += read) < buff.length) continue;
            off = 0;
            elements[inx++] = (Integer.MAX_VALUE & IntBTreePerformance.assembleInt(buff)) % N;
        }
        if (inx < N) {
            throw new IOException("premature end of input");
        }
        in = null;
        buff = null;
        IntBTreePerformance._THE_TEST_CASE_(new int[]{0, 3, 4, 3, 9, 9, 1});
        Thread.sleep(1000L);
        for (int i = 0; i < 100; ++i) {
            int foo = i * 4 / 8;
        }
        long millisBegin = System.currentTimeMillis();
        int[] uniqueElements = IntBTreePerformance._THE_TEST_CASE_(elements);
        long millisEnd = System.currentTimeMillis();
        System.err.println(millisEnd - millisBegin);
        for (int i = 0; i < uniqueElements.length; ++i) {
            System.out.println(uniqueElements[i]);
        }
    }

    private static final int assembleInt(byte[] fourConsecutiveBytes) {
        int firstByte = (fourConsecutiveBytes[0] & 0xFF) << 24;
        int secondByte = (fourConsecutiveBytes[1] & 0xFF) << 16;
        int thirdByte = (fourConsecutiveBytes[2] & 0xFF) << 8;
        int fourthByte = (fourConsecutiveBytes[3] & 0xFF) << 0;
        return firstByte | secondByte | thirdByte | fourthByte;
    }

    private static final int[] _THE_TEST_CASE_(int[] elements) {
        _THE_TREE_ = new IntBTree();
        _THE_STACK_ = new IntStack();
        for (int i = 0; i < elements.length; ++i) {
            _THE_TREE_.insert(elements[i]);
        }
        IntEnumerator iter = _THE_TREE_.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
        int prevVal = -1;
        if (iter.numRemaining() > 0) {
            prevVal = iter.nextInt();
            _THE_STACK_.push(prevVal);
        }
        while (iter.numRemaining() > 0) {
            int newVal = iter.nextInt();
            if (newVal == prevVal) continue;
            prevVal = newVal;
            _THE_STACK_.push(prevVal);
        }
        int[] returnThis = new int[_THE_STACK_.size()];
        int i = _THE_STACK_.size();
        while (i > 0) {
            returnThis[--i] = _THE_STACK_.pop();
        }
        return returnThis;
    }
}

