/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.Cytoscape;
import cytoscape.actions.AlphabeticalSelectionAction;
import cytoscape.actions.ArrangeAction;
import cytoscape.actions.BendSelectedEdgesAction;
import cytoscape.actions.BookmarkAction;
import cytoscape.actions.CloneGraphInNewWindowAction;
import cytoscape.actions.CreateNetworkViewAction;
import cytoscape.actions.CytoPanelAction;
import cytoscape.actions.DeSelectAllEdgesAction;
import cytoscape.actions.DeSelectAllNodesAction;
import cytoscape.actions.DeleteAction;
import cytoscape.actions.DeselectAllAction;
import cytoscape.actions.DestroyNetworkAction;
import cytoscape.actions.DestroyNetworkViewAction;
import cytoscape.actions.ExitAction;
import cytoscape.actions.ExportAsGMLAction;
import cytoscape.actions.ExportAsGraphicsAction;
import cytoscape.actions.ExportAsInteractionsAction;
import cytoscape.actions.ExportAsXGMMLAction;
import cytoscape.actions.ExportEdgeAttributesAction;
import cytoscape.actions.ExportNodeAttributesAction;
import cytoscape.actions.ExportVizmapAction;
import cytoscape.actions.FitContentAction;
import cytoscape.actions.HelpAboutAction;
import cytoscape.actions.HelpContactHelpDeskAction;
import cytoscape.actions.HelpContentsAction;
import cytoscape.actions.HideSelectedEdgesAction;
import cytoscape.actions.HideSelectedNodesAction;
import cytoscape.actions.ImportEdgeAttributesAction;
import cytoscape.actions.ImportExpressionMatrixAction;
import cytoscape.actions.ImportGraphFileAction;
import cytoscape.actions.ImportNodeAttributesAction;
import cytoscape.actions.ImportVizmapAction;
import cytoscape.actions.InvertSelectedEdgesAction;
import cytoscape.actions.InvertSelectedNodesAction;
import cytoscape.actions.ListFromFileSelectionAction;
import cytoscape.actions.LoggerAction;
import cytoscape.actions.MemoryUsageAction;
import cytoscape.actions.NewNetworkAction;
import cytoscape.actions.NewSessionAction;
import cytoscape.actions.NewWindowSelectedNodesEdgesAction;
import cytoscape.actions.NewWindowSelectedNodesOnlyAction;
import cytoscape.actions.OpenSessionAction;
import cytoscape.actions.PluginManagerAction;
import cytoscape.actions.PluginUpdateAction;
import cytoscape.actions.PreferenceAction;
import cytoscape.actions.PrintAction;
import cytoscape.actions.ProxyServerAction;
import cytoscape.actions.SaveSessionAction;
import cytoscape.actions.SaveSessionAsAction;
import cytoscape.actions.SelectAdjacentEdgesAction;
import cytoscape.actions.SelectAllAction;
import cytoscape.actions.SelectAllEdgesAction;
import cytoscape.actions.SelectAllNodesAction;
import cytoscape.actions.SelectConnectedNodesAction;
import cytoscape.actions.SelectFirstNeighborsAction;
import cytoscape.actions.SelectionModeAction;
import cytoscape.actions.SetVisualPropertiesAction;
import cytoscape.actions.ShowCustomGraphicsManagerAction;
import cytoscape.actions.ShowGraphicsDetailsAction;
import cytoscape.actions.StraightenSelectedEdgesAction;
import cytoscape.actions.UnHideSelectedEdgesAction;
import cytoscape.actions.UnHideSelectedNodesAction;
import cytoscape.actions.WebServiceNetworkImportAction;
import cytoscape.actions.ZoomAction;
import cytoscape.actions.ZoomSelectedAction;
import cytoscape.layout.ui.LayoutMenuManager;
import cytoscape.layout.ui.SettingsAction;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.CytoscapeMenuBar;
import cytoscape.util.CytoscapeToolBar;
import cytoscape.util.RecentlyOpenedTracker;
import cytoscape.util.undo.RedoAction;
import cytoscape.util.undo.UndoAction;
import cytoscape.view.CyHelpBroker;
import cytoscape.view.OpenRecentAction;
import cytoscape.view.cytopanels.CytoPanelName;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.List;
import javax.help.CSH;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public class CyMenus
implements GraphViewChangeListener,
PropertyChangeListener {
    boolean menusInitialized = false;
    CytoscapeMenuBar menuBar;
    CytoscapeToolBar toolBar;
    JMenu fileMenu;
    JMenu loadSubMenu;
    JMenu saveSubMenu;
    JMenu newSubMenu;
    JMenu newSubMenu2;
    JMenu editMenu;
    JMenu viewMenu;
    JMenu viewSubMenu;
    JMenu selectMenu;
    JMenu layoutMenu;
    JMenu vizMenu;
    JMenu helpMenu;
    JMenu opsMenu;
    JMenu recentlyOpenedSubMenu;
    JButton openSessionButton;
    JButton saveButton;
    JButton zoomInButton;
    JButton zoomOutButton;
    JButton zoomSelectedButton;
    JButton zoomDisplayAllButton;
    JButton snapshotButton;
    JButton showAllButton;
    JButton hideSelectedButton;
    JButton annotationButton;
    JButton helpButton;
    JButton vizButton;

    public CyMenus() {
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
        this.toolBar = new CytoscapeToolBar();
        this.menuBar = new CytoscapeMenuBar();
        this.fileMenu = this.menuBar.getMenu("File");
        this.newSubMenu = this.menuBar.getMenu("File.New", 0);
        this.newSubMenu2 = this.menuBar.getMenu("File.New.Network");
        this.loadSubMenu = this.menuBar.getMenu("File.Import", 1);
        this.saveSubMenu = this.menuBar.getMenu("File.Export", 2);
        this.recentlyOpenedSubMenu = this.menuBar.getMenu("File.Recently Opened", 3);
        this.initRecentlyOpenedSubMenu();
        this.editMenu = this.menuBar.getMenu("Edit");
        this.viewMenu = this.menuBar.getMenu("View");
        this.selectMenu = this.menuBar.getMenu("Select");
        this.layoutMenu = this.menuBar.getMenu("Layout");
        this.opsMenu = this.menuBar.getMenu("Plugins");
        this.helpMenu = this.menuBar.getMenu("Help");
    }

    private void initRecentlyOpenedSubMenu() {
        RecentlyOpenedTracker sessionTracker = Cytoscape.getRecentlyOpenedSessionTracker();
        if (sessionTracker == null) {
            return;
        }
        List<URL> recentlyOpenedSessions = sessionTracker.getRecentlyOpenedURLs();
        for (URL url : recentlyOpenedSessions) {
            this.recentlyOpenedSubMenu.add(new JMenuItem(new OpenRecentAction(url)));
        }
    }

    public CytoscapeMenuBar getMenuBar() {
        return this.menuBar;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getLoadSubMenu() {
        return this.loadSubMenu;
    }

    public JMenu getSaveSubMenu() {
        return this.saveSubMenu;
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenu getViewMenu() {
        return this.viewMenu;
    }

    public JMenu getSelectMenu() {
        return this.selectMenu;
    }

    public JMenu getLayoutMenu() {
        return this.layoutMenu;
    }

    public JMenu getVizMenu() {
        return this.vizMenu;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    public JMenu getOperationsMenu() {
        return this.opsMenu;
    }

    public JMenu getNewNetworkMenu() {
        return this.newSubMenu2;
    }

    public CytoscapeToolBar getToolBar() {
        return this.toolBar;
    }

    public void addAction(CytoscapeAction action) {
        this.addCytoscapeAction(action);
    }

    public void addAction(CytoscapeAction action, int index) {
        this.addCytoscapeAction(action, index);
    }

    public void addCytoscapeAction(CytoscapeAction action) {
        if (action.isInMenuBar()) {
            this.getMenuBar().addAction(action);
        }
        if (action.isInToolBar()) {
            this.getToolBar().addAction(action);
        }
    }

    public void addCytoscapeAction(CytoscapeAction action, int index) {
        if (action.isInMenuBar()) {
            this.getMenuBar().addAction(action, index);
        }
        if (action.isInToolBar()) {
            this.getToolBar().addAction(action);
        }
    }

    public void setVisualMapperItemsEnabled(boolean newState) {
    }

    public void setOverviewEnabled(boolean newState) {
    }

    public void setNodesRequiredItemsEnabled() {
    }

    public void graphViewChanged(GraphViewChangeEvent e) {
    }

    public JMenu getCytoPanelMenu() {
        return null;
    }

    public void initCytoPanelMenus() {
    }

    public void initializeMenus() {
        if (!this.menusInitialized) {
            this.menusInitialized = true;
            this.fillMenuBar();
            this.fillToolBar();
        }
    }

    private void fillMenuBar() {
        this.addAction(new NewSessionAction());
        this.addAction(new NewWindowSelectedNodesOnlyAction());
        this.addAction(new NewWindowSelectedNodesEdgesAction());
        this.addAction(new CloneGraphInNewWindowAction());
        this.addAction(new NewNetworkAction());
        this.addAction(new OpenSessionAction(), 1);
        this.addAction(new SaveSessionAction("Save"), 2);
        this.addAction(new SaveSessionAsAction("Save as..."), 3);
        this.fileMenu.add((Component)new JSeparator(), 2);
        this.fileMenu.add((Component)new JSeparator(), 5);
        this.addAction(new ImportGraphFileAction(this));
        this.addAction(new WebServiceNetworkImportAction());
        this.loadSubMenu.add(new JSeparator());
        this.addAction(new ImportNodeAttributesAction());
        this.addAction(new ImportEdgeAttributesAction());
        this.addAction(new ImportExpressionMatrixAction());
        this.addAction(new ImportVizmapAction());
        this.loadSubMenu.add(new JSeparator());
        this.addAction(new ExportAsXGMMLAction());
        this.addAction(new ExportAsGMLAction());
        this.addAction(new ExportAsInteractionsAction());
        this.addAction(new ExportNodeAttributesAction());
        this.addAction(new ExportEdgeAttributesAction());
        this.addAction(new ExportVizmapAction());
        this.addAction(new ExportAsGraphicsAction("PDF"));
        this.fileMenu.add(new JSeparator());
        this.addAction(new PrintAction());
        this.fileMenu.add(new JSeparator());
        this.addAction(new ExitAction());
        this.addAction(new UndoAction());
        this.addAction(new RedoAction());
        this.editMenu.add(new JSeparator());
        this.addAction(new CreateNetworkViewAction());
        this.addAction(new DestroyNetworkViewAction());
        this.addAction(new DestroyNetworkAction());
        this.editMenu.add(new JSeparator());
        this.addAction(new DeleteAction());
        this.editMenu.add(new JSeparator());
        this.addAction(new PreferenceAction());
        this.addAction(new BookmarkAction());
        this.addAction(new ProxyServerAction());
        SelectionModeAction sma = new SelectionModeAction();
        this.selectMenu.add(sma);
        this.selectMenu.addMenuListener(sma);
        this.addAction(new InvertSelectedNodesAction());
        this.addAction(new HideSelectedNodesAction());
        this.addAction(new UnHideSelectedNodesAction());
        this.addAction(new SelectAllNodesAction());
        this.addAction(new DeSelectAllNodesAction());
        this.addAction(new SelectFirstNeighborsAction());
        this.addAction(new SelectConnectedNodesAction());
        this.addAction(new AlphabeticalSelectionAction());
        this.addAction(new ListFromFileSelectionAction());
        this.addAction(new InvertSelectedEdgesAction());
        this.addAction(new HideSelectedEdgesAction());
        this.addAction(new UnHideSelectedEdgesAction());
        this.addAction(new SelectAllEdgesAction());
        this.addAction(new SelectAdjacentEdgesAction());
        this.addAction(new DeSelectAllEdgesAction());
        this.addAction(new BendSelectedEdgesAction());
        this.addAction(new StraightenSelectedEdgesAction());
        this.selectMenu.addSeparator();
        this.addAction(new SelectAllAction());
        this.addAction(new DeselectAllAction());
        this.selectMenu.addSeparator();
        this.addAction(new CytoPanelAction(CytoPanelName.WEST, true, null));
        this.addAction(new CytoPanelAction(CytoPanelName.SOUTH, true, null));
        this.addAction(new CytoPanelAction(CytoPanelName.EAST, false, null));
        this.addAction(new CytoPanelAction(CytoPanelName.SOUTH_WEST, false, CytoPanelName.WEST));
        this.viewMenu.add(new JSeparator());
        this.addAction(new ShowGraphicsDetailsAction());
        this.viewMenu.add(new JSeparator());
        this.addAction(new SetVisualPropertiesAction());
        this.addAction(new ShowCustomGraphicsManagerAction());
        this.viewMenu.add(new JSeparator());
        this.viewMenu.add(new ArrangeAction());
        this.layoutMenu.addSeparator();
        this.addAction(new SettingsAction());
        this.layoutMenu.addSeparator();
        this.layoutMenu.addMenuListener(new LayoutMenuManager());
        this.addAction(new PluginManagerAction());
        this.addAction(new PluginUpdateAction());
        this.opsMenu.addSeparator();
        this.addAction(new HelpContentsAction());
        this.addAction(new HelpContactHelpDeskAction());
        this.helpMenu.addSeparator();
        this.addAction(new HelpAboutAction());
        this.addAction(new LoggerAction());
        this.addAction(new MemoryUsageAction());
    }

    private void fillToolBar() {
        this.openSessionButton = this.toolBar.add(new OpenSessionAction(this, false));
        this.openSessionButton.setToolTipText("Open Session File...");
        this.openSessionButton.setIcon(new ImageIcon(Cytoscape.class.getResource("images/ximian/stock_open.png")));
        this.openSessionButton.setBorderPainted(false);
        this.openSessionButton.setRolloverEnabled(true);
        this.saveButton = this.toolBar.add(new SaveSessionAction());
        this.saveButton.setToolTipText("Save Current Session as...");
        this.saveButton.setIcon(new ImageIcon(Cytoscape.class.getResource("images/ximian/stock_save.png")));
        this.saveButton.setBorderPainted(false);
        this.saveButton.setRolloverEnabled(true);
        this.toolBar.addSeparator();
        final ZoomAction zoom_in = new ZoomAction(1.1);
        this.zoomInButton = new JButton();
        this.zoomInButton.setIcon(new ImageIcon(Cytoscape.class.getResource("images/ximian/stock_zoom-in.png")));
        this.zoomInButton.setToolTipText("Zoom In");
        this.zoomInButton.setBorderPainted(false);
        this.zoomInButton.setRolloverEnabled(true);
        this.zoomInButton.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                zoom_in.zoom();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                CyMenus.this.zoomInButton.setSelected(true);
            }

            public void mouseReleased(MouseEvent e) {
                CyMenus.this.zoomInButton.setSelected(false);
            }
        });
        final ZoomAction zoom_out = new ZoomAction(0.9);
        this.zoomOutButton = new JButton();
        this.zoomOutButton.setIcon(new ImageIcon(Cytoscape.class.getResource("images/ximian/stock_zoom-out.png")));
        this.zoomOutButton.setToolTipText("Zoom Out");
        this.zoomOutButton.setBorderPainted(false);
        this.zoomOutButton.setRolloverEnabled(true);
        this.zoomOutButton.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                zoom_out.zoom();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                CyMenus.this.zoomOutButton.setSelected(true);
            }

            public void mouseReleased(MouseEvent e) {
                CyMenus.this.zoomOutButton.setSelected(false);
            }
        });
        this.zoomOutButton.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() < 0) {
                    zoom_in.zoom();
                } else {
                    zoom_out.zoom();
                }
            }
        });
        this.zoomInButton.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() < 0) {
                    zoom_in.zoom();
                } else {
                    zoom_out.zoom();
                }
            }
        });
        this.toolBar.add(this.zoomOutButton);
        this.toolBar.add(this.zoomInButton);
        this.zoomSelectedButton = this.toolBar.add(new ZoomSelectedAction());
        this.zoomSelectedButton.setIcon(new ImageIcon(Cytoscape.class.getResource("images/ximian/stock_zoom-object.png")));
        this.zoomSelectedButton.setToolTipText("Zoom Selected Region");
        this.zoomSelectedButton.setBorderPainted(false);
        this.zoomDisplayAllButton = this.toolBar.add(new FitContentAction());
        this.zoomDisplayAllButton.setIcon(new ImageIcon(Cytoscape.class.getResource("images/ximian/stock_zoom-1.png")));
        this.zoomDisplayAllButton.setToolTipText("Zoom out to display all of current Network");
        this.zoomDisplayAllButton.setBorderPainted(false);
        this.toolBar.addSeparator();
        ExportAsGraphicsAction eag = new ExportAsGraphicsAction("PNG");
        eag.putValue("Name", null);
        this.snapshotButton = this.toolBar.add(eag);
        this.snapshotButton.setToolTipText("Export current network view as graphics");
        this.snapshotButton.setIcon(new ImageIcon(Cytoscape.class.getResource("images/ximian/tango-32-camera-photo.png")));
        this.snapshotButton.setBorderPainted(false);
        this.snapshotButton.setRolloverEnabled(true);
        this.toolBar.addSeparator();
        this.helpButton = new JButton();
        this.helpButton.addActionListener(new ActionListener(){
            private CSH.DisplayHelpFromSource csh;

            public void actionPerformed(ActionEvent e) {
                if (this.csh == null) {
                    try {
                        this.csh = new CSH.DisplayHelpFromSource(CyHelpBroker.getHelpBroker());
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Help cannot be started. Please see the manual on the Cytoscape website instead: http://cytoscape.org.", "ERROR", 0);
                        return;
                    }
                }
                this.csh.actionPerformed(e);
            }
        });
        this.helpButton.setIcon(new ImageIcon(Cytoscape.class.getResource("images/ximian/stock_help.png")));
        this.helpButton.setToolTipText("Help");
        this.helpButton.setBorderPainted(false);
        this.toolBar.add(this.helpButton);
        this.toolBar.addSeparator();
        this.vizButton = this.toolBar.add(new SetVisualPropertiesAction(false));
        this.vizButton.setIcon(new ImageIcon(Cytoscape.class.getResource("images/ximian/stock_file-with-objects.png")));
        this.vizButton.setToolTipText("Open VizMapper\u2122");
        this.vizButton.setBorderPainted(false);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (!e.getPropertyName().equals(Integer.toString(Cytoscape.SESSION_OPENED))) {
            return;
        }
        RecentlyOpenedTracker sessionTracker = Cytoscape.getRecentlyOpenedSessionTracker();
        if (sessionTracker == null) {
            return;
        }
        URL mostRecentlyAddedSession = sessionTracker.getMostRecentAddition();
        if (mostRecentlyAddedSession == null) {
            return;
        }
        this.recentlyOpenedSubMenu.add(new JMenuItem(new OpenRecentAction(mostRecentlyAddedSession)));
    }
}

