/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.CytoscapeVersion;
import cytoscape.data.webservice.ui.WebServiceContextMenuListener;
import cytoscape.util.undo.CyUndo;
import cytoscape.view.BirdsEyeViewHandler;
import cytoscape.view.CyHelpBroker;
import cytoscape.view.CyMenus;
import cytoscape.view.CyNetworkView;
import cytoscape.view.GraphViewController;
import cytoscape.view.NetworkPanel;
import cytoscape.view.NetworkViewManager;
import cytoscape.view.ToolCytoPanelListener;
import cytoscape.view.cytopanels.BiModalJSplitPane;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelImp;
import cytoscape.view.cytopanels.CytoPanelState;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.ui.HideEdgeListener;
import cytoscape.visual.ui.HideNodeListener;
import cytoscape.visual.ui.NestedNetworkListener;
import cytoscape.visual.ui.VizMapBypassNetworkListener;
import cytoscape.visual.ui.VizMapperMainPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.undo.UndoableEdit;

public class CytoscapeDesktop
extends JFrame
implements PropertyChangeListener {
    private static final long serialVersionUID = 2986320083629749014L;
    protected long lastPluginRegistryUpdate;
    protected int returnVal;
    private static final Dimension DEF_DESKTOP_SIZE = new Dimension(1000, 720);
    private static final int DEF_CONTROL_PANEL_WIDTH = 400;
    private static final int DEF_DATAPANEL_HEIGHT = 300;
    private static final int DEVIDER_SIZE = 4;
    public static final String NETWORK_VIEWS_SELECTED = "NETWORK_VIEWS_SELECTED";
    public static final String NETWORK_VIEW_FOCUSED = "NETWORK_VIEW_FOCUSED";
    public static final String NETWORK_VIEW_FOCUS = "NETWORK_VIEW_FOCUS";
    public static final String NETWORK_VIEW_CREATED = "NETWORK_VIEW_CREATED";
    public static final String NETWORK_VIEW_DESTROYED = "NETWORK_VIEW_DESTROYED";
    public static final String VISUAL_STYLE = "VISUAL_STYLE";
    public static final String VIZMAP_ENABLED = "VIZMAP_ENABLED";
    private static final String SMALL_ICON = "images/c16.png";
    protected VisualStyle defaultVisualStyle;
    protected NetworkPanel networkPanel;
    protected CyMenus cyMenus;
    protected NetworkViewManager networkViewManager;
    protected final SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);
    protected GraphViewController graphViewController;
    protected VisualMappingManager vmm;
    protected VizMapperMainPanel vizmapperUI;
    protected String currentNetworkID;
    protected String currentNetworkViewID;
    protected CytoPanelImp cytoPanelWest;
    protected CytoPanelImp cytoPanelEast;
    protected CytoPanelImp cytoPanelSouth;
    protected CytoPanelImp cytoPanelSouthWest;
    protected JLabel statusBar;
    protected final JPanel main_panel;
    protected int styleBoxIndex = -1;
    private BirdsEyeViewHandler bevh;
    private int defaultControlPanelWidth;
    private int defaultDataPanelHeight;
    private BiModalJSplitPane topRightPane;
    private BiModalJSplitPane rightPane;
    private BiModalJSplitPane masterPane;

    public CytoscapeDesktop() {
        super("Cytoscape Desktop (New Session)");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(Cytoscape.class.getResource(SMALL_ICON)));
        this.main_panel = new JPanel();
        this.main_panel.setLayout(new BorderLayout());
        this.networkViewManager = new NetworkViewManager(this);
        this.getBirdsEyeViewHandler();
        this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.bevh);
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this.bevh);
        this.networkPanel = new NetworkPanel(this);
        this.networkPanel.setNavigator(this.bevh.getBirdsEyeView());
        this.cyMenus = new CyMenus();
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.networkViewManager);
        this.networkViewManager.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.networkPanel);
        this.networkPanel.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(new VizMapBypassNetworkListener());
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(new NestedNetworkListener());
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(new WebServiceContextMenuListener());
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(new HideNodeListener());
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(new HideEdgeListener());
        this.cyMenus.initializeMenus();
        this.masterPane = this.setupCytoPanels(this.networkPanel, this.networkViewManager);
        this.main_panel.add((Component)this.masterPane, "Center");
        this.main_panel.add((Component)this.cyMenus.getToolBar(), "North");
        this.initStatusBar(this.main_panel);
        this.setJMenuBar(this.cyMenus.getMenuBar());
        this.getVizMapperUI();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                Cytoscape.exit(CytoscapeDesktop.this.returnVal);
            }
        });
        this.setContentPane(this.main_panel);
        this.setSize(DEF_DESKTOP_SIZE);
        this.pack();
        this.calculateProperPanelSize();
        this.masterPane.setDividerLocation(this.defaultControlPanelWidth);
        this.rightPane.setDividerLocation(this.getSize().height - this.defaultDataPanelHeight);
        this.masterPane.setDividerSize(4);
        this.setDesktopLocation();
        this.setVisible(true);
        this.toFront();
    }

    private void calculateProperPanelSize() {
        Dimension windowSize = this.getSize();
        this.defaultControlPanelWidth = (int)((double)windowSize.width * 0.4);
        if (this.defaultControlPanelWidth > 400) {
            this.defaultControlPanelWidth = 400;
        }
        this.defaultDataPanelHeight = (int)(windowSize.getHeight() * 0.3);
        if (this.defaultDataPanelHeight > 300) {
            this.defaultControlPanelWidth = 300;
        }
    }

    private void setDesktopLocation() {
        try {
            Properties props = new Properties();
            File desktop_prop_file = new File(CytoscapeInit.getConfigVersionDirectory(), "desktop.props");
            props.load(new FileInputStream(desktop_prop_file));
            this.setLocation(new Integer(props.get("x").toString()), new Integer(props.get("y").toString()));
            this.setSize(new Integer(props.get("w").toString()), new Integer(props.get("h").toString()));
        }
        catch (Exception e) {
            this.setLocationRelativeTo(null);
        }
    }

    private void initStatusBar(JPanel panel) {
        this.statusBar = new JLabel();
        this.statusBar.setFont(new Font("SansSerif", 0, 10));
        this.statusBar.setBorder(new EmptyBorder(0, 7, 0, 7));
        this.statusBar.setForeground(new Color(40, 40, 40));
        panel.add((Component)this.statusBar, "South");
        this.setStatusBarMsg("Welcome to Cytoscape " + CytoscapeVersion.version + "              Right-click + drag to ZOOM             Middle-click + drag to PAN");
    }

    public void setStatusBarMsg(String msg) {
        this.statusBar.setText(msg);
    }

    public void clearStatusBar() {
        this.statusBar.setText("   ");
    }

    public NetworkPanel getNetworkPanel() {
        return this.networkPanel;
    }

    public HelpBroker getHelpBroker() {
        return CyHelpBroker.getHelpBroker();
    }

    public HelpSet getHelpSet() {
        return CyHelpBroker.getHelpSet();
    }

    public void addEdit(UndoableEdit edit) {
        CyUndo.getUndoableEditSupport().postEdit(edit);
    }

    public int getViewType() {
        return 1;
    }

    public CyMenus getCyMenus() {
        return this.cyMenus;
    }

    public void setNewNetwork(CyNetwork newNetwork) {
    }

    public VizMapperMainPanel getVizMapperUI() {
        if (this.vizmapperUI == null) {
            this.vmm = Cytoscape.getVisualMappingManager();
            this.vizmapperUI = VizMapperMainPanel.getVizMapperUI();
            this.getCytoPanel(7).add("VizMapper\u2122", this.vizmapperUI);
            this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.vizmapperUI);
        }
        return this.vizmapperUI;
    }

    @Deprecated
    public VisualStyle setVisualStyle(VisualStyle style) {
        this.vmm.setVisualStyle(style);
        return null;
    }

    protected void updateFocus(String network_id) {
        VisualStyle old_style = this.vmm.getVisualStyle();
        CyNetworkView old_view = Cytoscape.getCurrentNetworkView();
        if (old_view != null) {
            old_view.putClientData(VISUAL_STYLE, old_style);
            old_view.putClientData(VIZMAP_ENABLED, new Boolean(old_view.getVisualMapperEnabled()));
        }
        Cytoscape.setCurrentNetwork(network_id);
        if (Cytoscape.setCurrentNetworkView(network_id)) {
            CyNetworkView new_view = Cytoscape.getCurrentNetworkView();
            VisualStyle new_style = new_view.getVisualStyle();
            Boolean vizmap_enabled = (Boolean)new_view.getClientData(VIZMAP_ENABLED);
            if (new_style == null) {
                new_style = this.vmm.getCalculatorCatalog().getVisualStyle("default");
            }
            if (vizmap_enabled == null) {
                vizmap_enabled = true;
            }
            this.vmm.setNetworkView(new_view);
            if (!new_style.getName().equals(old_style.getName())) {
                this.vmm.setVisualStyle(new_style);
                CyNetworkView curView = Cytoscape.getCurrentNetworkView();
                VisualStyle curViewStyle = curView.getVisualStyle();
                if (curView != Cytoscape.getNullNetworkView() && curViewStyle != null && !new_style.getName().equals(curViewStyle.getName())) {
                    Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                }
            }
        }
    }

    public void setFocus(String network_id) {
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, NETWORK_VIEW_FOCUSED, null, network_id));
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, NETWORK_VIEW_FOCUS, null, network_id));
    }

    public GraphViewController getGraphViewController() {
        if (this.graphViewController == null) {
            this.graphViewController = new GraphViewController();
        }
        return this.graphViewController;
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (NETWORK_VIEW_CREATED.equals(e.getPropertyName())) {
            this.getGraphViewController().addGraphView((CyNetworkView)e.getNewValue());
            this.pcs.firePropertyChange(e);
        } else if (NETWORK_VIEW_FOCUSED.equals(e.getPropertyName())) {
            this.updateFocus(e.getNewValue().toString());
            this.pcs.firePropertyChange(e);
        } else if (NETWORK_VIEW_FOCUS.equals(e.getPropertyName())) {
            this.updateFocus(e.getNewValue().toString());
            this.pcs.firePropertyChange(e);
        } else if (NETWORK_VIEWS_SELECTED.equals(e.getPropertyName())) {
            Cytoscape.setSelectedNetworkViews((List)e.getNewValue());
            Cytoscape.setSelectedNetworks((List)e.getNewValue());
            this.pcs.firePropertyChange(e);
        } else if (Cytoscape.NETWORK_CREATED.equals(e.getPropertyName())) {
            this.pcs.firePropertyChange(e);
        } else if (Cytoscape.NETWORK_DESTROYED.equals(e.getPropertyName())) {
            String message;
            int result;
            this.pcs.firePropertyChange(e);
            if (Cytoscape.getNetworkSet().size() == 0 && Cytoscape.getSessionstate() != Cytoscape.SESSION_OPENED && (result = JOptionPane.showConfirmDialog(this, message = "Do you want to create a new session?.\n(All attributes will be lost!)", "Create New Session?", 0, 2, null)) == 0) {
                Cytoscape.createNewSession();
            }
        } else if (NETWORK_VIEW_DESTROYED.equals(e.getPropertyName())) {
            this.getGraphViewController().removeGraphView((CyNetworkView)e.getNewValue());
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName().equalsIgnoreCase(Cytoscape.CYTOSCAPE_EXIT)) {
            File desktop_prop_file = new File(CytoscapeInit.getConfigVersionDirectory(), "desktop.props");
            Properties props = new Properties();
            props.setProperty("x", new Integer(this.getX()).toString());
            props.setProperty("y", new Integer(this.getY()).toString());
            props.setProperty("w", new Integer(this.getWidth()).toString());
            props.setProperty("h", new Integer(this.getHeight()).toString());
            try {
                props.store(new FileOutputStream(desktop_prop_file), "Remember desktop frame location");
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                Cytoscape.getRecentlyOpenedSessionTracker().writeOut();
            }
            catch (IOException ioe) {
                System.err.println("failed to save recent session URLs!");
            }
        }
    }

    public CytoPanel getCytoPanel(int compassDirection) {
        switch (compassDirection) {
            case 5: {
                return this.cytoPanelSouth;
            }
            case 3: {
                return this.cytoPanelEast;
            }
            case 7: {
                return this.cytoPanelWest;
            }
            case 6: {
                return this.cytoPanelSouthWest;
            }
        }
        throw new IllegalArgumentException("Illegal Argument:  " + compassDirection + ".  Must be one of:  SwingConstants.{SOUTH,EAST,WEST,SOUTH_WEST}.");
    }

    private BiModalJSplitPane setupCytoPanels(NetworkPanel networkPanel, NetworkViewManager networkViewManager) {
        this.topRightPane = this.createTopRightPane(networkViewManager);
        this.rightPane = this.createRightPane(this.topRightPane);
        this.masterPane = this.createMasterPane(networkPanel, this.rightPane);
        this.createBottomLeft();
        return this.masterPane;
    }

    protected void createBottomLeft() {
        this.cytoPanelSouthWest = new CytoPanelImp(6, 1, CytoPanelState.HIDE);
        BiModalJSplitPane split = new BiModalJSplitPane(this, 0, 2, new JPanel(), this.cytoPanelSouthWest);
        split.setResizeWeight(0.0);
        this.cytoPanelSouthWest.setCytoPanelContainer(split);
        this.cytoPanelSouthWest.setMinimumSize(new Dimension(180, 230));
        this.cytoPanelSouthWest.setMaximumSize(new Dimension(180, 230));
        this.cytoPanelSouthWest.setPreferredSize(new Dimension(180, 230));
        split.setDividerSize(4);
        new ToolCytoPanelListener(split, this.cytoPanelWest, this.cytoPanelSouthWest);
    }

    protected BiModalJSplitPane createTopRightPane(NetworkViewManager networkViewManager) {
        this.cytoPanelEast = new CytoPanelImp(3, 1, CytoPanelState.HIDE);
        BiModalJSplitPane splitPane = new BiModalJSplitPane(this, 1, 2, networkViewManager.getDesktopPane(), this.cytoPanelEast);
        this.cytoPanelEast.setCytoPanelContainer(splitPane);
        splitPane.setResizeWeight(1.0);
        return splitPane;
    }

    protected BiModalJSplitPane createRightPane(BiModalJSplitPane topRightPane) {
        this.cytoPanelSouth = new CytoPanelImp(5, 3, CytoPanelState.HIDE);
        BiModalJSplitPane splitPane = new BiModalJSplitPane(this, 0, 2, topRightPane, this.cytoPanelSouth);
        this.cytoPanelSouth.setCytoPanelContainer(splitPane);
        splitPane.setDividerSize(4);
        splitPane.setResizeWeight(1.0);
        return splitPane;
    }

    protected BiModalJSplitPane createMasterPane(NetworkPanel networkPanel, BiModalJSplitPane rightPane) {
        this.cytoPanelWest = new CytoPanelImp(7, 1, CytoPanelState.DOCK);
        String tab1Name = new String("Network");
        this.cytoPanelWest.add(tab1Name, new ImageIcon(Cytoscape.class.getResource("images/class_hi.gif")), networkPanel, "Cytoscape Network List");
        BiModalJSplitPane splitPane = new BiModalJSplitPane(this, 1, 1, this.cytoPanelWest, rightPane);
        splitPane.setDividerSize(4);
        this.cytoPanelWest.setCytoPanelContainer(splitPane);
        return splitPane;
    }

    public NetworkViewManager getNetworkViewManager() {
        return this.networkViewManager;
    }

    public BirdsEyeViewHandler getBirdsEyeViewHandler() {
        if (this.bevh == null) {
            this.bevh = new BirdsEyeViewHandler(this.networkViewManager.getDesktopPane());
        }
        return this.bevh;
    }

    public static int parseViewType(String vt) {
        return 1;
    }
}

