/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.customgraphic;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.logger.CyLogger;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.visual.SubjectBase;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.customgraphic.LoadImageTask;
import cytoscape.visual.customgraphic.NullCustomGraphics;
import cytoscape.visual.customgraphic.PersistImageTask;
import cytoscape.visual.customgraphic.Taggable;
import cytoscape.visual.customgraphic.impl.bitmap.URLImageCustomGraphics;
import cytoscape.visual.customgraphic.impl.vector.GradientOvalLayer;
import cytoscape.visual.customgraphic.impl.vector.GradientRoundRectangleLayer;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomGraphicsManager
extends SubjectBase
implements PropertyChangeListener {
    private static final CyLogger logger = CyLogger.getLogger();
    private static final int TIMEOUT = 1000;
    private static final int NUM_THREADS = 8;
    private static final String IMAGE_DIR_NAME = "images";
    private static final String IMAGE_EXT = "png";
    private final ExecutorService imageLoaderService;
    private final Map<Long, CyCustomGraphics> graphicsMap = new ConcurrentHashMap<Long, CyCustomGraphics>();
    private final Map<URL, Long> sourceMap = new ConcurrentHashMap<URL, Long>();
    private static final CyCustomGraphics NULL = NullCustomGraphics.getNullObject();
    private static final Class<?>[] DEF_VECTORS = new Class[]{GradientRoundRectangleLayer.class, GradientOvalLayer.class};
    public static final String METADATA_FILE = "image_metadata.props";
    private File imageHomeDirectory;

    public CustomGraphicsManager() {
        this.imageLoaderService = Executors.newFixedThreadPool(8);
        this.graphicsMap.put(NULL.getIdentifier(), NULL);
        this.restoreDefaultVectorImageObjects();
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(Cytoscape.CYTOSCAPE_EXIT, this);
        this.restoreImages();
    }

    private void restoreImages() {
        ExecutorCompletionService<BufferedImage> cs = new ExecutorCompletionService<BufferedImage>(this.imageLoaderService);
        this.imageHomeDirectory = new File(CytoscapeInit.getConfigDirectory(), IMAGE_DIR_NAME);
        this.imageHomeDirectory.mkdir();
        long startTime = System.currentTimeMillis();
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(new File(this.imageHomeDirectory, METADATA_FILE)));
            logger.info("Custom Graphics Image property file loaded from: " + this.imageHomeDirectory);
        }
        catch (Exception e) {
            logger.warning("Custom Graphics Metadata was not found.  This is normal for the first time.");
            return;
        }
        if (this.imageHomeDirectory != null && this.imageHomeDirectory.isDirectory()) {
            File[] imageFiles = this.imageHomeDirectory.listFiles();
            HashMap<Future<BufferedImage>, String> fMap = new HashMap<Future<BufferedImage>, String>();
            HashMap metatagMap = new HashMap();
            try {
                for (File file : imageFiles) {
                    String[] tagParts;
                    String fileName;
                    String key;
                    String value;
                    String[] imageProps;
                    if (!file.toString().endsWith(IMAGE_EXT) || (imageProps = (value = prop.getProperty(key = (fileName = file.getName()).split("\\.")[0])).split(",")) == null || imageProps.length < 2) continue;
                    String name = imageProps[2];
                    if (name.contains("___")) {
                        name = name.replace("___", ",");
                    }
                    Future<BufferedImage> f = cs.submit(new LoadImageTask(file.toURI().toURL()));
                    fMap.put(f, name);
                    String tagStr = null;
                    if (imageProps.length <= 3) continue;
                    tagStr = imageProps[3];
                    TreeSet<String> tags = new TreeSet<String>();
                    for (String tag : tagParts = tagStr.split("\\|")) {
                        tags.add(tag.trim());
                    }
                    metatagMap.put(f, tags);
                }
                for (File file : imageFiles) {
                    Future f;
                    BufferedImage image;
                    if (!file.toString().endsWith(IMAGE_EXT) || (image = (BufferedImage)(f = cs.take()).get()) == null) continue;
                    URLImageCustomGraphics cg = new URLImageCustomGraphics((String)fMap.get(f), image);
                    if (cg instanceof Taggable && metatagMap.get(f) != null) {
                        ((Taggable)cg).getTags().addAll((Collection)metatagMap.get(f));
                    }
                    this.graphicsMap.put(cg.getIdentifier(), cg);
                    try {
                        URL source = new URL((String)fMap.get(f));
                        if (source == null) continue;
                        this.sourceMap.put(source, cg.getIdentifier());
                    }
                    catch (MalformedURLException me) {
                        // empty catch block
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        try {
            this.imageLoaderService.shutdown();
            this.imageLoaderService.awaitTermination(1000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double sec = (double)(endTime - startTime) / 1000.0;
        logger.info("Image loading process finished in " + sec + " sec.");
        logger.info("Currently,  " + (this.graphicsMap.size() - 1) + " images are available.");
    }

    private void restoreDefaultVectorImageObjects() {
        for (Class<?> cls : DEF_VECTORS) {
            try {
                Object obj = cls.newInstance();
                if (!(obj instanceof CyCustomGraphics)) continue;
                this.graphicsMap.put(((CyCustomGraphics)obj).getIdentifier(), (CyCustomGraphics)obj);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void addGraphics(CyCustomGraphics graphics, URL source) {
        if (graphics == null) {
            throw new IllegalArgumentException("Custom Graphics and its ID should not be null.");
        }
        if (source != null) {
            this.sourceMap.put(source, graphics.getIdentifier());
        }
        this.graphicsMap.put(graphics.getIdentifier(), graphics);
    }

    public void removeGraphics(Long id) {
        CyCustomGraphics cg = this.graphicsMap.get(id);
        if (cg != null && cg != NULL) {
            this.graphicsMap.remove(id);
        }
    }

    public CyCustomGraphics getByID(Long id) {
        return this.graphicsMap.get(id);
    }

    public CyCustomGraphics getBySourceURL(URL sourceURL) {
        Long id = this.sourceMap.get(sourceURL);
        if (id != null) {
            return this.graphicsMap.get(id);
        }
        return null;
    }

    public Collection<CyCustomGraphics> getAll() {
        return this.graphicsMap.values();
    }

    public void removeAll() {
        this.graphicsMap.clear();
        this.sourceMap.clear();
        this.graphicsMap.put(NULL.getIdentifier(), NULL);
    }

    public Properties getMetadata() {
        this.graphicsMap.remove(NULL.getIdentifier());
        Properties props = new Properties();
        for (CyCustomGraphics graphics : this.graphicsMap.values()) {
            props.setProperty(graphics.getIdentifier().toString(), graphics.toString());
        }
        this.graphicsMap.put(NULL.getIdentifier(), NULL);
        return props;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.info("Saving images to: " + this.imageHomeDirectory);
        PersistImageTask task = new PersistImageTask(this.imageHomeDirectory);
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.displayCancelButton(false);
        jTaskConfig.setOwner(Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(false);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        TaskManager.executeTask(task, jTaskConfig);
        logger.info("Image saving process finished.");
    }

    public SortedSet<Long> getIDSet() {
        return new TreeSet<Long>(this.graphicsMap.keySet());
    }
}

