/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.strokes;

import cytoscape.visual.LineStyle;
import cytoscape.visual.strokes.ShapeStroke;
import cytoscape.visual.strokes.WidthStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class ParallelStroke
extends ShapeStroke {
    public ParallelStroke(float width) {
        super(new Shape[]{ParallelStroke.getParallelStroke(width)}, 1.0f, LineStyle.PARALLEL_LINES, width);
        this.width = width;
    }

    public WidthStroke newInstanceForWidth(float w) {
        return new ParallelStroke(w);
    }

    private static Shape getParallelStroke(float width) {
        GeneralPath shape = new GeneralPath();
        shape.moveTo(0.0f, -0.5f * width);
        shape.lineTo(1.0f, -0.5f * width);
        shape.lineTo(1.0f, -1.0f * width);
        shape.lineTo(0.0f, -1.0f * width);
        shape.lineTo(0.0f, -0.5f * width);
        shape.moveTo(0.0f, 0.5f * width);
        shape.lineTo(1.0f, 0.5f * width);
        shape.lineTo(1.0f, 1.0f * width);
        shape.lineTo(0.0f, 1.0f * width);
        shape.lineTo(0.0f, 0.5f * width);
        return shape;
    }
}

