/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.dialogs.SetNestedNetworkDialog;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.CyLayouts;
import cytoscape.view.CyNetworkView;
import ding.view.NodeContextMenuListener;
import giny.view.NodeView;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

class NestedNetworkMenuListener
implements NodeContextMenuListener {
    NestedNetworkMenuListener() {
    }

    public void addNodeContextMenuItems(NodeView nodeView, JPopupMenu menu) {
        if (menu == null) {
            menu = new JPopupMenu();
        }
        JMenu jm = new JMenu("Nested Network");
        JCheckBoxMenuItem jm1 = new JCheckBoxMenuItem(new SetNestedNetworkMenuItemAction(nodeView));
        JCheckBoxMenuItem jm2 = new JCheckBoxMenuItem(new DeleteNestedNetworkMenuItemAction(nodeView));
        JCheckBoxMenuItem jm3 = new JCheckBoxMenuItem(new GotoNestedNetworkMenuItemAction(nodeView));
        if (nodeView.getNode().getNestedNetwork() == null) {
            jm2.setEnabled(false);
            jm3.setEnabled(false);
        }
        jm.add(jm1);
        jm.add(jm2);
        jm.add(jm3);
        menu.add(jm);
    }

    private static final class GotoNestedNetworkMenuItemAction
    extends AbstractAction {
        private static final long serialVersionUID = -2090577740180052939L;
        private final NodeView nodeView;

        public GotoNestedNetworkMenuItemAction(NodeView nodeView) {
            super("Go to Nested Network");
            this.nodeView = nodeView;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.nodeView.getNode().getNestedNetwork() == null) {
                return;
            }
            CyNetwork nestedNetwork = (CyNetwork)this.nodeView.getNode().getNestedNetwork();
            CyNetworkView theView = Cytoscape.getNetworkView(nestedNetwork.getIdentifier());
            if (theView == null || theView.getIdentifier() == null) {
                theView = Cytoscape.createNetworkView(nestedNetwork);
                CyLayoutAlgorithm alg = CyLayouts.getLayout("force-directed");
                theView.applyLayout(alg);
            }
            Cytoscape.getDesktop().setFocus(nestedNetwork.getIdentifier());
        }
    }

    static class DeleteNestedNetworkMenuItemAction
    extends AbstractAction {
        private static final long serialVersionUID = -1413503506096197791L;
        private final NodeView nodeView;

        public DeleteNestedNetworkMenuItemAction(NodeView nodeView) {
            super("Delete Nested Network");
            this.nodeView = nodeView;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.nodeView.getNode().getNestedNetwork() == null) {
                return;
            }
            int user_says = JOptionPane.showConfirmDialog(Cytoscape.getDesktop(), "Are you sure you want to delete this nested network?", "Confirm Delete Nested Network", 0);
            if (user_says == 1) {
                return;
            }
            this.nodeView.getNode().setNestedNetwork(null);
        }
    }

    private static final class SetNestedNetworkMenuItemAction
    extends AbstractAction {
        private static final long serialVersionUID = 8460477959913047234L;
        private final NodeView nodeView;

        public SetNestedNetworkMenuItemAction(NodeView nodeView) {
            super("Set Nested Network");
            this.nodeView = nodeView;
        }

        public void actionPerformed(ActionEvent e) {
            SetNestedNetworkDialog dlg = new SetNestedNetworkDialog(Cytoscape.getDesktop(), true, this.nodeView);
            dlg.setLocationRelativeTo(Cytoscape.getDesktop());
            dlg.setVisible(true);
        }
    }
}

