/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import cytoscape.render.stateful.CustomGraphic;
import cytoscape.render.stateful.PaintFactory;
import ding.view.DNodeView;
import giny.view.ObjectPosition;
import giny.view.Position;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;

public class CustomGraphicsPositionCalculator {
    private static final Map<Position, Float[]> DISPLACEMENT_MAP = new HashMap<Position, Float[]>();

    public static CustomGraphic transform(ObjectPosition p, DNodeView nv, CustomGraphic cg) {
        Position anc = p.getAnchor();
        Position ancN = p.getTargetAnchor();
        double nodeW = nv.getWidth();
        double nodeH = nv.getHeight();
        double cgW = cg.getShape().getBounds().getWidth();
        double cgH = cg.getShape().getBounds().getHeight();
        Float[] disp1 = DISPLACEMENT_MAP.get((Object)anc);
        Float[] disp2 = DISPLACEMENT_MAP.get((Object)ancN);
        double dispX = (double)(-disp1[0].floatValue()) * nodeW;
        double dispY = (double)(-disp1[1].floatValue()) * nodeH;
        double dispNX = (double)disp2[0].floatValue() * cgW;
        double dispNY = (double)disp2[1].floatValue() * cgH;
        double totalDispX = dispX + dispNX + p.getOffsetX();
        double totalDispY = dispY + dispNY + p.getOffsetY();
        AffineTransform tf = AffineTransform.getTranslateInstance(totalDispX, totalDispY);
        Shape newShape = tf.createTransformedShape(cg.getShape());
        PaintFactory newFactory = cg.getPaintFactory();
        return new CustomGraphic(newShape, newFactory);
    }

    static {
        DISPLACEMENT_MAP.put(Position.CENTER, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f)});
        DISPLACEMENT_MAP.put(Position.NORTH, new Float[]{Float.valueOf(0.0f), Float.valueOf(-0.5f)});
        DISPLACEMENT_MAP.put(Position.NORTH_WEST, new Float[]{Float.valueOf(-0.5f), Float.valueOf(-0.5f)});
        DISPLACEMENT_MAP.put(Position.NORTH_EAST, new Float[]{Float.valueOf(0.5f), Float.valueOf(-0.5f)});
        DISPLACEMENT_MAP.put(Position.SOUTH, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.5f)});
        DISPLACEMENT_MAP.put(Position.SOUTH_WEST, new Float[]{Float.valueOf(-0.5f), Float.valueOf(0.5f)});
        DISPLACEMENT_MAP.put(Position.SOUTH_EAST, new Float[]{Float.valueOf(0.5f), Float.valueOf(0.5f)});
        DISPLACEMENT_MAP.put(Position.WEST, new Float[]{Float.valueOf(-0.5f), Float.valueOf(0.0f)});
        DISPLACEMENT_MAP.put(Position.EAST, new Float[]{Float.valueOf(0.5f), Float.valueOf(0.0f)});
    }
}

