/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import cytoscape.render.stateful.CustomGraphic;
import ding.view.CustomGraphicsPositionCalculator;
import ding.view.DGraphView;
import ding.view.GinyUtil;
import ding.view.GraphViewNodesSelectedEvent;
import ding.view.GraphViewNodesUnselectedEvent;
import ding.view.ObjectPositionImpl;
import giny.model.Node;
import giny.view.GraphView;
import giny.view.GraphViewChangeListener;
import giny.view.Justification;
import giny.view.Label;
import giny.view.NodeView;
import giny.view.ObjectPosition;
import giny.view.Position;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNodeView
implements NodeView,
Label {
    private static final float NESTED_IMAGE_SCALE_FACTOR = 0.6f;
    private static BufferedImage DEFAULT_NESTED_NETWORK_IMAGE;
    private static BufferedImage RECURSIVE_NESTED_NETWORK_IMAGE;
    private static int nestedNetworkPaintingDepth;
    static final float DEFAULT_WIDTH = 20.0f;
    static final float DEFAULT_HEIGHT = 20.0f;
    static final byte DEFAULT_SHAPE = 2;
    static final Paint DEFAULT_BORDER_PAINT;
    static final String DEFAULT_LABEL_TEXT = "";
    static final Font DEFAULT_LABEL_FONT;
    static final Paint DEFAULT_LABEL_PAINT;
    static final double DEFAULT_LABEL_WIDTH = 100.0;
    DGraphView graphView;
    private final int m_inx;
    private boolean m_selected;
    private Paint m_unselectedPaint;
    private Paint m_selectedPaint;
    private Paint m_borderPaint;
    float m_hiddenXMin = Float.MIN_VALUE;
    float m_hiddenYMin = Float.MIN_VALUE;
    float m_hiddenXMax = Float.MAX_VALUE;
    float m_hiddenYMax = Float.MAX_VALUE;
    private LinkedHashSet<CustomGraphic> _customGraphics;
    private final Object[] CG_LOCK = new Object[0];
    private static final HashSet<CustomGraphic> EMPTY_CUSTOM_GRAPHICS;
    private String m_toolTipText = null;
    private DGraphView nestedNetworkView;
    private boolean nestedNetworkVisible = true;
    private ObjectPosition labelPosition = new ObjectPositionImpl();
    private Map<CustomGraphic, ObjectPosition> graphicsPositions;
    private float m_borderDash = 0.0f;
    private float m_borderDash2 = 0.0f;
    private static final Color s_transparent;

    DNodeView(DGraphView view, int inx) {
        this.graphView = view;
        this.m_inx = ~inx;
        this.m_selected = false;
        this.m_unselectedPaint = this.graphView.m_nodeDetails.fillPaint(this.m_inx);
        this.m_selectedPaint = Color.yellow;
        this.m_borderPaint = this.graphView.m_nodeDetails.borderPaint(this.m_inx);
        this.nestedNetworkView = null;
    }

    @Override
    public GraphView getGraphView() {
        return this.graphView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getNode() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            return this.graphView.m_structPersp.getNode(~this.m_inx);
        }
    }

    @Override
    public int getGraphPerspectiveIndex() {
        return ~this.m_inx;
    }

    @Override
    public int getRootGraphIndex() {
        return ~this.m_inx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getEdgeViewsList(NodeView otherNodeView) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            return this.graphView.getEdgeViewsList(this.getNode(), otherNodeView.getNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getShape() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            byte nativeShape = this.graphView.m_nodeDetails.shape(this.m_inx);
            return GinyUtil.getGinyNodeType(nativeShape);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedPaint(Paint paint) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_selectedPaint = paint;
            if (this.isSelected()) {
                this.graphView.m_nodeDetails.overrideFillPaint(this.m_inx, this.m_selectedPaint);
                if (this.m_selectedPaint instanceof Color) {
                    this.graphView.m_nodeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_selectedPaint);
                }
                this.graphView.m_contentChanged = true;
            }
        }
    }

    @Override
    public Paint getSelectedPaint() {
        return this.m_selectedPaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnselectedPaint(Paint paint) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_unselectedPaint = paint;
            if (!this.isSelected()) {
                this.graphView.m_nodeDetails.overrideFillPaint(this.m_inx, this.m_unselectedPaint);
                if (this.m_unselectedPaint instanceof Color) {
                    this.graphView.m_nodeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_unselectedPaint);
                }
                this.graphView.m_contentChanged = true;
            }
        }
    }

    @Override
    public Paint getUnselectedPaint() {
        return this.m_unselectedPaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBorderPaint(Paint paint) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            this.m_borderPaint = paint;
            this.fixBorder();
            this.graphView.m_contentChanged = true;
        }
    }

    @Override
    public Paint getBorderPaint() {
        return this.m_borderPaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBorderWidth(float width) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            this.graphView.m_nodeDetails.overrideBorderWidth(this.m_inx, width);
            this.graphView.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getBorderWidth() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            return this.graphView.m_nodeDetails.borderWidth(this.m_inx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBorder(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            Object object = this.graphView.m_lock;
            synchronized (object) {
                this.setBorderWidth(((BasicStroke)stroke).getLineWidth());
                float[] dashArray = ((BasicStroke)stroke).getDashArray();
                if (dashArray != null && dashArray.length > 1) {
                    this.m_borderDash = dashArray[0];
                    this.m_borderDash2 = dashArray[1];
                } else {
                    this.m_borderDash = 0.0f;
                    this.m_borderDash2 = 0.0f;
                }
                this.fixBorder();
            }
        }
    }

    private void fixBorder() {
        if (this.m_borderDash == 0.0f && this.m_borderDash2 == 0.0f) {
            this.graphView.m_nodeDetails.overrideBorderPaint(this.m_inx, this.m_borderPaint);
        } else {
            int size = (int)Math.max(1.0f, (float)((int)(this.m_borderDash + this.m_borderDash2)));
            if (size != this.graphView.m_lastSize || this.m_borderPaint != this.graphView.m_lastPaint) {
                BufferedImage img = new BufferedImage(size, size, 2);
                Graphics2D g2 = (Graphics2D)img.getGraphics();
                g2.setComposite(AlphaComposite.getInstance(2));
                g2.setPaint(s_transparent);
                g2.fillRect(0, 0, size, size);
                g2.setPaint(this.m_borderPaint);
                g2.fillRect(0, 0, size / 2, size / 2);
                g2.fillRect(size / 2, size / 2, size / 2, size / 2);
                this.graphView.m_lastTexturePaint = new TexturePaint(img, new Rectangle2D.Double(0.0, 0.0, size, size));
                this.graphView.m_lastSize = size;
                this.graphView.m_lastPaint = this.m_borderPaint;
            }
            this.graphView.m_nodeDetails.overrideBorderPaint(this.m_inx, this.graphView.m_lastTexturePaint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stroke getBorder() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            if (this.m_borderDash == 0.0f && this.m_borderDash2 == 0.0f) {
                return new BasicStroke(this.getBorderWidth());
            }
            return new BasicStroke(this.getBorderWidth(), 2, 0, 10.0f, new float[]{this.m_borderDash, this.m_borderDash2}, 0.0f);
        }
    }

    @Override
    public void setTransparency(float trans) {
    }

    @Override
    public float getTransparency() {
        return 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setWidth(double width) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            if (!this.graphView.m_spacial.exists(this.m_inx, this.graphView.m_extentsBuff, 0)) {
                return false;
            }
            double xCenter = ((double)this.graphView.m_extentsBuff[0] + (double)this.graphView.m_extentsBuff[2]) / 2.0;
            double wDiv2 = width / 2.0;
            float xMax = (float)(xCenter + wDiv2);
            float xMin = (float)(xCenter - wDiv2);
            if (!(xMax > xMin)) {
                throw new IllegalArgumentException("width is too small");
            }
            this.graphView.m_spacial.delete(this.m_inx);
            this.graphView.m_spacial.insert(this.m_inx, xMin, this.graphView.m_extentsBuff[1], xMax, this.graphView.m_extentsBuff[3]);
            this.graphView.m_contentChanged = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getWidth() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            if (!this.graphView.m_spacial.exists(this.m_inx, this.graphView.m_extentsBuff, 0)) {
                return -1.0;
            }
            return (double)this.graphView.m_extentsBuff[2] - (double)this.graphView.m_extentsBuff[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setHeight(double height) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            if (!this.graphView.m_spacial.exists(this.m_inx, this.graphView.m_extentsBuff, 0)) {
                return false;
            }
            double yCenter = ((double)this.graphView.m_extentsBuff[1] + (double)this.graphView.m_extentsBuff[3]) / 2.0;
            double hDiv2 = height / 2.0;
            float yMax = (float)(yCenter + hDiv2);
            float yMin = (float)(yCenter - hDiv2);
            if (!(yMax > yMin)) {
                throw new IllegalArgumentException("height is too small max:" + yMax + " min:" + yMin + " center:" + yCenter + " height:" + height);
            }
            this.graphView.m_spacial.delete(this.m_inx);
            this.graphView.m_spacial.insert(this.m_inx, this.graphView.m_extentsBuff[0], yMin, this.graphView.m_extentsBuff[2], yMax);
            this.graphView.m_contentChanged = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getHeight() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            if (!this.graphView.m_spacial.exists(this.m_inx, this.graphView.m_extentsBuff, 0)) {
                return -1.0;
            }
            return (double)this.graphView.m_extentsBuff[3] - (double)this.graphView.m_extentsBuff[1];
        }
    }

    @Override
    public Label getLabel() {
        return this;
    }

    @Override
    public int getDegree() {
        return this.graphView.getGraphPerspective().getDegree(~this.m_inx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOffset(double x, double y) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            if (!this.graphView.m_spacial.exists(this.m_inx, this.graphView.m_extentsBuff, 0)) {
                return;
            }
            double wDiv2 = ((double)this.graphView.m_extentsBuff[2] - (double)this.graphView.m_extentsBuff[0]) / 2.0;
            double hDiv2 = ((double)this.graphView.m_extentsBuff[3] - (double)this.graphView.m_extentsBuff[1]) / 2.0;
            float xMin = (float)(x - wDiv2);
            float xMax = (float)(x + wDiv2);
            float yMin = (float)(y - hDiv2);
            float yMax = (float)(y + hDiv2);
            if (!(xMax > xMin)) {
                throw new IllegalStateException("width of node has degenerated to zero after rounding");
            }
            if (!(yMax > yMin)) {
                throw new IllegalStateException("height of node has degenerated to zero after rounding");
            }
            this.graphView.m_spacial.delete(this.m_inx);
            this.graphView.m_spacial.insert(this.m_inx, xMin, yMin, xMax, yMax);
            this.graphView.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point2D getOffset() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            if (!this.graphView.m_spacial.exists(this.m_inx, this.graphView.m_extentsBuff, 0)) {
                return null;
            }
            double xCenter = ((double)this.graphView.m_extentsBuff[0] + (double)this.graphView.m_extentsBuff[2]) / 2.0;
            double yCenter = ((double)this.graphView.m_extentsBuff[1] + (double)this.graphView.m_extentsBuff[3]) / 2.0;
            return new Point2D.Double(xCenter, yCenter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setXPosition(double xPos) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            boolean nodeVisible = this.graphView.m_spacial.exists(this.m_inx, this.graphView.m_extentsBuff, 0);
            double wDiv2 = nodeVisible ? ((double)this.graphView.m_extentsBuff[2] - (double)this.graphView.m_extentsBuff[0]) / 2.0 : (double)(this.m_hiddenXMax - this.m_hiddenXMin) / 2.0;
            float xMin = (float)(xPos - wDiv2);
            float xMax = (float)(xPos + wDiv2);
            if (!(xMax > xMin)) {
                throw new IllegalStateException("width of node has degenerated to zero after rounding");
            }
            if (nodeVisible) {
                this.graphView.m_spacial.delete(this.m_inx);
                this.graphView.m_spacial.insert(this.m_inx, xMin, this.graphView.m_extentsBuff[1], xMax, this.graphView.m_extentsBuff[3]);
                this.graphView.m_contentChanged = true;
            } else {
                this.m_hiddenXMax = xMax;
                this.m_hiddenXMin = xMin;
            }
        }
    }

    @Override
    public void setXPosition(double xPos, boolean update) {
        this.setXPosition(xPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXPosition() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            if (this.graphView.m_spacial.exists(this.m_inx, this.graphView.m_extentsBuff, 0)) {
                return ((double)this.graphView.m_extentsBuff[0] + (double)this.graphView.m_extentsBuff[2]) / 2.0;
            }
            return (double)(this.m_hiddenXMin + this.m_hiddenXMax) / 2.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setYPosition(double yPos) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            boolean nodeVisible = this.graphView.m_spacial.exists(this.m_inx, this.graphView.m_extentsBuff, 0);
            double hDiv2 = nodeVisible ? ((double)this.graphView.m_extentsBuff[3] - (double)this.graphView.m_extentsBuff[1]) / 2.0 : (double)(this.m_hiddenYMax - this.m_hiddenYMin) / 2.0;
            float yMin = (float)(yPos - hDiv2);
            float yMax = (float)(yPos + hDiv2);
            if (!(yMax > yMin)) {
                throw new IllegalStateException("height of node has degenerated to zero after rounding");
            }
            if (nodeVisible) {
                this.graphView.m_spacial.delete(this.m_inx);
                this.graphView.m_spacial.insert(this.m_inx, this.graphView.m_extentsBuff[0], yMin, this.graphView.m_extentsBuff[2], yMax);
                this.graphView.m_contentChanged = true;
            } else {
                this.m_hiddenYMax = yMax;
                this.m_hiddenYMin = yMin;
            }
        }
    }

    @Override
    public void setYPosition(double yPos, boolean update) {
        this.setYPosition(yPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYPosition() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            if (this.graphView.m_spacial.exists(this.m_inx, this.graphView.m_extentsBuff, 0)) {
                return ((double)this.graphView.m_extentsBuff[1] + (double)this.graphView.m_extentsBuff[3]) / 2.0;
            }
            return (double)(this.m_hiddenYMin + this.m_hiddenYMax) / 2.0;
        }
    }

    @Override
    public void setNodePosition(boolean animate) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void select() {
        GraphViewChangeListener listener;
        boolean somethingChanged;
        Object object = this.graphView.m_lock;
        synchronized (object) {
            somethingChanged = this.selectInternal();
            if (somethingChanged) {
                this.graphView.m_contentChanged = true;
            }
        }
        if (somethingChanged && (listener = this.graphView.m_lis[0]) != null) {
            listener.graphViewChanged(new GraphViewNodesSelectedEvent(this.graphView, new int[]{~this.m_inx}));
        }
    }

    boolean selectInternal() {
        if (this.m_selected) {
            return false;
        }
        this.m_selected = true;
        this.graphView.m_nodeDetails.overrideFillPaint(this.m_inx, this.m_selectedPaint);
        if (this.m_selectedPaint instanceof Color) {
            this.graphView.m_nodeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_selectedPaint);
        }
        this.graphView.m_selectedNodes.insert(this.m_inx);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unselect() {
        GraphViewChangeListener listener;
        boolean somethingChanged;
        Object object = this.graphView.m_lock;
        synchronized (object) {
            somethingChanged = this.unselectInternal();
            if (somethingChanged) {
                this.graphView.m_contentChanged = true;
            }
        }
        if (somethingChanged && (listener = this.graphView.m_lis[0]) != null) {
            listener.graphViewChanged(new GraphViewNodesUnselectedEvent(this.graphView, new int[]{~this.m_inx}));
        }
    }

    boolean unselectInternal() {
        if (!this.m_selected) {
            return false;
        }
        this.m_selected = false;
        this.graphView.m_nodeDetails.overrideFillPaint(this.m_inx, this.m_unselectedPaint);
        if (this.m_unselectedPaint instanceof Color) {
            this.graphView.m_nodeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_unselectedPaint);
        }
        this.graphView.m_selectedNodes.delete(this.m_inx);
        return true;
    }

    @Override
    public boolean isSelected() {
        return this.m_selected;
    }

    @Override
    public boolean setSelected(boolean selected) {
        if (selected) {
            this.select();
        } else {
            this.unselect();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShape(int shape) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            byte nativeShape = GinyUtil.getNativeNodeType(shape);
            this.graphView.m_nodeDetails.overrideShape(this.m_inx, nativeShape);
            this.graphView.m_contentChanged = true;
        }
    }

    @Override
    public void setToolTip(String tip) {
        this.m_toolTipText = tip;
    }

    public String getToolTip() {
        return this.m_toolTipText;
    }

    public void setPositionHint(int position) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Paint getTextPaint() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            return this.graphView.m_nodeDetails.labelPaint(this.m_inx, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTextPaint(Paint textPaint) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            this.graphView.m_nodeDetails.overrideLabelPaint(this.m_inx, 0, textPaint);
            this.graphView.m_contentChanged = true;
        }
    }

    @Override
    public double getGreekThreshold() {
        return 0.0;
    }

    @Override
    public void setGreekThreshold(double threshold) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getText() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            return this.graphView.m_nodeDetails.labelText(this.m_inx, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(String text) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            this.graphView.m_nodeDetails.overrideLabelText(this.m_inx, 0, text);
            if (DEFAULT_LABEL_TEXT.equals(this.graphView.m_nodeDetails.labelText(this.m_inx, 0))) {
                this.graphView.m_nodeDetails.overrideLabelCount(this.m_inx, 0);
            } else {
                this.graphView.m_nodeDetails.overrideLabelCount(this.m_inx, 1);
            }
            this.graphView.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Font getFont() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            return this.graphView.m_nodeDetails.labelFont(this.m_inx, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFont(Font font) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            this.graphView.m_nodeDetails.overrideLabelFont(this.m_inx, 0, font);
            this.graphView.m_contentChanged = true;
        }
    }

    public CustomGraphic addCustomGraphic(Shape shape, Paint paint, byte anchor) {
        CustomGraphic cg = new CustomGraphic(shape, paint, anchor);
        this.addCustomGraphic(cg);
        return cg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCustomGraphic(CustomGraphic cg) {
        boolean retVal = false;
        Object[] objectArray = this.CG_LOCK;
        synchronized (this.CG_LOCK) {
            if (this._customGraphics == null) {
                this._customGraphics = new LinkedHashSet();
                this.graphicsPositions = new HashMap<CustomGraphic, ObjectPosition>();
            }
            retVal = this._customGraphics.contains(cg) ? false : this._customGraphics.add(cg);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.ensureContentChanged();
            return retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsCustomGraphic(CustomGraphic cg) {
        Object[] objectArray = this.CG_LOCK;
        synchronized (this.CG_LOCK) {
            if (this._customGraphics == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this._customGraphics.contains(cg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CustomGraphic> customGraphicIterator() {
        Object[] objectArray = this.CG_LOCK;
        synchronized (this.CG_LOCK) {
            HashSet<CustomGraphic> toIterate = this._customGraphics == null ? EMPTY_CUSTOM_GRAPHICS : this._customGraphics;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return new ReadOnlyIterator<CustomGraphic>(toIterate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCustomGraphic(CustomGraphic cg) {
        boolean retVal = false;
        Object[] objectArray = this.CG_LOCK;
        synchronized (this.CG_LOCK) {
            if (this._customGraphics != null) {
                retVal = this._customGraphics.remove(cg);
                this.graphicsPositions.remove(cg);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.ensureContentChanged();
            return retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCustomGraphics() {
        Object[] objectArray = this.CG_LOCK;
        synchronized (this.CG_LOCK) {
            if (this._customGraphics != null) {
                this._customGraphics.clear();
                this.graphicsPositions.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.ensureContentChanged();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumCustomGraphics() {
        Object[] objectArray = this.CG_LOCK;
        synchronized (this.CG_LOCK) {
            if (this._customGraphics == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._customGraphics.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureContentChanged() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            this.graphView.m_contentChanged = true;
        }
    }

    public Object customGraphicLock() {
        return this.CG_LOCK;
    }

    @Override
    @Deprecated
    public void setTextAnchor(int position) {
        this.labelPosition.setAnchor(Position.parse(position));
    }

    @Override
    @Deprecated
    public int getTextAnchor() {
        return this.labelPosition.getAnchor().getGinyConstant();
    }

    @Override
    @Deprecated
    public void setJustify(int justify) {
        this.labelPosition.setJustify(Justification.parse(justify));
    }

    @Override
    @Deprecated
    public int getJustify() {
        return this.labelPosition.getJustify().getGinyConstant();
    }

    @Override
    @Deprecated
    public void setLabelOffsetX(double x) {
        this.labelPosition.setOffsetX(x);
    }

    @Override
    @Deprecated
    public double getLabelOffsetX() {
        return this.labelPosition.getOffsetX();
    }

    @Override
    @Deprecated
    public void setLabelOffsetY(double y) {
        this.labelPosition.setOffsetY(y);
    }

    @Override
    @Deprecated
    public double getLabelOffsetY() {
        return this.labelPosition.getOffsetY();
    }

    @Override
    @Deprecated
    public void setNodeLabelAnchor(int position) {
        this.labelPosition.setTargetAnchor(Position.parse(position));
    }

    @Override
    @Deprecated
    public int getNodeLabelAnchor() {
        return this.labelPosition.getTargetAnchor().getGinyConstant();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getLabelWidth() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            return this.graphView.m_nodeDetails.labelWidth(this.m_inx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLabelWidth(double width) {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            this.graphView.m_nodeDetails.overrideLabelWidth(this.m_inx, width);
            this.graphView.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TexturePaint getNestedNetworkTexturePaint() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            ++nestedNetworkPaintingDepth;
            try {
                if (nestedNetworkPaintingDepth > 1 || this.getNode().getNestedNetwork() == null || !this.nestedNetworkVisible) {
                    TexturePaint texturePaint = null;
                    return texturePaint;
                }
                double IMAGE_WIDTH = this.getWidth() * (double)0.6f;
                double IMAGE_HEIGHT = this.getHeight() * (double)0.6f;
                if (this.graphView == this.nestedNetworkView) {
                    if (RECURSIVE_NESTED_NETWORK_IMAGE == null) {
                        TexturePaint texturePaint = null;
                        return texturePaint;
                    }
                    Rectangle2D.Double rect = new Rectangle2D.Double(-IMAGE_WIDTH / 2.0, -IMAGE_HEIGHT / 2.0, IMAGE_WIDTH, IMAGE_HEIGHT);
                    TexturePaint texturePaint = new TexturePaint(RECURSIVE_NESTED_NETWORK_IMAGE, rect);
                    return texturePaint;
                }
                if (this.nestedNetworkView != null) {
                    TexturePaint rect = this.nestedNetworkView.getSnapshot(IMAGE_WIDTH, IMAGE_HEIGHT);
                    return rect;
                }
                if (DEFAULT_NESTED_NETWORK_IMAGE == null) {
                    TexturePaint rect = null;
                    return rect;
                }
                Rectangle2D.Double rect = new Rectangle2D.Double(-IMAGE_WIDTH / 2.0, -IMAGE_HEIGHT / 2.0, IMAGE_WIDTH, IMAGE_HEIGHT);
                TexturePaint texturePaint = new TexturePaint(DEFAULT_NESTED_NETWORK_IMAGE, rect);
                return texturePaint;
            }
            finally {
                --nestedNetworkPaintingDepth;
            }
        }
    }

    public void setNestedNetworkView(DGraphView nestedNetworkView) {
        this.nestedNetworkView = nestedNetworkView;
    }

    @Override
    public boolean nestedNetworkIsVisible() {
        return this.nestedNetworkVisible;
    }

    @Override
    public void showNestedNetwork(boolean makeVisible) {
        this.nestedNetworkVisible = makeVisible;
    }

    @Override
    public ObjectPosition getPosition() {
        return this.labelPosition;
    }

    @Override
    public void setPosition(ObjectPosition p) {
        this.labelPosition = p;
        this.updateLabelPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLabelPosition() {
        Object object = this.graphView.m_lock;
        synchronized (object) {
            this.graphView.m_nodeDetails.overrideLabelTextAnchor(this.m_inx, 0, this.labelPosition.getAnchor().getGinyConstant());
            this.graphView.m_nodeDetails.overrideLabelNodeAnchor(this.m_inx, 0, this.labelPosition.getTargetAnchor().getGinyConstant());
            this.graphView.m_nodeDetails.overrideLabelJustify(this.m_inx, 0, this.labelPosition.getJustify().getGinyConstant());
            this.graphView.m_nodeDetails.overrideLabelOffsetVectorX(this.m_inx, 0, this.labelPosition.getOffsetX());
            this.graphView.m_nodeDetails.overrideLabelOffsetVectorY(this.m_inx, 0, this.labelPosition.getOffsetY());
            this.graphView.m_contentChanged = true;
        }
    }

    public CustomGraphic setCustomGraphicsPosition(CustomGraphic cg, ObjectPosition p) {
        if (cg == null || p == null) {
            throw new IllegalArgumentException("CustomGraphic and Position cannot be null.");
        }
        boolean removeTest = this._customGraphics.remove(cg);
        this.graphicsPositions.remove(cg);
        CustomGraphic newCg = CustomGraphicsPositionCalculator.transform(p, this, cg);
        this._customGraphics.add(newCg);
        this.graphicsPositions.put(newCg, p);
        return newCg;
    }

    public ObjectPosition getCustomGraphicsPosition(CustomGraphic cg) {
        if (cg == null) {
            return ObjectPositionImpl.DEFAULT_POSITION;
        }
        return this.graphicsPositions.get(cg);
    }

    @Override
    public ObjectPosition getLabelPosition() {
        return this.labelPosition;
    }

    @Override
    public void setLabelPosition(ObjectPosition position) {
        this.setPosition(position);
    }

    static {
        nestedNetworkPaintingDepth = 0;
        try {
            DEFAULT_NESTED_NETWORK_IMAGE = ImageIO.read(DNodeView.class.getClassLoader().getResource("resources/images/default_network.png"));
            RECURSIVE_NESTED_NETWORK_IMAGE = ImageIO.read(DNodeView.class.getClassLoader().getResource("resources/images/recursive_network.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
            DEFAULT_NESTED_NETWORK_IMAGE = null;
            RECURSIVE_NESTED_NETWORK_IMAGE = null;
        }
        DEFAULT_BORDER_PAINT = Color.black;
        DEFAULT_LABEL_FONT = new Font(null, 0, 1);
        DEFAULT_LABEL_PAINT = Color.black;
        EMPTY_CUSTOM_GRAPHICS = new LinkedHashSet<CustomGraphic>(0);
        s_transparent = new Color(0, 0, 0, 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReadOnlyIterator<T>
    implements Iterator<T> {
        private Iterator<? extends T> _iterator;

        public ReadOnlyIterator(Iterable<T> toIterate) {
            this._iterator = toIterate.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public T next() {
            return this._iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

