/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.program.abi.ABITrace;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class AbiTraceRenderer
extends AbstractChangeable
implements SequenceRenderer {
    public static final ChangeType TRACE = new ChangeType("The trace has changed", AbiTraceRenderer.class, "TRACE", SequenceRenderContext.LAYOUT);
    public static final ChangeType DEPTH = new ChangeType("The trace render depth has changed", AbiTraceRenderer.class, "DEPTH", SequenceRenderContext.LAYOUT);
    private ABITrace trace;
    private double depth;

    public void paint(Graphics2D g, SequenceRenderContext ctxt) {
        if (ctxt.getDirection() == 1 || this.trace == null) {
            return;
        }
        try {
            Rectangle2D clip = g.getClip().getBounds2D();
            int min = Math.max(ctxt.getRange().getMin(), ctxt.graphicsToSequence(clip.getMinX()));
            int max = Math.min(ctxt.getRange().getMax(), ctxt.graphicsToSequence(clip.getMaxX()));
            int[] baseCalls = this.trace.getBasecalls();
            int[] traceA = this.trace.getTrace(DNATools.a());
            int[] traceG = this.trace.getTrace(DNATools.g());
            int[] traceC = this.trace.getTrace(DNATools.c());
            int[] traceT = this.trace.getTrace(DNATools.t());
            g.setColor(Color.green);
            this.renderTrace(baseCalls, traceA, g, ctxt, min, max);
            g.setColor(Color.black);
            this.renderTrace(baseCalls, traceG, g, ctxt, min, max);
            g.setColor(Color.blue);
            this.renderTrace(baseCalls, traceC, g, ctxt, min, max);
            g.setColor(Color.red);
            this.renderTrace(baseCalls, traceT, g, ctxt, min, max);
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Can't process trace file", ise);
        }
    }

    private void renderTrace(int[] baseCalls, int[] trace, Graphics2D g, SequenceRenderContext ctxt, int min, int max) {
        double depthScale = this.depth / 2000.0;
        Line2D.Float line = new Line2D.Float();
        for (int pos = min; pos <= max; ++pos) {
            int minT = pos == 1 ? 0 : (baseCalls[pos - 2] + baseCalls[pos - 1]) / 2;
            int maxT = pos == baseCalls.length ? trace.length - 1 : (baseCalls[pos - 1] + baseCalls[pos - 0]) / 2;
            double scale = ctxt.getScale() / (double)(maxT - minT);
            double stg = ctxt.sequenceToGraphics(pos);
            for (int i = minT; i < maxT; ++i) {
                int j = i - minT;
                ((Line2D)line).setLine(stg + scale * (0.5 + (double)j), this.depth - (double)trace[i] * depthScale, stg + scale * (0.5 + (double)j + 1.0), this.depth - (double)trace[i + 1] * depthScale);
                g.draw(line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrace(ABITrace trace) throws ChangeVetoException {
        ChangeSupport cs;
        ChangeSupport changeSupport = cs = this.getChangeSupport(TRACE);
        synchronized (changeSupport) {
            ChangeEvent ce = new ChangeEvent(this, TRACE, trace, this.trace);
            cs.firePreChangeEvent(ce);
            this.trace = trace;
            cs.firePostChangeEvent(ce);
        }
    }

    public ABITrace getTrace() {
        return this.trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDepth(double depth) throws ChangeVetoException {
        ChangeSupport cs;
        if (depth < 0.0) {
            throw new ChangeVetoException("Can't set depth to a negative number: " + depth);
        }
        ChangeSupport changeSupport = cs = this.getChangeSupport(DEPTH);
        synchronized (changeSupport) {
            ChangeEvent ce = new ChangeEvent(this, DEPTH, new Double(depth), new Double(this.depth));
            cs.firePreChangeEvent(ce);
            this.depth = depth;
            cs.firePostChangeEvent(ce);
        }
    }

    public double getDepth(SequenceRenderContext src) {
        if (src.getDirection() == 0 && this.trace != null) {
            return this.depth;
        }
        return 0.0;
    }

    public double getMinimumLeader(SequenceRenderContext src) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext src) {
        return 0.0;
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext src, MouseEvent me, List path) {
        return null;
    }
}

