/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.biojava.bio.program.indexdb.IndexStore;
import org.biojava.bio.program.tagvalue.Index2Model;
import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.utils.ParserException;
import org.biojava.utils.SmallMap;
import org.biojava.utils.SmallSet;
import org.biojava.utils.io.CountedBufferedReader;
import org.biojava.utils.io.RAF;

public class Indexer2
implements TagValueListener {
    private final String primaryKeyName;
    private final RAF file;
    private final CountedBufferedReader reader;
    private final IndexStore indexStore;
    private final Map keys;
    private final Map keyValues;
    private Object tag;
    private long offset;
    private int depth;
    private Stack stack;

    public Indexer2(File file, IndexStore indexStore, Index2Model model) throws FileNotFoundException {
        this.file = new RAF(file, "r");
        this.reader = new CountedBufferedReader(new FileReader(file));
        this.indexStore = indexStore;
        this.keyValues = new SmallMap();
        this.depth = 0;
        this.stack = new Stack();
        this.keys = new SmallMap();
        Iterator i = model.getKeys().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object[] val = model.getKeyPath(key);
            this.keys.put(val, key);
        }
        this.primaryKeyName = model.getPrimaryKeyName();
    }

    public CountedBufferedReader getReader() {
        return this.reader;
    }

    public void startRecord() {
        if (this.depth == 0) {
            this.offset = this.reader.getFilePointer();
            Frame frame = new Frame();
            Iterator ki = this.keys.keySet().iterator();
            while (ki.hasNext()) {
                Object[] keyPath = (Object[])ki.next();
                if (keyPath.length == 1) {
                    frame.addKey(keyPath);
                    continue;
                }
                frame.paths.add(keyPath);
            }
            this.stack.push(frame);
        } else {
            Frame top = (Frame)this.stack.peek();
            Frame frame = new Frame();
            Iterator ki = top.paths.iterator();
            while (ki.hasNext()) {
                Object[] keyPath = (Object[])ki.next();
                if (!keyPath[this.depth - 1].equals(this.tag)) continue;
                if (keyPath.length - 1 == this.depth) {
                    frame.addKey(keyPath);
                    continue;
                }
                frame.paths.add(keyPath);
            }
            this.stack.push(frame);
        }
        ++this.depth;
    }

    public void startTag(Object tag) {
        this.tag = tag;
    }

    public void value(TagValueContext ctxt, Object value) {
        Frame frame = (Frame)this.stack.peek();
        Object[] keyPath = frame.getKeyPath(this.tag);
        if (keyPath != null) {
            KeyState ks = (KeyState)this.keyValues.get(keyPath);
            if (ks == null) {
                ks = new KeyState(this.keys.get(keyPath).toString());
                this.keyValues.put(keyPath, ks);
            }
            ks.values.add(value);
        }
    }

    public void endTag() {
    }

    public void endRecord() throws ParserException {
        --this.depth;
        if (this.depth == 0) {
            int length = (int)(this.reader.getFilePointer() - this.offset);
            String primaryKeyValue = null;
            SmallMap secKeys = new SmallMap();
            Iterator<Object> i = this.keyValues.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                KeyState ks = (KeyState)this.keyValues.get(key);
                if (ks.keyName.equals(this.primaryKeyName)) {
                    if (ks.values.size() != 1) {
                        throw new ParserException("There must be exactly one value for the primary key: " + this.primaryKeyName + " - " + ks.values);
                    }
                    primaryKeyValue = ks.values.iterator().next().toString();
                    continue;
                }
                secKeys.put(ks.keyName, ks.values);
            }
            if (primaryKeyValue == null) {
                throw new NullPointerException("No primary key");
            }
            this.indexStore.writeRecord(this.file, this.offset, length, primaryKeyValue, secKeys);
            this.stack.clear();
            i = this.keyValues.values().iterator();
            while (i.hasNext()) {
                KeyState ks = (KeyState)i.next();
                ks.values.clear();
            }
        } else {
            this.stack.pop();
        }
    }

    private static class KeyState {
        public final String keyName;
        public final Set values = new SmallSet();

        public KeyState(String keyName) {
            this.keyName = keyName;
        }

        public String toString() {
            return this.getClass() + ": (" + this.keyName + " " + this.values + ")";
        }
    }

    private static class Frame {
        public final Map keys = new SmallMap();
        public final Set paths = new SmallSet();

        private Frame() {
        }

        public void addKey(Object[] keyPath) {
            this.keys.put(keyPath[keyPath.length - 1], keyPath);
        }

        public Object[] getKeyPath(Object tag) {
            return (Object[])this.keys.get(tag);
        }

        public String toString() {
            return this.getClass() + ": (" + this.keys + "\t" + this.paths + " )";
        }
    }
}

