/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.CrossProductTokenization;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.Unchangeable;

class InfiniteCrossProductAlphabet
extends Unchangeable
implements Alphabet,
Serializable {
    private final List alphas;
    private char tokenSeed = (char)65;

    InfiniteCrossProductAlphabet(List alphas) {
        this.alphas = alphas;
    }

    public Symbol getAmbiguity(Set symSet) {
        throw new BioError("Not implemented yet");
    }

    public String getName() {
        StringBuffer name = new StringBuffer("(");
        for (int i = 0; i < this.alphas.size(); ++i) {
            Alphabet a = (Alphabet)this.alphas.get(i);
            name.append(a.getName());
            if (i >= this.alphas.size() - 1) continue;
            name.append(" x ");
        }
        name.append(")");
        return name.substring(0);
    }

    public boolean contains(Symbol s) {
        if (!(s instanceof AtomicSymbol)) {
            Alphabet ma = s.getMatches();
            if (ma instanceof FiniteAlphabet) {
                Iterator i = ((FiniteAlphabet)ma).iterator();
                while (i.hasNext()) {
                    if (this.contains((Symbol)i.next())) continue;
                    return false;
                }
                return true;
            }
            throw new BioError("Problem: Can't work out if I contain ambiguity symbol " + s.getName());
        }
        AtomicSymbol cs = (AtomicSymbol)s;
        List sl = cs.getSymbols();
        if (sl.size() != this.alphas.size()) {
            return false;
        }
        Iterator ai = this.alphas.iterator();
        Iterator si = sl.iterator();
        while (ai.hasNext() && si.hasNext()) {
            Symbol ss;
            Alphabet aa = (Alphabet)ai.next();
            if (aa.contains(ss = (Symbol)si.next())) continue;
            return false;
        }
        return true;
    }

    public void validate(Symbol s) throws IllegalSymbolException {
        if (!this.contains(s)) {
            throw new IllegalSymbolException("CrossProductAlphabet " + this.getName() + " does not accept " + s.getName() + " as it is not an instance of CrossProductSymbol or " + " an AmbiguitySymbol over a subset of symbols in this alphabet.");
        }
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public List getAlphabets() {
        return this.alphas;
    }

    public Symbol getSymbol(List sList) throws IllegalSymbolException {
        if (sList.size() != this.alphas.size()) {
            throw new IllegalSymbolException("List of symbols is the wrong length (" + this.alphas.size() + ":" + sList.size() + ")");
        }
        Iterator ai = this.alphas.iterator();
        Iterator si = sList.iterator();
        while (ai.hasNext() && si.hasNext()) {
            Symbol ss;
            Alphabet aa = (Alphabet)ai.next();
            if (aa.contains(ss = (Symbol)si.next())) continue;
            throw new IllegalSymbolException("CrossProductAlphabet " + this.getName() + " does not accept " + sList + " as symbol " + ss.getName() + " is not a member of the alphabet " + aa.getName());
        }
        return AlphabetManager.createSymbol(Annotation.EMPTY_ANNOTATION, sList, (Alphabet)this);
    }

    public Symbol getGapSymbol() {
        return AlphabetManager.getGapSymbol(this.getAlphabets());
    }

    public SymbolTokenization getTokenization(String name) throws NoSuchElementException, BioException {
        if (name == "name") {
            return new CrossProductTokenization(this);
        }
        throw new NoSuchElementException("No parser for " + name + " is defined for " + this.getName());
    }
}

