/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.lsid;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.biojava.utils.lsid.LifeScienceIdentifierParseException;

public final class LifeScienceIdentifier
implements Serializable {
    private final String authorityId;
    private final String namespaceId;
    private final String objectId;
    private final String revisionId;
    private static final long serialVersionUID = 8478038493421763123L;

    private LifeScienceIdentifier(String authorityId, String namespaceId, String objectId, String revisionId) {
        if (authorityId == null) {
            throw new IllegalArgumentException("authority must not be null");
        }
        if (namespaceId == null) {
            throw new IllegalArgumentException("namespace must not be null");
        }
        if (objectId == null) {
            throw new IllegalArgumentException("objectId must not be null");
        }
        this.authorityId = authorityId;
        this.namespaceId = namespaceId;
        this.objectId = objectId;
        this.revisionId = revisionId;
    }

    public String getAuthorityId() {
        return this.authorityId;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public boolean equals(Object value) {
        if (this == value) {
            return true;
        }
        if (!(value instanceof LifeScienceIdentifier)) {
            return false;
        }
        LifeScienceIdentifier lsid = (LifeScienceIdentifier)value;
        return this.authorityId.equals(lsid.getAuthorityId()) && this.namespaceId.equals(lsid.getNamespaceId()) && this.objectId.equals(lsid.getObjectId()) && (this.revisionId == null ? lsid.getRevisionId() == null : this.revisionId.equals(lsid.getRevisionId()));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("urn:lsid:");
        sb.append(this.getAuthorityId());
        sb.append(":");
        sb.append(this.getNamespaceId());
        sb.append(":");
        sb.append(this.getObjectId());
        if (this.getRevisionId() != null) {
            sb.append(":");
            sb.append(this.getRevisionId());
        }
        return sb.toString();
    }

    public static LifeScienceIdentifier valueOf(String lsid) throws LifeScienceIdentifierParseException {
        if (lsid.length() < 9) {
            throw new LifeScienceIdentifierParseException("couldn't parse: " + lsid + ", didn't contain urn prefix");
        }
        String urnPrefix = lsid.substring(0, 9);
        lsid = lsid.substring(9);
        if (!"urn:lsid:".equalsIgnoreCase(urnPrefix)) {
            throw new LifeScienceIdentifierParseException("couldn't parse: " + lsid + ", incorrect urn prefix");
        }
        StringTokenizer st = new StringTokenizer(lsid, ":", true);
        int count = st.countTokens();
        if (count >= 5) {
            String authorityId = st.nextToken();
            st.nextToken();
            String namespaceId = st.nextToken();
            st.nextToken();
            String objectId = st.nextToken();
            String revisionId = null;
            if (count >= 6) {
                st.nextToken();
                revisionId = "";
            }
            if (st.hasMoreTokens()) {
                revisionId = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                throw new LifeScienceIdentifierParseException("couldn't parse: " + lsid + ", too many tokens");
            }
            return LifeScienceIdentifier.valueOf(authorityId, namespaceId, objectId, revisionId);
        }
        throw new LifeScienceIdentifierParseException("couldn't parse: " + lsid + ", badly formatted lsid");
    }

    public static LifeScienceIdentifier valueOf(String authorityId, String namespaceId, String objectId, String revisionId) {
        if (authorityId == null || namespaceId == null || objectId == null) {
            throw new NullPointerException("all of authorityId, namespaceId, objectId must not be null");
        }
        return new LifeScienceIdentifier(authorityId, namespaceId, objectId, revisionId);
    }

    public static LifeScienceIdentifier valueOf(String authorityId, String namespaceId, String objectId) {
        if (authorityId == null || namespaceId == null || objectId == null) {
            throw new NullPointerException("all of authorityId, namespaceId, objectId must not be null");
        }
        return new LifeScienceIdentifier(authorityId, namespaceId, objectId, null);
    }
}

