/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class GeoMean
extends AbstractFunction {
    public GeoMean() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOATS, "numbers", "Two or more positive numbers.")});
    }

    public String getName() {
        return "GEOMEAN";
    }

    public String getFunctionSummary() {
        return "Returns the geometric mean of a set of numbers.";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        ArrayList<Double> a = new ArrayList<Double>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof List) {
                List list = (List)args[i];
                for (Object listElement : list) {
                    try {
                        double d = FunctionUtil.getArgAsDouble(listElement);
                        if (d <= 0.0) {
                            throw new IllegalArgumentException(FunctionUtil.getOrdinal(i) + " argument in call to GEOMEAN() is not a list of positive numbers!");
                        }
                        a.add(d);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(FunctionUtil.getOrdinal(i) + " element in call to GEOMEAN() is not a list of numbers: " + e.getMessage());
                    }
                }
                continue;
            }
            try {
                double d = FunctionUtil.getArgAsDouble(args[i]);
                if (d <= 0.0) {
                    throw new IllegalArgumentException(FunctionUtil.getOrdinal(i) + " element in call to GEOMEAN() is not a positive number!");
                }
                a.add(d);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(FunctionUtil.getOrdinal(i) + " element in call to GEOMEAN() is not a number: " + e.getMessage());
            }
        }
        if (a.size() < 2) {
            throw new IllegalArgumentException("illegal arguments in call to GEOMEAN(): must have at least 2 numbers!");
        }
        double sumOfLogs = 0.0;
        Iterator i$ = a.iterator();
        while (i$.hasNext()) {
            double d = (Double)i$.next();
            sumOfLogs += Math.log(d);
        }
        return Math.exp(sumOfLogs / (double)a.size());
    }
}

