/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.componentselection;

import com.install4j.runtime.beans.screens.ComponentsScreen;
import com.install4j.runtime.beans.screens.componentselection.ComponentCheckBox;
import com.install4j.runtime.beans.screens.componentselection.ComponentFolderNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentToggleButton;
import com.install4j.runtime.beans.screens.componentselection.ComponentTree;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.DisplayTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ComponentCellHandler
extends JPanel
implements TreeCellRenderer,
TreeCellEditor,
ActionListener {
    private static final Icon ICON_HELP = GUIHelper.loadIcon("help_16.png");
    private static final Icon ICON_COMPONENT = GUIHelper.loadIcon("component_16.png");
    private static final Icon ICON_DOWNLOAD = GUIHelper.loadIcon("download_16.png");
    private static final int CHECKBOX_WIDTH = new JCheckBox().getPreferredSize().width;
    private ComponentTree tree;
    private List listeners = new ArrayList();
    private ComponentCheckBox chkSelected;
    private DefaultTreeCellRenderer defaultRenderer;
    private ComponentToggleButton btnHelp;
    private DisplayTextArea dtxaDescription;
    private ComponentNode editedComponentNode;
    private boolean pathBoundCheck = false;
    private int dtxaInset;
    private ComponentNodeConfig lastConfig;

    public ComponentCellHandler(ComponentTree componentTree) {
        this.tree = componentTree;
        this.setupControls();
        this.setupComponents();
        this.setupEventHandlers();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.chkSelected) {
            this.editedComponentNode.setSelected(this.chkSelected.isSelected());
            this.tree.stopEditing();
        } else if (object == this.btnHelp) {
            this.editedComponentNode.setDisplayDescription(this.btnHelp.isSelected());
            this.tree.stopEditing();
        }
    }

    private void setupControls() {
        this.chkSelected = new ComponentCheckBox();
        this.defaultRenderer = new DefaultTreeCellRenderer();
        this.btnHelp = new ComponentToggleButton(ICON_HELP);
        this.dtxaDescription = new DisplayTextArea();
        Font font = this.dtxaDescription.getFont();
        ComponentsScreen componentsScreen = this.tree.getComponentsScreen();
        int n = 0;
        float f = font.getSize2D();
        if (componentsScreen.isBoldDescription()) {
            ++n;
        }
        if (componentsScreen.isItalicDescription()) {
            n += 2;
        }
        if (componentsScreen.isSmallerDescription()) {
            f -= 1.0f;
        }
        font = font.deriveFont(n, f);
        this.dtxaDescription.setFont(font);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    private void setupComponents() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.chkSelected, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        this.add((Component)this.defaultRenderer, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.add((Component)this.btnHelp, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.dtxaInset = ICON_COMPONENT.getIconWidth() + this.defaultRenderer.getIconTextGap();
        gridBagConstraints.insets.left += this.dtxaInset;
        this.add((Component)this.dtxaDescription, gridBagConstraints);
        gridBagConstraints.insets.left -= this.dtxaInset;
        this.defaultRenderer.setOpenIcon(GUIHelper.ICON_FOLDER_OPEN);
        this.defaultRenderer.setClosedIcon(GUIHelper.ICON_FOLDER_CLOSED);
        this.defaultRenderer.setLeafIcon(ICON_COMPONENT);
    }

    private void setupEventHandlers() {
        this.chkSelected.addActionListener(this);
        this.btnHelp.addActionListener(this);
        ComponentTreeKeyHandler componentTreeKeyHandler = new ComponentTreeKeyHandler();
        this.chkSelected.addKeyListener(componentTreeKeyHandler);
        this.defaultRenderer.addKeyListener(componentTreeKeyHandler);
        this.addKeyListener(componentTreeKeyHandler);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        ComponentNode componentNode = (ComponentNode)object;
        this.lastConfig = componentNode.getComponentNodeConfig();
        if (this.lastConfig != null && !this.pathBoundCheck) {
            String string;
            if (this.lastConfig instanceof ComponentConfig && ((ComponentConfig)this.lastConfig).isDownloaded()) {
                this.defaultRenderer.setLeafIcon(ICON_DOWNLOAD);
            } else {
                this.defaultRenderer.setLeafIcon(ICON_COMPONENT);
            }
            this.defaultRenderer.getTreeCellRendererComponent(jTree, this.lastConfig.getName(), bl, bl2, bl3, n, bl4);
            this.defaultRenderer.setMinimumSize(this.defaultRenderer.getPreferredSize());
            this.chkSelected.setSelected(this.lastConfig.isSelected());
            this.chkSelected.setEnabled(componentNode.isChangeable());
            if (componentNode instanceof ComponentFolderNode && this.lastConfig.isSelected() && !((ComponentFolderNode)componentNode).isAllSelected()) {
                this.chkSelected.setIndeterminate(true);
            }
            boolean bl5 = (string = this.lastConfig.getDescription().trim()).length() > 0;
            this.btnHelp.setVisible(bl5);
            if (bl5) {
                this.prepareDescriptionDisplay(this.lastConfig, string, jTree, n);
            } else {
                this.dtxaDescription.setVisible(false);
            }
            this.invalidate();
            this.validate();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDescriptionDisplay(ComponentNodeConfig componentNodeConfig, String string, JTree jTree, int n) {
        boolean bl = componentNodeConfig.isDisplayDescription();
        this.btnHelp.setSelected(bl);
        this.dtxaDescription.setVisible(bl);
        if (bl) {
            this.dtxaDescription.setText(string);
            Container container = jTree.getParent();
            if (container != null) {
                int n2 = container.getParent().getWidth();
                TreePath treePath = jTree.getPathForRow(n);
                if (treePath != null) {
                    this.pathBoundCheck = true;
                    try {
                        int n3 = n2 - jTree.getPathBounds((TreePath)treePath).x - this.dtxaInset - CHECKBOX_WIDTH - 35;
                        Dimension dimension = new Dimension(n3, 20);
                        this.dtxaDescription.setPreferredSize(null);
                        this.dtxaDescription.setSize(dimension);
                        this.dtxaDescription.setPreferredSize(this.dtxaDescription.getPreferredSize());
                    }
                    finally {
                        this.pathBoundCheck = false;
                    }
                }
            }
        } else {
            this.dtxaDescription.setText("");
        }
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.editedComponentNode = (ComponentNode)object;
        TreePath treePath = jTree.getSelectionPath();
        this.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, treePath != null && treePath.getLastPathComponent() == object);
        this.chkSelected.requestFocus();
        return this;
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return false;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.add(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.remove(cellEditorListener);
    }

    public void cancelCellEditing() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CellEditorListener cellEditorListener = (CellEditorListener)iterator.next();
            cellEditorListener.editingCanceled(changeEvent);
        }
    }

    public boolean stopCellEditing() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CellEditorListener cellEditorListener = (CellEditorListener)iterator.next();
            cellEditorListener.editingStopped(changeEvent);
        }
        return true;
    }

    public boolean isPointInLabel(Point point) {
        return this.defaultRenderer.getBounds().contains(point);
    }

    private boolean isPointInHelpButton(Point point) {
        return this.btnHelp.getBounds().contains(point);
    }

    private boolean isPointInIcon(Point point) {
        return this.isPointInLabel(point) && point.x - this.defaultRenderer.getX() < 16;
    }

    public String getToolTipText(Point point) {
        String string = Locale.getDefault().getLanguage();
        if (!string.equals("en") && !string.equals("de")) {
            return null;
        }
        if (this.isPointInHelpButton(point)) {
            return this.btnHelp.isSelected() ? Messages.getMessages().getString("ComponentHideDescription") : Messages.getMessages().getString("ComponentShowDescription");
        }
        if (this.isPointInIcon(point) && this.lastConfig instanceof ComponentConfig && InstallerConfig.getCurrentInstance().getDownloadURL().length() > 0) {
            ComponentConfig componentConfig = (ComponentConfig)this.lastConfig;
            if (componentConfig.isDownloaded()) {
                return Messages.getMessages().getString("ComponentDownloadedFromInternet");
            }
            return Messages.getMessages().getString("ComponentIncludedInInstaller");
        }
        return null;
    }

    private class ComponentTreeKeyHandler
    extends KeyAdapter {
        private ComponentTreeKeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            ComponentCellHandler.this.tree.stopEditing();
            ComponentCellHandler.this.tree.dispatchEvent(keyEvent);
        }
    }
}

