/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.Util;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.content.ContentStats;
import com.install4j.runtime.installer.helper.content.CountingInputStream;
import com.install4j.runtime.installer.helper.content.PartialFileInputStream;
import com.install4j.runtime.installer.helper.content.ProxyConfig;
import com.install4j.runtime.installer.helper.content.SplittedFileInputStream;
import com.install4j.runtime.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ContentCollector {
    private static final String DATA_DIR_NAME = "data";
    private long totalProgress = 0L;
    private long totalSize;
    private String totalSizeVerbose;
    private NumberFormat numberFormat;
    private ProgressInterface progressInterface;
    private InstallerContext context;
    private ProxyConfig proxyConfig = new ProxyConfig();
    long startTime;
    long lastProgressUpdateTime = 0L;
    long currentFileProgress;

    public ContentCollector(ProgressInterface progressInterface, InstallerContext installerContext) {
        this.progressInterface = progressInterface;
        this.context = installerContext;
    }

    public Map collectContentStreams() throws UserCanceledException, IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ContentStats contentStats = ContentStats.getInstance();
        String string = System.getProperty("exe4j.moduleName");
        Map map = this.initUnextractedFiles();
        Set set = contentStats.getSelectedContentNumbers();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            String string2 = (String)iterator.next();
            String string3 = contentStats.getFileName(string2);
            UnextractedInfo unextractedInfo = (UnextractedInfo)map.get(string3);
            if (unextractedInfo != null) {
                object2 = new PartialFileInputStream(new File(string), unextractedInfo.position, unextractedInfo.length);
                hashMap.put(string2, object2);
                continue;
            }
            object2 = string == null ? new File(".") : new File(string).getAbsoluteFile().getParentFile();
            File file = new File(string3).getAbsoluteFile();
            if (!file.exists()) {
                file = new File(new File((File)object2, contentStats.getDirName()), string3).getAbsoluteFile();
            }
            if (!file.exists()) {
                file = new File((File)object2, string3).getAbsoluteFile();
            }
            if (!file.exists()) {
                file = new File(new File((File)object2, DATA_DIR_NAME), string3).getAbsoluteFile();
            }
            if (!file.exists()) {
                object = InstallerConfig.getCurrentInstance().getDownloadURL();
                if (((String)object).trim().length() == 0) {
                    String string4 = Messages.getMessages().getString("ErrorReadingSource") + "\n" + string3;
                    GUIHelper.showMessage(null, string4, 0);
                    throw new UserCanceledException();
                }
                arrayList.add(string2);
                continue;
            }
            object = new SplittedFileInputStream(file);
            hashMap.put(string2, object);
        }
        hashMap.putAll(this.downloadContentFiles(arrayList));
        return hashMap;
    }

    private Map initUnextractedFiles() throws IOException {
        HashMap<String, UnextractedInfo> hashMap = new HashMap<String, UnextractedInfo>();
        String string = System.getProperty("exe4j.moduleName");
        if (!Util.isMacosInstaller() && string != null) {
            Object object;
            long l;
            int n = Integer.getInteger("exe4j.unextractedPositionRestart", 0);
            if (n == 0) {
                n = Integer.getInteger("exe4j.unextractedPosition", 0);
            }
            if (n == 0) {
                l = Long.getLong("exe4j.totalDataLength", 0L);
                object = new File(string);
                if (l > 0L && ((File)object).exists()) {
                    n = (int)(((File)object).length() - l);
                }
            }
            if (n > 0) {
                l = 0L;
                object = new CountingInputStream(new BufferedInputStream(new FileInputStream(string)));
                DataInputStream dataInputStream = new DataInputStream((InputStream)object);
                dataInputStream.skipBytes(n);
                if (dataInputStream.readInt() == -387705899) {
                    UnextractedInfo unextractedInfo;
                    int n2 = dataInputStream.readInt();
                    for (int i = 0; i < n2; ++i) {
                        unextractedInfo = new UnextractedInfo();
                        String string2 = dataInputStream.readUTF();
                        unextractedInfo.length = dataInputStream.readLong();
                        unextractedInfo.position = l;
                        l += unextractedInfo.length;
                        hashMap.put(string2, unextractedInfo);
                    }
                    Iterator iterator = hashMap.values().iterator();
                    while (iterator.hasNext()) {
                        unextractedInfo = (UnextractedInfo)iterator.next();
                        unextractedInfo.position += ((CountingInputStream)object).getCount();
                    }
                } else {
                    throw new IOException("wrong magic number");
                }
                dataInputStream.close();
            }
        }
        return hashMap;
    }

    private Map downloadContentFiles(List list) throws IOException, UserCanceledException {
        Object object;
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMaximumFractionDigits(1);
        this.numberFormat.setMinimumFractionDigits(1);
        ContentStats contentStats = ContentStats.getInstance();
        this.totalSize = 0L;
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            this.totalSize += contentStats.getFileSize((String)object);
        }
        this.totalSizeVerbose = this.format(this.totalSize, 0x100000L);
        object2 = new HashMap();
        object = list.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            boolean bl = true;
            while (bl) {
                try {
                    File file = this.downloadSingleFile(string);
                    object2.put(string, new FileInputStream(file));
                    bl = false;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.totalProgress -= this.currentFileProgress;
                    if (this.progressInterface.askRetry(new File(contentStats.getFileName(string))) == 2) continue;
                    throw new UserCanceledException();
                }
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadSingleFile(String string) throws IOException, UserCanceledException {
        ContentStats contentStats = ContentStats.getInstance();
        this.progressInterface.setStatusMessage(Messages.getMessages().getString("ButtonDownload"));
        String string2 = InstallerConfig.getCurrentInstance().getDownloadURL().trim();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        string2 = string2 + contentStats.getFileName(string);
        URL uRL = new URL(string2);
        URLConnection uRLConnection = this.getURLConnection(uRL);
        this.updateProgress(true);
        File file = File.createTempFile("i4jc", ".dat");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.startTime = System.currentTimeMillis();
            this.currentFileProgress = 0L;
            long l = FileUtil.pumpStream(uRLConnection.getInputStream(), fileOutputStream, new FileUtil.CopyProgressListener(){

                public boolean progressPerformed(long l) {
                    ContentCollector.this.currentFileProgress += l;
                    ContentCollector.this.totalProgress += l;
                    if (ContentCollector.this.context.isCancelling()) {
                        return false;
                    }
                    ContentCollector.this.updateProgress(false);
                    return true;
                }
            });
            if (this.context.isCancelling()) {
                throw new UserCanceledException();
            }
            if (l != contentStats.getFileSize(string)) {
                throw new IOException("file size not correct: " + l + ", expected: " + contentStats.getFileSize(string));
            }
            this.updateProgress(true);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
            file.deleteOnExit();
        }
        return file;
    }

    private void updateProgress(boolean bl) {
        long l = System.currentTimeMillis();
        if (bl || l - this.lastProgressUpdateTime > 500L) {
            long l2 = (long)((double)this.currentFileProgress / (double)(l - this.startTime) * 1000.0);
            this.progressInterface.setDetailMessage(MessageFormat.format(Messages.getMessages().getString("DownloadProgress"), this.format(this.totalProgress, 0x100000L), this.totalSizeVerbose, this.format(100L * this.totalProgress, this.totalSize), this.format(l2, 1024L)));
            this.progressInterface.setPercentCompleted((int)(this.totalProgress * 100L / this.totalSize));
            this.lastProgressUpdateTime = l;
        }
    }

    private String format(long l, long l2) {
        double d = (double)l / (double)l2;
        return this.numberFormat.format(d);
    }

    public URLConnection getURLConnection(URL uRL) throws IOException, UserCanceledException {
        while (true) {
            if (this.context.isCancelling()) {
                throw new UserCanceledException();
            }
            try {
                URLConnection uRLConnection = uRL.openConnection();
                this.proxyConfig.updateConnection(uRLConnection);
                uRLConnection.connect();
                return uRLConnection;
            }
            catch (IOException iOException) {
                if (this.context.isUnattended()) {
                    throw iOException;
                }
                this.proxyConfig.show();
                if (!this.proxyConfig.isCanceled()) continue;
                throw new UserCanceledException();
            }
            break;
        }
    }

    private static class UnextractedInfo {
        private long position;
        private long length;

        private UnextractedInfo() {
        }
    }
}

