/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.util.converter.ConverterRegistry;
import com.l2fprod.common.util.converter.NumberConverters;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class NumberPropertyEditor
extends AbstractPropertyEditor {
    private final Class type;
    private Object lastGoodValue;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$String;

    public NumberPropertyEditor(Class type) {
        if (!(class$java$lang$Number == null ? (class$java$lang$Number = NumberPropertyEditor.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type)) {
            throw new IllegalArgumentException("type must be a subclass of Number");
        }
        this.editor = new JFormattedTextField();
        this.type = type;
        ((JFormattedTextField)this.editor).setValue(this.getDefaultValue());
        ((JFormattedTextField)this.editor).setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        NumberFormat format = NumberConverters.getDefaultFormat();
        ((JFormattedTextField)this.editor).setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(format)));
    }

    public Object getValue() {
        String text = ((JTextField)this.editor).getText();
        if (text == null || text.trim().length() == 0) {
            return this.getDefaultValue();
        }
        text = text.replace(',', '.');
        StringBuffer number = new StringBuffer();
        number.ensureCapacity(text.length());
        int c = text.length();
        for (int i = 0; i < c; ++i) {
            char character = text.charAt(i);
            if ('.' == character || '-' == character || (class$java$lang$Double == null ? NumberPropertyEditor.class$("java.lang.Double") : class$java$lang$Double).equals(this.type) && 'E' == character || (class$java$lang$Float == null ? NumberPropertyEditor.class$("java.lang.Float") : class$java$lang$Float).equals(this.type) && 'E' == character || Character.isDigit(character)) {
                number.append(character);
                continue;
            }
            if (' ' != character) break;
        }
        try {
            this.lastGoodValue = ConverterRegistry.instance().convert(this.type, number.toString());
        }
        catch (Exception e) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.editor);
        }
        return this.lastGoodValue;
    }

    public void setValue(Object value) {
        if (value instanceof Number) {
            ((JFormattedTextField)this.editor).setText(value.toString());
        } else {
            ((JFormattedTextField)this.editor).setValue(this.getDefaultValue());
        }
        this.lastGoodValue = value;
    }

    private Object getDefaultValue() {
        try {
            return this.type.getConstructor(class$java$lang$String == null ? (class$java$lang$String = NumberPropertyEditor.class$("java.lang.String")) : class$java$lang$String).newInstance("0");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

