/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.ImageLayer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.goodies.GaussianKernel;
import com.sun.glf.util.CompositionComponent;
import com.sun.glf.util.Toolbox;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.LookupOp;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class CompositeOp
implements BufferedImageOp {
    BufferedImageOp[] filters;
    static final String USAGE = "java com.sun.glf.goodies.CompositeOp <imageFile>";

    public CompositeOp(BufferedImageOp bufferedImageOp, BufferedImageOp bufferedImageOp2) {
        this(new BufferedImageOp[]{bufferedImageOp, bufferedImageOp2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeOp(BufferedImageOp[] bufferedImageOpArray) {
        if (bufferedImageOpArray == null || bufferedImageOpArray.length < 1) {
            throw new IllegalArgumentException();
        }
        BufferedImageOp[] bufferedImageOpArray2 = bufferedImageOpArray;
        synchronized (bufferedImageOpArray) {
            this.filters = new BufferedImageOp[bufferedImageOpArray.length];
            System.arraycopy(bufferedImageOpArray, 0, this.filters, 0, bufferedImageOpArray.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i] != null) continue;
                throw new IllegalArgumentException();
            }
            return;
        }
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        for (int i = 0; i < this.filters.length - 1; ++i) {
            bufferedImage = this.filters[i].filter(bufferedImage, null);
        }
        return this.filters[this.filters.length - 1].filter(bufferedImage, bufferedImage2);
    }

    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        Rectangle2D rectangle2D = this.filters[0].getBounds2D(bufferedImage);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 1; i < this.filters.length; ++i) {
            Point2D point2D = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
            Point2D point2D2 = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY());
            Point2D point2D3 = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
            Point2D point2D4 = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight());
            point2D = this.filters[i].getPoint2D(point2D, null);
            point2D2 = this.filters[i].getPoint2D(point2D2, null);
            point2D3 = this.filters[i].getPoint2D(point2D3, null);
            point2D4 = this.filters[i].getPoint2D(point2D4, null);
            Point2D point2D5 = point2D;
            Point2D[] point2DArray = new Point2D[]{point2D2, point2D3, point2D4};
            d = point2D5.getX();
            d2 = point2D5.getY();
            d3 = d;
            d4 = d2;
            for (int j = 0; j < 3; ++j) {
                d = Math.min(d, point2DArray[j].getX());
                d2 = Math.min(d2, point2DArray[j].getY());
                d3 = Math.max(d3, point2DArray[j].getX());
                d4 = Math.max(d4, point2DArray[j].getY());
            }
            rectangle2D = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        }
        return rectangle2D;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        return this.filters[this.filters.length - 1].createCompatibleDestImage(bufferedImage, colorModel);
    }

    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        for (int i = 0; i < this.filters.length; ++i) {
            point2D2 = this.filters[i].getPoint2D(point2D, point2D2);
        }
        return point2D2;
    }

    public RenderingHints getRenderingHints() {
        return this.filters[this.filters.length - 1].getRenderingHints();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println(USAGE);
            System.exit(0);
        }
        String string = stringArray[0];
        JFrame jFrame = new JFrame("CompositeOp unit testing");
        jFrame.getContentPane().setLayout(new GridLayout(0, 1));
        BufferedImage bufferedImage = Toolbox.loadImage(string, 1);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(null), bufferedImage.getHeight(null), 1);
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        Dimension dimension = new Dimension(n, n2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getShearInstance(0.5, 0.0), null);
        ConvolveOp convolveOp = new ConvolveOp(new GaussianKernel(5));
        byte[] byArray = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray[i] = (byte)(255 - i);
        }
        ByteLookupTable byteLookupTable = new ByteLookupTable(0, byArray);
        LookupOp lookupOp = new LookupOp(byteLookupTable, null);
        CompositeOp compositeOp = new CompositeOp(new BufferedImageOp[]{lookupOp, convolveOp, affineTransformOp});
        BufferedImage bufferedImage3 = lookupOp.filter(bufferedImage2, null);
        BufferedImage bufferedImage4 = affineTransformOp.filter(bufferedImage2, null);
        BufferedImage bufferedImage5 = convolveOp.filter(bufferedImage2, null);
        BufferedImage bufferedImage6 = compositeOp.filter(bufferedImage2, null);
        jFrame.getContentPane().add(CompositeOp.makeNewComponent(bufferedImage2, "Original Image"));
        jFrame.getContentPane().add(CompositeOp.makeNewComponent(bufferedImage3, "LookupOp"));
        jFrame.getContentPane().add(CompositeOp.makeNewComponent(bufferedImage4, "AffineTransformOp"));
        jFrame.getContentPane().add(CompositeOp.makeNewComponent(bufferedImage5, "ConvolveOp"));
        jFrame.getContentPane().add(CompositeOp.makeNewComponent(bufferedImage6, "CompositeOp"));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static JComponent makeNewComponent(Image image, String string) {
        Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
        LayerComposition layerComposition = new LayerComposition(dimension);
        ImageLayer imageLayer = new ImageLayer(layerComposition, image, null);
        layerComposition.setLayers(new Layer[]{imageLayer});
        CompositionComponent compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText(string);
        return compositionComponent;
    }
}

