/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.FillRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Renderer;
import com.sun.glf.ShapeLayer;
import com.sun.glf.StrokeRenderer;
import com.sun.glf.goodies.RadialGradientPaintContext;
import com.sun.glf.util.CompositionComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class RadialGradientPaint
implements Paint {
    Color color1;
    Color color2;
    Rectangle2D.Float gradientBounds;
    int transparency;

    public Color getCenterColor() {
        return this.color1;
    }

    public Color getBoundaryColor() {
        return this.color2;
    }

    public Rectangle2D getBounds() {
        return (Rectangle2D)this.gradientBounds.clone();
    }

    public RadialGradientPaint(Rectangle2D rectangle2D, Color color, Color color2) {
        this.color1 = color;
        this.color2 = color2;
        this.gradientBounds = new Rectangle2D.Float();
        this.gradientBounds.setRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        int n = color.getAlpha();
        int n2 = color2.getAlpha();
        this.transparency = (n & n2) == 255 ? 1 : 3;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        try {
            return new RadialGradientPaintContext(this.gradientBounds, this.color1, this.color2, affineTransform);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalArgumentException("transform should be invertible");
        }
    }

    public int getTransparency() {
        return this.transparency;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("RadialGradientPaint unit testing");
        jFrame.getContentPane().setLayout(new GridLayout(0, 2));
        jFrame.getContentPane().setBackground(Color.white);
        Rectangle rectangle = new Rectangle(20, 20, 160, 60);
        Dimension dimension = new Dimension(200, 100);
        Color color = new Color(20, 40, 20);
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(new Rectangle(40, 20, 70, 60), Color.white, color);
        RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(new Rectangle(40, 20, 60, 60), Color.white, color);
        FillRenderer fillRenderer = new FillRenderer(radialGradientPaint);
        FillRenderer fillRenderer2 = new FillRenderer(radialGradientPaint2);
        AffineTransform affineTransform = null;
        jFrame.getContentPane().add(RadialGradientPaint.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "No transform"));
        jFrame.getContentPane().add(RadialGradientPaint.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "No transform"));
        affineTransform = AffineTransform.getTranslateInstance(40.0, 40.0);
        jFrame.getContentPane().add(RadialGradientPaint.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Translation"));
        jFrame.getContentPane().add(RadialGradientPaint.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Translation"));
        affineTransform = AffineTransform.getScaleInstance(2.0, 2.0);
        jFrame.getContentPane().add(RadialGradientPaint.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Scale"));
        jFrame.getContentPane().add(RadialGradientPaint.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Scale"));
        affineTransform = AffineTransform.getRotateInstance(0.7853981633974483, 100.0, 50.0);
        jFrame.getContentPane().add(RadialGradientPaint.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Rotation"));
        jFrame.getContentPane().add(RadialGradientPaint.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Rotation"));
        affineTransform = AffineTransform.getShearInstance(0.5, 0.0);
        jFrame.getContentPane().add(RadialGradientPaint.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Shear"));
        jFrame.getContentPane().add(RadialGradientPaint.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Shear"));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static JComponent makeNewComponent(Dimension dimension, Shape shape, Renderer renderer, AffineTransform affineTransform, String string) {
        LayerComposition layerComposition = new LayerComposition(dimension);
        Rectangle rectangle = new Rectangle(-1, -1, dimension.width, dimension.height);
        ShapeLayer shapeLayer = new ShapeLayer(layerComposition, shape, renderer);
        shapeLayer.setTransform(affineTransform);
        ShapeLayer shapeLayer2 = new ShapeLayer(layerComposition, rectangle, new StrokeRenderer((Paint)Color.black, 1.0f));
        layerComposition.setLayers(new Layer[]{shapeLayer, shapeLayer2});
        CompositionComponent compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText(string);
        return compositionComponent;
    }
}

