/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.FillRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.ShapeLayer;
import com.sun.glf.goodies.RadialGradientPaintContext;
import com.sun.glf.goodies.RadialGradientPaintExt;
import com.sun.glf.util.CompositionFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

class RadialGradientPaintExtContext
implements PaintContext {
    static final float sqStep = 0.003937008f;
    static final float[] sqrtLut = RadialGradientPaintContext.sqrtLut;
    static ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    Point2D.Float f1;
    Point2D.Float f2;
    float maInv;
    float e;
    double[] m;
    int[] gradient;
    WritableRaster working;
    ColorModel model;
    Rectangle bounds;
    boolean isCircle = false;
    float maxDistanceSq;
    static final String USAGE = "java com.sun.glf.goodies.RadialGradientPaintExtContext <width> <height>";

    public RadialGradientPaintExtContext(Rectangle2D.Float float_, Color[] colorArray, float[] fArray, AffineTransform affineTransform) throws NoninvertibleTransformException {
        int n;
        int n2;
        int n3;
        float f = float_.width;
        float f2 = float_.height;
        float f3 = float_.x;
        float f4 = float_.y;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f > f2) {
            f5 = f / 2.0f;
            f6 = f2 / 2.0f;
        } else {
            f5 = f2 / 2.0f;
            f6 = f / 2.0f;
        }
        this.e = (float)Math.sqrt(1.0f - f6 * f6 / (f5 * f5));
        this.f1 = new Point2D.Float();
        this.f2 = new Point2D.Float();
        if (f > f2) {
            this.f1.x = f3 + f5 * (1.0f + this.e);
            this.f1.y = f4 + f6;
            this.f2.x = f3 + f5 * (1.0f - this.e);
            this.f2.y = f4 + f6;
        } else {
            this.f1.x = f3 + f6;
            this.f1.y = f4 + f5 * (1.0f + this.e);
            this.f2.x = f3 + f6;
            this.f2.y = f4 + f5 * (1.0f - this.e);
        }
        this.f1 = this.f1;
        this.f2 = this.f2;
        this.maInv = 1.0f / (2.0f * f5);
        boolean bl = this.isCircle = float_.width == float_.height;
        if (this.isCircle) {
            this.maInv = 1.0f / f5;
        }
        this.bounds = affineTransform.createTransformedShape(float_).getBounds();
        this.m = new double[6];
        AffineTransform affineTransform2 = affineTransform.createInverse();
        affineTransform2.getMatrix(this.m);
        int n4 = fArray.length;
        float f7 = 1.0f;
        for (n3 = 0; n3 < n4; ++n3) {
            f7 = f7 > fArray[n3] ? fArray[n3] : f7;
        }
        n3 = -16777216;
        int[][] nArrayArray = new int[n4][];
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n = (int)(fArray[n2] / f7 * 255.0f);
            n5 += n;
            nArrayArray[n2] = new int[n];
            float f8 = 1.0f / (float)n;
            n6 = colorArray[n2].getRGB();
            n7 = colorArray[n2 + 1].getRGB();
            int n8 = n6 >> 24 & 0xFF;
            int n9 = n6 >> 16 & 0xFF;
            int n10 = n6 >> 8 & 0xFF;
            int n11 = n6 & 0xFF;
            int n12 = (n7 >> 24 & 0xFF) - n8;
            int n13 = (n7 >> 16 & 0xFF) - n9;
            int n14 = (n7 >> 8 & 0xFF) - n10;
            int n15 = (n7 & 0xFF) - n11;
            n3 &= n6;
            n3 &= n7;
            for (int i = 0; i < n; ++i) {
                int n16;
                nArrayArray[n2][i] = n16 = (int)((float)n8 + (float)(i * n12) * f8) << 24 | (int)((float)n9 + (float)(i * n13) * f8) << 16 | (int)((float)n10 + (float)(i * n14) * f8) << 8 | (int)((float)n11 + (float)(i * n15) * f8);
            }
        }
        this.gradient = new int[n5];
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            System.arraycopy(nArrayArray[n], 0, this.gradient, n2, nArrayArray[n].length);
            n2 += nArrayArray[n].length;
        }
        this.gradient[this.gradient.length - 1] = colorArray[colorArray.length - 1].getRGB();
        this.model = n3 >>> 24 == 255 ? xrgbmodel : ColorModel.getRGBdefault();
        n = this.gradient.length - 1;
        this.maInv *= (float)n;
        Rectangle2D rectangle2D = affineTransform2.createTransformedShape(affineTransform.createTransformedShape(float_).getBounds()).getBounds2D();
        this.maxDistanceSq = (float)this.f1.distanceSq(rectangle2D.getX(), rectangle2D.getY());
        float f9 = (float)Math.sqrt(this.maxDistanceSq);
        this.maInv *= f9;
    }

    public void dispose() {
        this.working = null;
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.working == null || this.working.getWidth() < n3 || this.working.getHeight() < n4) {
            this.working = this.getColorModel().createCompatibleWritableRaster(n3, n4);
        }
        WritableRaster writableRaster = this.working;
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n5 = dataBufferInt.getOffset();
        int n6 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int n7 = n6 - n3;
        if (!this.isCircle) {
            this.fillRasterEllipse(nArray, n5, n7, n, n2, n3, n4);
        } else {
            this.fillRasterDisc(nArray, n5, n7, n, n2, n3, n4);
        }
        return writableRaster;
    }

    void fillRasterEllipse(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = false;
        int n7 = this.bounds.x + this.bounds.width;
        int n8 = this.bounds.y + this.bounds.height;
        int n9 = n3 + n5;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        float f = 0.0f;
        int n13 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = (float)this.m[0];
        float f5 = (float)this.m[1];
        float f6 = (float)this.m[2];
        float f7 = (float)this.m[3];
        float f8 = (float)this.m[4];
        float f9 = (float)this.m[5];
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = this.gradient.length - 1;
        float f15 = this.e * f14;
        int n14 = this.gradient[(int)f14];
        float f16 = 1.0f - this.e;
        float f17 = 0.0f;
        float f18 = 0.0f;
        float f19 = 0.0f;
        float f20 = 0.0f;
        float f21 = 0.0f;
        float f22 = 0.0f;
        int n15 = 0;
        int n16 = 0;
        float f23 = 0.0f;
        for (int i = 0; i < n6; ++i) {
            n9 = n + n5;
            if (i + n4 < this.bounds.y || i + n4 > n8 || n3 + n5 < this.bounds.x || n3 > n7) {
                while (n < n9) {
                    nArray[n++] = n14;
                }
            } else {
                n12 = n;
                n10 = n + this.bounds.x - n3;
                n11 = n10 + this.bounds.width;
                int n17 = n11 = n11 > n9 ? n9 : n11;
                while (n < n10) {
                    nArray[n++] = n14;
                }
                n13 = n3 + n - n12;
                f2 = f4 * (float)n13 + f6 * (float)(n4 + i) + f8;
                f3 = f5 * (float)n13 + f7 * (float)(n4 + i) + f9;
                f10 = this.f1.x - f2;
                f11 = this.f1.y - f3;
                f12 = this.f2.x - f2;
                f13 = this.f2.y - f3;
                while (n < n11) {
                    f19 = (f10 * f10 + f11 * f11) / this.maxDistanceSq;
                    f20 = (f12 * f12 + f13 * f13) / this.maxDistanceSq;
                    if (f19 < 0.003937008f) {
                        f17 = (float)Math.sqrt(f19);
                    } else {
                        f21 = f19 / 0.003937008f;
                        n15 = (int)f21;
                        f23 = f21 - (float)n15;
                        f17 = f23 * sqrtLut[n15 + 1] + (1.0f - f23) * sqrtLut[n15];
                    }
                    if (f20 < 0.003937008f) {
                        f18 = (float)Math.sqrt(f20);
                    } else {
                        f22 = f20 / 0.003937008f;
                        n16 = (int)f22;
                        f23 = f22 - (float)n16;
                        f18 = f23 * sqrtLut[n16 + 1] + (1.0f - f23) * sqrtLut[n16];
                    }
                    f = (this.maInv * (f17 + f18) - f15) / f16;
                    f = f > f14 ? f14 : f;
                    f = f < 0.0f ? 0.0f : f;
                    nArray[n++] = this.gradient[(int)f];
                    f10 -= f4;
                    f12 -= f4;
                    f11 -= f5;
                    f13 -= f5;
                }
                while (n < n9) {
                    nArray[n++] = n14;
                }
            }
            n += n2;
        }
    }

    void fillRasterDisc(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = false;
        int n7 = this.bounds.x + this.bounds.width;
        int n8 = this.bounds.y + this.bounds.height;
        int n9 = n3 + n5;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        float f = 0.0f;
        int n13 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = (float)this.m[0];
        float f5 = (float)this.m[1];
        float f6 = (float)this.m[2];
        float f7 = (float)this.m[3];
        float f8 = (float)this.m[4];
        float f9 = (float)this.m[5];
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = this.gradient.length - 1;
        int n14 = this.gradient[(int)f12];
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        int n15 = 0;
        float f16 = 0.0f;
        for (int i = 0; i < n6; ++i) {
            n9 = n + n5;
            if (i + n4 < this.bounds.y || i + n4 > n8 || n3 + n5 < this.bounds.x || n3 > n7) {
                while (n < n9) {
                    nArray[n++] = n14;
                }
            } else {
                n12 = n;
                n10 = n + this.bounds.x - n3;
                n11 = n10 + this.bounds.width;
                int n16 = n11 = n11 > n9 ? n9 : n11;
                while (n < n10) {
                    nArray[n++] = n14;
                }
                n13 = n3 + n - n12;
                f2 = f4 * (float)n13 + f6 * (float)(n4 + i) + f8;
                f3 = f5 * (float)n13 + f7 * (float)(n4 + i) + f9;
                f10 = this.f1.x - f2;
                f11 = this.f1.y - f3;
                while (n < n11) {
                    f14 = (f10 * f10 + f11 * f11) / this.maxDistanceSq;
                    if (f14 < 0.003937008f) {
                        f13 = (float)Math.sqrt(f14);
                    } else {
                        f15 = f14 / 0.003937008f;
                        n15 = (int)f15;
                        f16 = f15 - (float)n15;
                        f13 = f16 * sqrtLut[n15 + 1] + (1.0f - f16) * sqrtLut[n15];
                    }
                    f = this.maInv * f13;
                    f = f > f12 ? f12 : f;
                    f = f < 0.0f ? 0.0f : f;
                    nArray[n++] = this.gradient[(int)f];
                    f10 -= f4;
                    f11 -= f5;
                }
                while (n < n9) {
                    nArray[n++] = n14;
                }
            }
            n += n2;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println(USAGE);
            System.exit(0);
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        Rectangle rectangle2 = new Rectangle(0, 0, n, n2);
        float[] fArray = new float[]{3.0f, 2.0f, 1.0f};
        Color[] colorArray = new Color[]{Color.white, Color.yellow, Color.green, Color.black};
        RadialGradientPaintExt radialGradientPaintExt = new RadialGradientPaintExt(rectangle, colorArray, fArray);
        LayerComposition layerComposition = new LayerComposition(new Dimension(n, n2));
        Layer[] layerArray = new Layer[]{new ShapeLayer(layerComposition, rectangle2, new FillRenderer(radialGradientPaintExt))};
        layerComposition.setLayers(layerArray);
        CompositionFrame compositionFrame = new CompositionFrame("GradientPaintExtContext unit testing");
        compositionFrame.setComposition(layerComposition);
        compositionFrame.pack();
        compositionFrame.setVisible(true);
    }
}

