/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.Composition;
import com.sun.glf.FillRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.ShapeLayer;
import com.sun.glf.TextLayer;
import com.sun.glf.util.CompositionFactory;
import com.sun.glf.util.CompositionFactoryLoader;
import com.sun.glf.util.CompositionFrame;
import com.sun.glf.util.GridBagPanel;
import com.sun.glf.util.PropertyEditorUI;
import com.sun.glf.util.SerializedBeanFileFilter;
import com.sun.glf.util.TextBeanFileFilter;
import com.sun.glf.util.TextBeans;
import com.sun.glf.util.Toolbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class CompositionStudio
extends GridBagPanel {
    static final String BEAN_NAME = "Bean Name";
    static final String BEANS_SAVED = "Beans saved";
    static final String COMPOSITION_PREVIEW = "Composition Preview";
    static final String ENTER_BEAN_NAME = "Enter Bean name";
    static final String INSPECTING_BEANS = "Inspecting bean ... ";
    static final String CONFIRM = "Confirm";
    static final String ERROR_CANNOT_LOAD_BEAN = "Error. Cannot load bean : ";
    static final String ERROR_CANNOT_SERIALIZE_BEANS = "Could not serialize beans: ";
    static final String ERROR_DIRECTORY_SELECTED = "Error: you selected a directory";
    static final String ERROR_TARGET_EXCEPTION = "Error : ";
    static final String FILE_EXIST_OVERRIDE = "File already exists. Overwrite?";
    static final String FRAME_TITLE = "Composition Studio";
    static final String LOAD = "Load";
    static final String LOAD_A_BEAN = "Load a Bean with the Load Button";
    static final String LOAD_BEAN = "Load Beans";
    static final String LOADING_CLASS = "Loading Class : ";
    static final String SAVE = "Save";
    static final String PREVIEW = "Preview";
    static final String PREVIEW_SEPARATE = "Preview in separate windows";
    private static JFileChooser fileChooser;
    private static boolean isLoadEnabled;
    private static boolean isSaveEnabled;
    private static FileFilter serTxtFilter;
    private static FileFilter serFilter;
    private PropertyEditorUI[] editorUIs;
    private CompositionFactory beans;
    private String beanName = "";
    private PropertyChangeSupport beanNameChangeSupport;
    private JCheckBox previewSeparate;
    private JCheckBox loadQualifiedBean;
    private CompositionFrame previewFrame = new CompositionFrame("");
    static final String USAGE = "Usage : java com.sun.glf.util.CompositionStudio <beanFile>\ne.g. java com.sun.glf.util.CompositionStudio myBean.ser\ne.g. java com.sun.glf.util.CompositionStudio myCompositionFactoryClass.class";
    static /* synthetic */ Class class$com$sun$glf$util$Glyph;
    static /* synthetic */ Class class$com$sun$glf$util$GlyphPropertyEditor;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$com$sun$glf$util$ColorPropertyEditor;
    static /* synthetic */ Class class$com$sun$glf$util$BooleanPropertyEditor;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$awt$Font;
    static /* synthetic */ Class class$com$sun$glf$util$FontPropertyEditor;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$com$sun$glf$util$DimensionPropertyEditor;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$com$sun$glf$util$FilePropertyEditor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$sun$glf$util$IntegerPropertyEditor;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$com$sun$glf$util$FloatPropertyEditor;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$com$sun$glf$util$DoublePropertyEditor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$glf$util$StringPropertyEditor;
    static /* synthetic */ Class class$com$sun$glf$util$CompositionFrame;
    static /* synthetic */ Class class$com$sun$glf$util$CompositionStudio$SimpleFactory;

    public CompositionStudio() {
        this.beanNameChangeSupport = new PropertyChangeSupport(this);
        this.loadBeans(null);
        Dimension dimension = this.getToolkit().getScreenSize();
        dimension.height /= 2;
        this.setMaximumSize(dimension);
    }

    public void loadBeans(CompositionFactory compositionFactory) {
        if (this.beans != null && this.beans.getClass() == compositionFactory.getClass()) {
            this.beans = compositionFactory;
            this.loadUIValues();
        } else {
            this.beans = compositionFactory;
            JComponent jComponent = this.buildConfigurationPanel(compositionFactory);
            JPanel jPanel = new JPanel(new GridLayout(1, 0));
            JButton jButton = new JButton(SAVE);
            JButton jButton2 = new JButton(PREVIEW);
            JButton jButton3 = new JButton(LOAD);
            jPanel.add(jButton3);
            if (compositionFactory != null) {
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
            GridBagPanel gridBagPanel = new GridBagPanel();
            gridBagPanel.add(Box.createHorizontalGlue(), 0, 0, 1, 1, 13, 2, 1.0, 0.0);
            gridBagPanel.add(jPanel, 1, 0, 1, 1, 10, 0, 0.0, 0.0);
            this.removeAll();
            this.add(new JScrollPane(jComponent, 20, 30), 0, 0, 1, 1, 10, 1, 1.0, 1.0);
            this.add(gridBagPanel, 0, 2, 1, 1, 10, 2, 0.0, 0.0);
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (CompositionStudio.this.loadQualifiedBean != null && CompositionStudio.this.loadQualifiedBean.isSelected()) {
                        CompositionStudio.this.onLoadBean();
                    } else {
                        CompositionStudio.this.onLoadFile();
                    }
                }
            });
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CompositionStudio.this.onSave();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CompositionStudio.this.onPreview();
                }
            });
            jButton.setVisible(isSaveEnabled);
            jButton3.setVisible(isLoadEnabled);
            jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
            this.loadUIValues();
            if (this.getParent() != null) {
                if (this.getParent() instanceof Window) {
                    ((Window)this.getParent()).pack();
                } else {
                    this.invalidate();
                    this.getParent().validate();
                }
            }
        }
    }

    private void loadUIValues() {
        int n = this.editorUIs != null ? this.editorUIs.length : 0;
        for (int i = 0; i < n; ++i) {
            this.editorUIs[i].load(this.beans);
        }
    }

    private void saveUIValues() throws InvocationTargetException {
        int n = this.editorUIs != null ? this.editorUIs.length : 0;
        for (int i = 0; i < n; ++i) {
            this.editorUIs[i].save(this.beans);
        }
    }

    private void onLoadFile() {
        fileChooser.setDialogType(0);
        fileChooser.addChoosableFileFilter(serTxtFilter);
        int n = fileChooser.showDialog(null, null);
        fileChooser.removeChoosableFileFilter(serTxtFilter);
        if (n == 0) {
            File file = fileChooser.getSelectedFile();
            this.loadBeanFile(file);
        }
    }

    private void loadBeanFile(File file) {
        CompositionFactory compositionFactory = CompositionFactoryLoader.loadBeanFile(file);
        if (compositionFactory != null) {
            this.loadBeans(compositionFactory);
            this.setBeanName(file.getName());
        }
    }

    private void onLoadBean() {
        String string = JOptionPane.showInputDialog(null, ENTER_BEAN_NAME, BEAN_NAME, -1);
        if (string != null) {
            this.loadBeanObject(string);
        }
    }

    private void loadBeanObject(String string) {
        try {
            System.out.println(LOADING_CLASS + string);
            if (string.endsWith(".class")) {
                string = string.substring(0, string.length() - 6);
            }
            Object object = Beans.instantiate(null, string);
            this.loadBeans((CompositionFactory)object);
            this.setBeanName(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, ERROR_CANNOT_LOAD_BEAN + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void setBeanName(String string) {
        String string2 = this.beanName;
        this.beanName = string;
        this.beanNameChangeSupport.firePropertyChange("beanName", string2, string);
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void addBeanNameChangeListener(PropertyChangeListener propertyChangeListener) {
        this.beanNameChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeBeanNameListener(PropertyChangeListener propertyChangeListener) {
        this.beanNameChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void onSave() {
        fileChooser.setDialogType(1);
        fileChooser.setFileFilter(serFilter);
        int n = fileChooser.showDialog(null, null);
        if (n == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                this.saveUIValues();
                try {
                    int n2;
                    File file2 = new File(file.getAbsolutePath() + ".txt");
                    boolean bl = false;
                    bl = file.exists() || file2.exists() ? (n2 = JOptionPane.showConfirmDialog(null, FILE_EXIST_OVERRIDE, CONFIRM, 0)) == 0 : true;
                    if (bl) {
                        FileOutputStream fileOutputStream = new FileOutputStream(file.getPath());
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                        objectOutputStream.writeObject(this.beans);
                        objectOutputStream.flush();
                        objectOutputStream.close();
                        fileOutputStream.close();
                        fileOutputStream = new FileOutputStream(file.getPath() + ".txt");
                        TextBeans.save(this.beans, fileOutputStream);
                        fileOutputStream.close();
                        JOptionPane.showMessageDialog(null, BEANS_SAVED);
                    }
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, ERROR_CANNOT_SERIALIZE_BEANS + iOException.getMessage());
                    iOException.printStackTrace();
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                JOptionPane.showMessageDialog(null, ERROR_TARGET_EXCEPTION + invocationTargetException.getMessage());
            }
        }
    }

    private synchronized void onPreview() {
        try {
            this.saveUIValues();
            if (this.previewSeparate.isSelected() || this.previewFrame == null) {
                this.previewFrame = new CompositionFrame("");
            }
            this.previewFrame.load(this.beans);
            this.previewFrame.show();
        }
        catch (InvocationTargetException invocationTargetException) {
            JOptionPane.showMessageDialog(null, ERROR_TARGET_EXCEPTION + invocationTargetException.getMessage());
            return;
        }
    }

    private void setEditorUIs(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException();
        }
        this.editorUIs = new PropertyEditorUI[vector.size()];
        vector.copyInto(this.editorUIs);
    }

    public String getPropertyName(String string) {
        String string2 = string.substring(3);
        char[] cArray = string2.toCharArray();
        int n = cArray != null ? cArray.length : 0;
        char[] cArray2 = new char[n * 2];
        int n2 = 1;
        cArray2[0] = cArray[0];
        for (int i = 1; i < n; ++i) {
            char c = cArray[i];
            if (Character.isUpperCase(c)) {
                cArray2[n2++] = 32;
            }
            cArray2[n2++] = c;
        }
        return new String(cArray2, 0, n2);
    }

    public Method[][] getPropertyMethods(Class clazz) {
        Vector<Method[]> vector = new Vector<Method[]>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray != null ? methodArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!methodArray[i].getName().startsWith("get")) continue;
            Method[] methodArray2 = new Method[2];
            methodArray2[0] = methodArray[i];
            Class<?>[] classArray = methodArray[i].getParameterTypes();
            if (classArray != null && classArray.length != 0) continue;
            try {
                Method method;
                methodArray2[1] = method = clazz.getMethod("set" + methodArray[i].getName().substring(3), methodArray[i].getReturnType());
                vector.addElement(methodArray2);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        Method[][] methodArray3 = new Method[vector.size()][2];
        vector.copyInto((Object[])methodArray3);
        return methodArray3;
    }

    private JComponent buildConfigurationPanel(Object object) {
        if (object == null) {
            return new JLabel(LOAD_A_BEAN);
        }
        Method[][] methodArray = this.getPropertyMethods(object.getClass());
        GridBagPanel gridBagPanel = new GridBagPanel();
        int n = methodArray != null ? methodArray.length : 0;
        Vector<PropertyEditorUI> vector = new Vector<PropertyEditorUI>();
        for (int i = 0; i < n; ++i) {
            Method[] methodArray2 = methodArray[i];
            String string = this.getPropertyName(methodArray2[0].getName());
            Class<?> clazz = methodArray2[0].getReturnType();
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
            if (propertyEditor == null) continue;
            JLabel jLabel = new JLabel(string);
            gridBagPanel.add(jLabel, 0, i, 1, 1, 17, 0, 0.0, 0.0);
            gridBagPanel.add(Box.createHorizontalStrut(10), 1, i, 1, 1, 10, 0, 0.0, 0.0);
            PropertyEditorUI propertyEditorUI = new PropertyEditorUI(propertyEditor, methodArray2[0], methodArray2[1]);
            gridBagPanel.add(propertyEditorUI, 2, i, 1, 1, 17, 2, 1.0, 0.0);
            vector.addElement(propertyEditorUI);
        }
        this.setEditorUIs(vector);
        this.previewSeparate = new JCheckBox(PREVIEW_SEPARATE);
        this.previewSeparate.setHorizontalTextPosition(2);
        this.loadQualifiedBean = new JCheckBox(LOAD_BEAN);
        this.loadQualifiedBean.setHorizontalTextPosition(4);
        this.loadQualifiedBean.setVisible(isLoadEnabled);
        gridBagPanel.add(this.loadQualifiedBean, 0, n, 1, 1, 17, 0, 0.0, 0.0);
        gridBagPanel.add(this.previewSeparate, 1, n, 0, 1, 13, 0, 0.0, 0.0);
        return gridBagPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        Serializable serializable;
        String string;
        if (stringArray.length < 1) {
            System.out.println(USAGE);
            System.exit(0);
        }
        if ((string = System.getProperty("com.sun.glf.getAllFonts", "false")).equalsIgnoreCase("true")) {
            Toolbox.initFonts();
        }
        String string2 = stringArray[0];
        final CompositionStudio compositionStudio = new CompositionStudio();
        final JFrame jFrame = new JFrame(FRAME_TITLE);
        jFrame.getContentPane().add(compositionStudio);
        jFrame.pack();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }
        });
        compositionStudio.addBeanNameChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jFrame.setTitle("Composition Studio " + compositionStudio.getBeanName());
            }
        });
        if (string2.equalsIgnoreCase("-test-")) {
            compositionStudio.loadBeanObject((class$com$sun$glf$util$CompositionStudio$SimpleFactory == null ? (class$com$sun$glf$util$CompositionStudio$SimpleFactory = CompositionStudio.class$("com.sun.glf.util.CompositionStudio$SimpleFactory")) : class$com$sun$glf$util$CompositionStudio$SimpleFactory).getName());
        } else {
            try {
                System.out.println(INSPECTING_BEANS + string2);
                serializable = new File(string2);
                if (string2.endsWith(".class")) {
                    compositionStudio.loadBeanObject(string2);
                } else if (((File)serializable).exists()) {
                    compositionStudio.loadBeanFile(new File(string2));
                } else {
                    compositionStudio.loadBeanObject(string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        jFrame.pack();
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension = jFrame.getSize();
        if (dimension.height > 80 * ((Dimension)serializable).height / 100) {
            dimension.height = 80 * ((Dimension)serializable).height / 100;
            jFrame.setSize(dimension);
        }
        jFrame.show();
        Object object2 = object = new Object(){};
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        isLoadEnabled = true;
        isSaveEnabled = true;
        Toolbox.swingDefaultsInit();
        fileChooser = new JFileChooser();
        fileChooser.setDialogType(1);
        serFilter = new SerializedBeanFileFilter();
        serTxtFilter = new TextBeanFileFilter();
        fileChooser.addChoosableFileFilter(serFilter);
        fileChooser.setFileSelectionMode(0);
        PropertyEditorManager.registerEditor(class$com$sun$glf$util$Glyph == null ? (class$com$sun$glf$util$Glyph = CompositionStudio.class$("com.sun.glf.util.Glyph")) : class$com$sun$glf$util$Glyph, class$com$sun$glf$util$GlyphPropertyEditor == null ? (class$com$sun$glf$util$GlyphPropertyEditor = CompositionStudio.class$("com.sun.glf.util.GlyphPropertyEditor")) : class$com$sun$glf$util$GlyphPropertyEditor);
        PropertyEditorManager.registerEditor(class$java$awt$Color == null ? (class$java$awt$Color = CompositionStudio.class$("java.awt.Color")) : class$java$awt$Color, class$com$sun$glf$util$ColorPropertyEditor == null ? (class$com$sun$glf$util$ColorPropertyEditor = CompositionStudio.class$("com.sun.glf.util.ColorPropertyEditor")) : class$com$sun$glf$util$ColorPropertyEditor);
        PropertyEditorManager.registerEditor(Boolean.TYPE, class$com$sun$glf$util$BooleanPropertyEditor == null ? (class$com$sun$glf$util$BooleanPropertyEditor = CompositionStudio.class$("com.sun.glf.util.BooleanPropertyEditor")) : class$com$sun$glf$util$BooleanPropertyEditor);
        PropertyEditorManager.registerEditor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = CompositionStudio.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$com$sun$glf$util$BooleanPropertyEditor == null ? (class$com$sun$glf$util$BooleanPropertyEditor = CompositionStudio.class$("com.sun.glf.util.BooleanPropertyEditor")) : class$com$sun$glf$util$BooleanPropertyEditor);
        PropertyEditorManager.registerEditor(class$java$awt$Font == null ? (class$java$awt$Font = CompositionStudio.class$("java.awt.Font")) : class$java$awt$Font, class$com$sun$glf$util$FontPropertyEditor == null ? (class$com$sun$glf$util$FontPropertyEditor = CompositionStudio.class$("com.sun.glf.util.FontPropertyEditor")) : class$com$sun$glf$util$FontPropertyEditor);
        PropertyEditorManager.registerEditor(class$java$awt$Dimension == null ? (class$java$awt$Dimension = CompositionStudio.class$("java.awt.Dimension")) : class$java$awt$Dimension, class$com$sun$glf$util$DimensionPropertyEditor == null ? (class$com$sun$glf$util$DimensionPropertyEditor = CompositionStudio.class$("com.sun.glf.util.DimensionPropertyEditor")) : class$com$sun$glf$util$DimensionPropertyEditor);
        PropertyEditorManager.registerEditor(class$java$io$File == null ? (class$java$io$File = CompositionStudio.class$("java.io.File")) : class$java$io$File, class$com$sun$glf$util$FilePropertyEditor == null ? (class$com$sun$glf$util$FilePropertyEditor = CompositionStudio.class$("com.sun.glf.util.FilePropertyEditor")) : class$com$sun$glf$util$FilePropertyEditor);
        PropertyEditorManager.registerEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = CompositionStudio.class$("java.lang.Integer")) : class$java$lang$Integer, class$com$sun$glf$util$IntegerPropertyEditor == null ? (class$com$sun$glf$util$IntegerPropertyEditor = CompositionStudio.class$("com.sun.glf.util.IntegerPropertyEditor")) : class$com$sun$glf$util$IntegerPropertyEditor);
        PropertyEditorManager.registerEditor(Integer.TYPE, class$com$sun$glf$util$IntegerPropertyEditor == null ? (class$com$sun$glf$util$IntegerPropertyEditor = CompositionStudio.class$("com.sun.glf.util.IntegerPropertyEditor")) : class$com$sun$glf$util$IntegerPropertyEditor);
        PropertyEditorManager.registerEditor(class$java$lang$Float == null ? (class$java$lang$Float = CompositionStudio.class$("java.lang.Float")) : class$java$lang$Float, class$com$sun$glf$util$FloatPropertyEditor == null ? (class$com$sun$glf$util$FloatPropertyEditor = CompositionStudio.class$("com.sun.glf.util.FloatPropertyEditor")) : class$com$sun$glf$util$FloatPropertyEditor);
        PropertyEditorManager.registerEditor(Float.TYPE, class$com$sun$glf$util$FloatPropertyEditor == null ? (class$com$sun$glf$util$FloatPropertyEditor = CompositionStudio.class$("com.sun.glf.util.FloatPropertyEditor")) : class$com$sun$glf$util$FloatPropertyEditor);
        PropertyEditorManager.registerEditor(class$java$lang$Double == null ? (class$java$lang$Double = CompositionStudio.class$("java.lang.Double")) : class$java$lang$Double, class$com$sun$glf$util$DoublePropertyEditor == null ? (class$com$sun$glf$util$DoublePropertyEditor = CompositionStudio.class$("com.sun.glf.util.DoublePropertyEditor")) : class$com$sun$glf$util$DoublePropertyEditor);
        PropertyEditorManager.registerEditor(Double.TYPE, class$com$sun$glf$util$DoublePropertyEditor == null ? (class$com$sun$glf$util$DoublePropertyEditor = CompositionStudio.class$("com.sun.glf.util.DoublePropertyEditor")) : class$com$sun$glf$util$DoublePropertyEditor);
        PropertyEditorManager.registerEditor(class$java$lang$String == null ? (class$java$lang$String = CompositionStudio.class$("java.lang.String")) : class$java$lang$String, class$com$sun$glf$util$StringPropertyEditor == null ? (class$com$sun$glf$util$StringPropertyEditor = CompositionStudio.class$("com.sun.glf.util.StringPropertyEditor")) : class$com$sun$glf$util$StringPropertyEditor);
        try {
            InputStream inputStream = (class$com$sun$glf$util$CompositionFrame == null ? (class$com$sun$glf$util$CompositionFrame = CompositionStudio.class$("com.sun.glf.util.CompositionFrame")) : class$com$sun$glf$util$CompositionFrame).getResourceAsStream("/com/sun/glf/res/config.properties");
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                String string = properties.getProperty("canSave", "no");
                isSaveEnabled = string.equalsIgnoreCase("sure");
                String string2 = properties.getProperty("canLoad", "no");
                isLoadEnabled = string2.equalsIgnoreCase("sure");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class SimpleFactory
    implements CompositionFactory {
        Color textColor = Color.black;
        Color backgroundColor = Color.white;
        Font textFont = new Font("Dialog", 0, 40);
        String text = "Hello There";
        boolean antialiasing;
        int width = 100;
        int height = 100;

        public Color getTextColor() {
            return this.textColor;
        }

        public void setTextColor(Color color) {
            this.textColor = color;
        }

        public Color getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(Color color) {
            this.backgroundColor = color;
        }

        public Font getTextFont() {
            return this.textFont;
        }

        public void setTextFont(Font font) {
            this.textFont = font;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public boolean getAntialiasing() {
            return this.antialiasing;
        }

        public void setAntialiasing(boolean bl) {
            this.antialiasing = bl;
        }

        public int getCompositionWidth() {
            return this.width;
        }

        public void setCompositionWidth(int n) {
            this.width = n;
        }

        public int getCompositionHeight() {
            return this.height;
        }

        public void setCompositionHeight(int n) {
            this.height = n;
        }

        public Composition build() {
            Dimension dimension = new Dimension(this.width, this.height);
            LayerComposition layerComposition = new LayerComposition(dimension);
            FillRenderer fillRenderer = new FillRenderer(this.textColor);
            TextLayer textLayer = new TextLayer(layerComposition, this.text, this.textFont, fillRenderer);
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            FillRenderer fillRenderer2 = new FillRenderer(this.backgroundColor);
            ShapeLayer shapeLayer = new ShapeLayer(layerComposition, rectangle, fillRenderer2);
            layerComposition.setLayers(new Layer[]{shapeLayer, textLayer});
            if (this.antialiasing) {
                RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                layerComposition.setRenderingHints(renderingHints);
            }
            return layerComposition;
        }
    }
}

