/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.util.Glyph;
import com.sun.glf.util.GlyphPreview;
import com.sun.glf.util.GridBagPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

class GlyphPanel
extends GridBagPanel {
    int tnWidth = 18;
    int tnHeight = 18;
    int tnFontSize = 15;
    GlyphPreview[] thumbNails = new GlyphPreview[255];
    GlyphPreview selected;
    char cStart = '\u0000';
    Font font;
    PropertyChangeSupport selectedChange;

    public GlyphPanel() {
        int n;
        GridBagPanel gridBagPanel = new GridBagPanel();
        Insets insets = new Insets(0, 0, 0, 0);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                GlyphPreview glyphPreview = (GlyphPreview)mouseEvent.getSource();
                GlyphPanel.this.setSelected(glyphPreview);
            }
        };
        Dimension dimension = new Dimension(this.tnWidth, this.tnHeight);
        for (n = 0; n < 10; ++n) {
            for (int i = 0; i < 25; ++i) {
                this.thumbNails[25 * n + i] = new GlyphPreview(true);
                this.thumbNails[25 * n + i].setPreferredSize(dimension);
                this.add(this.thumbNails[25 * n + i], i, n, 1, 1, 10, 0, 0.0, 0.0, insets);
                this.thumbNails[25 * n + i].addMouseListener(mouseAdapter);
            }
        }
        for (n = 0; n < 5; ++n) {
            this.thumbNails[250 + n] = new GlyphPreview(true);
            this.thumbNails[250 + n].setPreferredSize(dimension);
            this.add(this.thumbNails[250 + n], n, 10, 1, 1, 10, 0, 0.0, 0.0, insets);
            this.thumbNails[250 + n].addMouseListener(mouseAdapter);
        }
        this.selectedChange = new PropertyChangeSupport(this);
        this.selected = this.thumbNails[0];
        this.selected.setBackground(Color.red);
        this.setBackground(Color.white);
    }

    public void addSelectedChangeListener(PropertyChangeListener propertyChangeListener) {
        this.selectedChange.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeselectedChangeListener(PropertyChangeListener propertyChangeListener) {
        this.selectedChange.removePropertyChangeListener(propertyChangeListener);
    }

    public void setFont(Font font) {
        this.font = font;
        this.resetGlyphDisplay();
    }

    private void resetGlyphDisplay() {
        Font font = new Font(this.font.getName(), this.font.getStyle(), this.tnFontSize);
        if (this.thumbNails != null) {
            char c = (char)this.thumbNails.length;
            for (char c2 = '\u0000'; c2 < c; c2 = (char)(c2 + '\u0001')) {
                this.thumbNails[c2].setGlyph(new Glyph(font, (char)(this.cStart + c2)));
            }
            this.repaint();
        }
    }

    public void setRange(char c) {
        this.cStart = c;
        this.resetGlyphDisplay();
    }

    private void setSelected(GlyphPreview glyphPreview) {
        GlyphPreview glyphPreview2 = this.selected;
        this.selected = glyphPreview;
        glyphPreview2.setBackground(Color.white);
        glyphPreview.setBackground(Color.red);
        glyphPreview2.repaint();
        glyphPreview.repaint();
        this.selectedChange.firePropertyChange("selected", glyphPreview2, this.selected);
    }

    public void setSelected(int n) {
        if (n < 0 || n >= 255) {
            throw new IllegalArgumentException();
        }
        this.setSelected(this.thumbNails[n]);
    }

    public Glyph getSelected() {
        Glyph glyph = this.selected.getGlyph();
        return new Glyph(this.font, glyph.getChar());
    }
}

