/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.util.GridBagPanel;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JAlphaSlider
extends GridBagPanel {
    private PropertyChangeSupport alphaValueChangeSupport = new PropertyChangeSupport(this);
    private double alphaValue;
    private boolean settingValue;

    public JAlphaSlider() {
        final JSlider jSlider = new JSlider(0, 0, 100, 0);
        final JLabel jLabel = new JLabel();
        jLabel.setHorizontalTextPosition(0);
        jLabel.setHorizontalAlignment(0);
        Dimension dimension = jSlider.getPreferredSize();
        jSlider.setPreferredSize(new Dimension(100, dimension.height));
        JLabel jLabel2 = new JLabel("100%");
        jLabel.setPreferredSize(jLabel2.getPreferredSize());
        this.add(jSlider, 0, 0, 1, 1, 10, 2, 0.0, 0.0);
        this.add(jLabel, 1, 0, 1, 1, 10, 2, 0.0, 0.0);
        this.add(Box.createHorizontalGlue(), 4, 1, 1, 1, 10, 2, 1.0, 0.0);
        jSlider.addChangeListener(new ChangeListener(){

            public synchronized void stateChanged(ChangeEvent changeEvent) {
                int n = jSlider.getValue();
                jLabel.setText("" + n + "%");
                JAlphaSlider.this.settingValue = true;
                JAlphaSlider.this.setAlphaValue((double)n / 100.0);
                JAlphaSlider.this.settingValue = false;
            }
        });
        this.addAlphaValueChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!JAlphaSlider.this.settingValue) {
                    int n = (int)Math.rint(JAlphaSlider.this.alphaValue * 100.0);
                    jSlider.setValue(n);
                }
            }
        });
    }

    public void setAlphaValue(double d) {
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("alphaValue is off limit : " + d);
        }
        double d2 = this.alphaValue;
        this.alphaValue = d;
        this.alphaValueChangeSupport.firePropertyChange("alphaValue", new Double(d2), new Double(d));
    }

    public double getAlphaValue() {
        return this.alphaValue;
    }

    public void addAlphaValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.alphaValueChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeAlphaValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.alphaValueChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

