/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.HitStore;
import com.sun.java.help.search.Location;
import com.sun.java.help.search.QueryHit;
import com.sun.java.help.search.SearchEnvironment;
import java.util.Vector;
import javax.help.search.SearchItem;
import javax.help.search.SearchQuery;

class Query {
    private double _currentStandard;
    private final int _nColumns;
    private double[] _missingPenalty;
    private double[] _upperboundTemplate;
    private double[] _penalties;
    private final SearchEnvironment _env;
    private int _hitCounter;
    private boolean _vote;
    private HitStore _store;

    public Query(SearchEnvironment searchEnvironment, int n, double[] dArray) {
        this._env = searchEnvironment;
        this._nColumns = n;
        this._missingPenalty = new double[n];
        this._upperboundTemplate = new double[n];
        this._penalties = dArray;
        this._hitCounter = 0;
        this._vote = false;
        this._currentStandard = (double)(n - 1) * 10.0 + 9.9999;
        this._store = new HitStore(this._currentStandard);
        int n2 = 0;
        while (n2 < this._nColumns) {
            this._missingPenalty[n2] = dArray != null ? dArray[n2] : 10.0;
            ++n2;
        }
        this.makePenaltiesTable();
    }

    public void makeEvent(int n, SearchQuery searchQuery) {
        Vector<SearchItem> vector = new Vector<SearchItem>(n);
        if (n > 0) {
            int n2 = n;
            QueryHit queryHit = this._store.firstBestQueryHit();
            n = n2;
            while (queryHit != null) {
                try {
                    vector.addElement(this._env.makeItem(queryHit));
                }
                catch (Exception exception) {
                    System.err.println(exception + "hit not translated");
                }
                QueryHit queryHit2 = queryHit = --n > 0 ? this._store.nextBestQueryHit() : null;
            }
        }
        searchQuery.itemsFound(true, vector);
    }

    public double lookupPenalty(int n) {
        return this._penalties[n];
    }

    public double getOutOufOrderPenalty() {
        return 0.25;
    }

    public double getGapPenalty() {
        return 0.005;
    }

    public int getNColumns() {
        return this._nColumns;
    }

    public boolean goodEnough(double d) {
        return d <= this._currentStandard;
    }

    public int[] getConceptArrayOfNewHit(double d, Location location) {
        QueryHit queryHit = new QueryHit(location, d, this._nColumns);
        this._store.addQueryHit(queryHit);
        ++this._hitCounter;
        return queryHit.getArray();
    }

    public void resetForNextDocument() {
        this._currentStandard = this._store.getCurrentStandard();
        int n = 0;
        while (n < this._nColumns) {
            this._upperboundTemplate[n] = this._missingPenalty[n];
            ++n;
        }
        this._vote = false;
    }

    public boolean vote() {
        double d = 0.0;
        int n = 0;
        while (n < this._nColumns) {
            d += this._upperboundTemplate[n];
            ++n;
        }
        this._vote = d <= this._currentStandard;
        return this._vote;
    }

    public void updateEstimate(int n, double d) {
        if (d < this._upperboundTemplate[n]) {
            this._upperboundTemplate[n] = d;
        }
    }

    public void printHits(int n) {
        if (n > 0) {
            int n2 = n;
            QueryHit queryHit = this._store.firstBestQueryHit();
            n = n2;
            while (queryHit != null) {
                try {
                    System.out.println(this._env.hitToString(queryHit));
                }
                catch (Exception exception) {
                    System.err.println(exception + "hit not translated");
                }
                QueryHit queryHit2 = queryHit = --n > 0 ? this._store.nextBestQueryHit() : null;
            }
        }
    }

    private void makePenaltiesTable() {
        int n = 1 << this._nColumns;
        this._penalties = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this._penalties[n2] = this.computePenalty(n2);
            ++n2;
        }
    }

    private double computePenalty(int n) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < this._nColumns) {
            if ((n & 1 << n2) == 0) {
                d += this._missingPenalty[n2];
            }
            ++n2;
        }
        return d;
    }
}

