/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.giny.CytoscapeFingRootGraph;
import cytoscape.groups.CyGroup;
import cytoscape.groups.CyGroupManager;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.model.RootGraph;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyNode
implements Node {
    public static final String NESTED_NETWORK_ID_ATTR = "nested_network_id";
    public static final String NESTED_NETWORK_IS_VISIBLE_ATTR = "nested_network_is_visible";
    public static final String HAS_NESTED_NETWORK_ATTR = "has_nested_network";
    public static final String PARENT_NODES_ATTR = "parent_nodes";
    CytoscapeFingRootGraph m_rootGraph = null;
    int m_rootGraphIndex = 0;
    String m_identifier = null;
    ArrayList<CyGroup> groupList = null;
    private GraphPerspective nestedNetwork;

    public CyNode(RootGraph root, int rootGraphIndex) {
        this.m_rootGraph = (CytoscapeFingRootGraph)root;
        this.m_rootGraphIndex = rootGraphIndex;
        this.m_identifier = new Integer(this.m_rootGraphIndex).toString();
        this.nestedNetwork = null;
    }

    @Override
    public GraphPerspective getGraphPerspective() {
        return this.m_rootGraph.createGraphPerspective(this.m_rootGraph.getNodeMetaChildIndicesArray(this.m_rootGraphIndex), this.m_rootGraph.getEdgeMetaChildIndicesArray(this.m_rootGraphIndex));
    }

    @Override
    public boolean setGraphPerspective(GraphPerspective gp) {
        int i;
        if (gp.getRootGraph() != this.m_rootGraph) {
            return false;
        }
        int[] nodeInx = gp.getNodeIndicesArray();
        int[] edgeInx = gp.getEdgeIndicesArray();
        for (i = 0; i < nodeInx.length; ++i) {
            this.m_rootGraph.addNodeMetaChild(this.m_rootGraphIndex, nodeInx[i]);
        }
        for (i = 0; i < edgeInx.length; ++i) {
            this.m_rootGraph.addEdgeMetaChild(this.m_rootGraphIndex, edgeInx[i]);
        }
        return true;
    }

    @Override
    public RootGraph getRootGraph() {
        return this.m_rootGraph;
    }

    @Override
    public int getRootGraphIndex() {
        return this.m_rootGraphIndex;
    }

    @Override
    public String getIdentifier() {
        return this.m_identifier;
    }

    @Override
    public boolean setIdentifier(String new_id) {
        if (new_id == null) {
            this.m_rootGraph.setNodeIdentifier(this.m_identifier, 0);
        } else {
            this.m_rootGraph.setNodeIdentifier(new_id, this.m_rootGraphIndex);
        }
        this.m_identifier = new_id;
        return true;
    }

    public void addToGroup(CyGroup group) {
        if (this.groupList == null) {
            this.groupList = new ArrayList();
        }
        this.groupList.add(group);
        if (!group.contains(this)) {
            group.addNode(this);
        }
    }

    public void removeFromGroup(CyGroup group) {
        this.groupList.remove(group);
        this.groupList.trimToSize();
        if (group.contains(this)) {
            group.removeNode(this);
        }
    }

    public List<CyGroup> getGroups() {
        return this.groupList;
    }

    public boolean inGroup(CyGroup group) {
        if (this.groupList == null) {
            return false;
        }
        return this.groupList.contains(group);
    }

    public boolean isaGroup() {
        return CyGroupManager.isaGroup(this);
    }

    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public void setNestedNetwork(GraphPerspective graphPerspective) {
        List<String> parentNodeList;
        if (graphPerspective == this.nestedNetwork) {
            return;
        }
        GraphPerspective oldNestedNetwork = this.nestedNetwork;
        String nodeID = this.getIdentifier();
        String networkID = ((CyNetwork)(graphPerspective == null ? this.nestedNetwork : graphPerspective)).getIdentifier();
        this.nestedNetwork = graphPerspective;
        String[] attributeNames = Cytoscape.getNetworkAttributes().getAttributeNames();
        boolean attrFound = false;
        for (String name : attributeNames) {
            if (!name.equals(PARENT_NODES_ATTR)) continue;
            attrFound = true;
            break;
        }
        if (!attrFound) {
            parentNodeList = new ArrayList<String>();
            parentNodeList.add(nodeID);
        } else {
            parentNodeList = Cytoscape.getNetworkAttributes().getListAttribute(networkID, PARENT_NODES_ATTR);
            if (this.nestedNetwork != null) {
                parentNodeList.add(nodeID);
            } else {
                parentNodeList.remove(nodeID);
            }
        }
        Cytoscape.getNetworkAttributes().setListAttribute(networkID, PARENT_NODES_ATTR, parentNodeList);
        if (graphPerspective != null) {
            Cytoscape.getNodeAttributes().setAttribute(nodeID, HAS_NESTED_NETWORK_ATTR, "yes");
            Cytoscape.getNodeAttributes().setAttribute(nodeID, NESTED_NETWORK_IS_VISIBLE_ATTR, new Boolean(true));
            Cytoscape.getNodeAttributes().setAttribute(nodeID, NESTED_NETWORK_ID_ATTR, networkID);
        } else {
            Cytoscape.getNodeAttributes().deleteAttribute(nodeID, HAS_NESTED_NETWORK_ATTR);
            Cytoscape.getNodeAttributes().deleteAttribute(nodeID, NESTED_NETWORK_IS_VISIBLE_ATTR);
            Cytoscape.getNodeAttributes().deleteAttribute(nodeID, NESTED_NETWORK_ID_ATTR);
        }
        if (oldNestedNetwork != null) {
            Cytoscape.getPropertyChangeSupport().firePropertyChange("NESTED_NETWORK_DESTROYED", this, oldNestedNetwork);
        }
        if (this.nestedNetwork != null) {
            Cytoscape.getPropertyChangeSupport().firePropertyChange("NESTED_NETWORK_CREATED", this, graphPerspective);
        }
    }

    @Override
    public GraphPerspective getNestedNetwork() {
        return this.nestedNetwork;
    }
}

