/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.AttributeSaverState;
import cytoscape.logger.CyLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class AttributeSaverDialog
extends JDialog {
    protected static final String NODE_SUFFIX = ".NA";
    protected static final String EDGE_SUFFIX = ".EA";
    protected static final int MAX_PREFERRED_SIZE = 100;
    public static final int NODES = 0;
    public static final int EDGES = 1;
    private AttributeSaverState state;
    private JTable attributeTable;
    protected JButton saveButton = new JButton("Choose Directory and Save");
    protected static CyLogger logger = CyLogger.getLogger(AttributeSaverDialog.class);

    protected static void showDialog(int type) {
        AttributeSaverDialog dialog = new AttributeSaverDialog(type);
        dialog.setVisible(true);
    }

    public static void showEdgeDialog() {
        AttributeSaverDialog.showDialog(1);
    }

    public static void showNodeDialog() {
        AttributeSaverDialog.showDialog(0);
    }

    public AttributeSaverDialog(int type) {
        super(Cytoscape.getDesktop(), "Save Attributes", true);
        String[] attributes;
        String suffix;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        if (type == 0) {
            suffix = NODE_SUFFIX;
            attributes = Cytoscape.getNodeAttributes().getAttributeNames();
        } else {
            suffix = EDGE_SUFFIX;
            attributes = Cytoscape.getEdgeAttributes().getAttributeNames();
        }
        this.state = new AttributeSaverState(attributes, suffix, type);
        TableModelListener tmListener = new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (AttributeSaverDialog.this.state.saveChecked()) {
                    AttributeSaverDialog.this.saveButton.setEnabled(true);
                } else {
                    AttributeSaverDialog.this.saveButton.setEnabled(false);
                }
            }
        };
        this.state.addTableModelListener(tmListener);
        this.attributeTable = new JTable(this.state);
        this.attributeTable.setToolTipText("Select multiple attributes to save. Modify \"Filename\" field to specify filename");
        this.attributeTable.setCellSelectionEnabled(false);
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser myChooser = new JFileChooser(CytoscapeInit.getMRUD());
                myChooser.setFileSelectionMode(1);
                if (myChooser.showSaveDialog(Cytoscape.getDesktop()) == 0) {
                    AttributeSaverDialog.this.state.setSaveDirectory(myChooser.getSelectedFile());
                    CytoscapeInit.setMRUD(myChooser.getSelectedFile());
                    int count = 0;
                    try {
                        count = AttributeSaverDialog.this.state.writeState();
                        JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Successfully saved " + count + " files");
                    }
                    catch (IOException e) {
                        logger.warn("Unable to save attributes", e);
                        JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Error saving attributes: " + e.getMessage(), "Attribute Save Error", 2);
                    }
                    AttributeSaverDialog.this.dispose();
                }
            }
        });
        JPanel centerPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(this.attributeTable);
        scrollPane.setPreferredSize(new Dimension(100, 100));
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.add(new JLabel("Select multiple attributes to save. Edit table to change filenames"));
        centerPanel.add(scrollPane);
        JPanel southPanel = new JPanel();
        southPanel.add(this.saveButton);
        contentPane.add((Component)centerPanel, "Center");
        contentPane.add((Component)southPanel, "South");
        this.pack();
    }
}

