/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.Cytoscape;
import cytoscape.data.AttribTopoGraphNode;
import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import cytoscape.data.attr.MultiHashMapDefinition;
import cytoscape.data.attr.util.MultiHashMapFactory;
import cytoscape.logger.CyLogger;
import cytoscape.util.TopoGraphNode;
import cytoscape.util.TopologicalSort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.cytoscape.equations.BooleanList;
import org.cytoscape.equations.DoubleList;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.LongList;
import org.cytoscape.equations.StringList;
import org.cytoscape.equations.interpreter.IdentDescriptor;
import org.cytoscape.equations.interpreter.Interpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyAttributesImpl
implements CyAttributes {
    private final MultiHashMap mmap;
    private final MultiHashMapDefinition mmapDef;
    private Map descriptionMap;
    private Set userInvisibleSet;
    private Set userNonEditableSet;
    private String lastEquationError = null;
    private Set<String> currentlyActiveAttributes = new TreeSet<String>();
    protected static final CyLogger logger = CyLogger.getLogger(Cytoscape.class);

    public CyAttributesImpl() {
        Object model = MultiHashMapFactory.instantiateDataModel();
        this.mmap = (MultiHashMap)model;
        this.mmapDef = (MultiHashMapDefinition)model;
        this.descriptionMap = new HashMap();
        this.userInvisibleSet = new HashSet();
        this.userNonEditableSet = new HashSet();
    }

    @Override
    public void setAttributeDescription(String attributeName, String description) {
        this.descriptionMap.put(attributeName, description);
    }

    @Override
    public String getAttributeDescription(String attributeName) {
        return (String)this.descriptionMap.get(attributeName);
    }

    @Override
    public void setUserVisible(String attributeName, boolean value) {
        if (value) {
            if (this.userInvisibleSet.contains(attributeName)) {
                this.userInvisibleSet.remove(attributeName);
            }
        } else if (!this.userInvisibleSet.contains(attributeName)) {
            this.userInvisibleSet.add(attributeName);
        }
    }

    @Override
    public boolean getUserVisible(String attributeName) {
        return !this.userInvisibleSet.contains(attributeName);
    }

    @Override
    public void setUserEditable(String attributeName, boolean value) {
        if (value) {
            if (this.userNonEditableSet.contains(attributeName)) {
                this.userNonEditableSet.remove(attributeName);
            }
        } else if (!this.userNonEditableSet.contains(attributeName)) {
            this.userNonEditableSet.add(attributeName);
        }
    }

    @Override
    public boolean getUserEditable(String attributeName) {
        return !this.userNonEditableSet.contains(attributeName);
    }

    @Override
    public String[] getAttributeNames() {
        CountedIterator citer = this.mmapDef.getDefinedAttributes();
        String[] names = new String[citer.numRemaining()];
        int inx = 0;
        while (citer.hasNext()) {
            names[inx++] = (String)citer.next();
        }
        return names;
    }

    @Override
    public boolean hasAttribute(String id, String attributeName) {
        byte valType = this.mmapDef.getAttributeValueType(attributeName);
        if (valType < 0) {
            return false;
        }
        byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
        if (dimTypes.length == 0) {
            return this.mmap.getAttributeValue(id, attributeName, null) != null;
        }
        return this.mmap.getAttributeKeyspan(id, attributeName, null).numRemaining() > 0;
    }

    @Override
    public void setAttribute(String id, String attributeName, Boolean value) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            this.mmapDef.defineAttribute(attributeName, (byte)1, null);
        } else {
            if (type != 1) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_BOOLEAN");
            }
            byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (dimTypes.length != 0) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_BOOLEAN");
            }
        }
        this.mmap.setAttributeValue(id, attributeName, value, null);
    }

    @Override
    public void setAttribute(String id, String attributeName, Integer value) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            this.mmapDef.defineAttribute(attributeName, (byte)3, null);
        } else {
            if (type != 3) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_INTEGER");
            }
            byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (dimTypes.length != 0) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_INTEGER");
            }
        }
        this.mmap.setAttributeValue(id, attributeName, value, null);
    }

    @Override
    public void setAttribute(String id, String attributeName, Double value) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            this.mmapDef.defineAttribute(attributeName, (byte)2, null);
        } else {
            if (type != 2) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_FLOATING");
            }
            byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (dimTypes.length != 0) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_FLOATING");
            }
        }
        this.mmap.setAttributeValue(id, attributeName, value, null);
    }

    @Override
    public void setAttribute(String id, String attributeName, String value) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            this.mmapDef.defineAttribute(attributeName, (byte)4, null);
        } else {
            if (type != 4) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_STRING");
            }
            byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (dimTypes.length != 0) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_STRING");
            }
        }
        this.mmap.setAttributeValue(id, attributeName, value, null);
    }

    @Override
    public void setAttribute(String id, String attributeName, Equation equation) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        Class returnType = equation.getType();
        if (type < 0) {
            byte mappedType;
            if (returnType == Double.class) {
                mappedType = 2;
            } else if (returnType == String.class) {
                mappedType = 4;
            } else if (returnType == Boolean.class) {
                mappedType = 1;
            } else {
                throw new IllegalStateException("unknown equation return type: " + returnType + "!");
            }
            this.mmapDef.defineAttribute(attributeName, mappedType, null);
        } else {
            byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (dimTypes.length != 0) {
                throw new IllegalArgumentException("definition for \"" + attributeName + "\" already exists and it is not of a scalar type!");
            }
            if (type != 4) {
                if (type == 3) {
                    if (returnType != Long.class && returnType != Double.class && returnType != Boolean.class) {
                        throw new IllegalArgumentException("an equation of type " + returnType + " is not compatible with TYPE_INTEGER for attribute \"" + attributeName + "\"!");
                    }
                } else if (type == 2) {
                    if (returnType != Double.class && returnType != Long.class && returnType != Boolean.class) {
                        throw new IllegalArgumentException("an equation of type " + returnType + " is not compatible with TYPE_FLOATING_POINT for attribute \"" + attributeName + "\"!");
                    }
                } else if (type == 1) {
                    if (returnType != Boolean.class && returnType != Long.class && returnType != Double.class) {
                        throw new IllegalArgumentException("an equation of type " + returnType + " is not compatible with TYPE_BOOLEAN for attribute \"" + attributeName + "\"!");
                    }
                } else {
                    throw new IllegalArgumentException("an equation of type " + returnType + " is not compatible with attribute \"" + attributeName + "\"!");
                }
            }
        }
        this.mmap.setAttributeValue(id, attributeName, equation, null);
    }

    @Override
    public void setAttribute(String id, String attributeName, Equation equation, byte dataType) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        Class returnType = equation.getType();
        if (type < 0) {
            if (dataType != 4) {
                if (type == 3) {
                    if (returnType != Double.class && returnType != Boolean.class) {
                        throw new IllegalArgumentException("an equation of type " + returnType + " is not compatible with TYPE_INTEGER for attribute \"" + attributeName + "\"!");
                    }
                } else if (dataType == 2 && returnType != Double.class && returnType != Boolean.class) {
                    throw new IllegalArgumentException("an equation of type " + returnType + " is not compatible with TYPE_FLOATING_POINT for attribute \"" + attributeName + "\"!");
                }
            }
            this.mmapDef.defineAttribute(attributeName, dataType, null);
        } else {
            byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (dimTypes.length != 0) {
                throw new IllegalArgumentException("definition for \"" + attributeName + "\" already exists and it is not of a scalar type!");
            }
            if (type != dataType) {
                throw new IllegalArgumentException("incompatible data type!");
            }
            if (type != 4) {
                if (type == 3) {
                    if (returnType != Double.class && returnType != Boolean.class && returnType != Long.class) {
                        throw new IllegalArgumentException("an equation of type " + returnType + " is not compatible with TYPE_INTEGER for attribute \"" + attributeName + "\"!");
                    }
                } else if (type == 2 && returnType != Double.class && returnType != Boolean.class) {
                    throw new IllegalArgumentException("an equation of type " + returnType + " is not compatible with TYPE_FLOATING_POINT for attribute \"" + attributeName + "\"!");
                }
            }
        }
        this.mmap.setAttributeValue(id, attributeName, equation, null);
    }

    @Override
    public Boolean getBooleanAttribute(String id, String attributeName) {
        this.lastEquationError = null;
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            return null;
        }
        if (type != 1) {
            throw new ClassCastException("definition for attributeName '" + attributeName + "' is not of TYPE_BOOLEAN");
        }
        Object attribValue = this.mmap.getAttributeValue(id, attributeName, null);
        if (attribValue == null) {
            return null;
        }
        if (attribValue instanceof Boolean) {
            return (Boolean)attribValue;
        }
        StringBuilder errorMessage = new StringBuilder();
        Object equationValue = this.evalEquation(id, attributeName, (Equation)attribValue, errorMessage);
        if (equationValue == null) {
            this.lastEquationError = errorMessage.toString();
            return null;
        }
        return this.convertEqnRetValToBoolean(id, attributeName, equationValue);
    }

    @Override
    public Integer getIntegerAttribute(String id, String attributeName) {
        this.lastEquationError = null;
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            return null;
        }
        if (type != 3) {
            throw new ClassCastException("definition for attributeName '" + attributeName + "' is not of TYPE_INTEGER");
        }
        Object attribValue = this.mmap.getAttributeValue(id, attributeName, null);
        if (attribValue == null) {
            return null;
        }
        if (attribValue instanceof Integer) {
            return (Integer)attribValue;
        }
        StringBuilder errorMessage = new StringBuilder();
        Object equationValue = this.evalEquation(id, attributeName, (Equation)attribValue, errorMessage);
        if (equationValue == null) {
            this.lastEquationError = errorMessage.toString();
            return null;
        }
        if (equationValue.getClass() == Long.class) {
            long valueAsLong = (Long)equationValue;
            return (int)valueAsLong;
        }
        if (equationValue.getClass() == Boolean.class) {
            Boolean valueAsBoolean = (Boolean)equationValue;
            return valueAsBoolean != false ? 1 : 0;
        }
        if (equationValue.getClass() == String.class) {
            String valueAsString = (String)equationValue;
            try {
                double valueAsDouble = Double.parseDouble(valueAsString);
                return (int)CyAttributesImpl.excelTrunc(valueAsDouble);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("\"" + valueAsString + "\" cannot be interpreted as an integer value!");
            }
        }
        if (equationValue.getClass() == Double.class) {
            double valueAsDouble = (Double)equationValue;
            return (int)CyAttributesImpl.excelTrunc(valueAsDouble);
        }
        throw new IllegalStateException("an equation returned an unknown class type: " + equationValue.getClass() + "!");
    }

    @Override
    public Double getDoubleAttribute(String id, String attributeName) {
        this.lastEquationError = null;
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            return null;
        }
        if (type != 2) {
            throw new ClassCastException("definition for attributeName '" + attributeName + "' is not of TYPE_FLOATING");
        }
        Object attribValue = this.mmap.getAttributeValue(id, attributeName, null);
        if (attribValue == null) {
            return null;
        }
        if (attribValue instanceof Double) {
            return (Double)attribValue;
        }
        StringBuilder errorMessage = new StringBuilder();
        Object equationValue = this.evalEquation(id, attributeName, (Equation)attribValue, errorMessage);
        if (equationValue == null) {
            this.lastEquationError = errorMessage.toString();
            return null;
        }
        return this.convertEqnRetValToDouble(id, attributeName, equationValue);
    }

    @Override
    public String getStringAttribute(String id, String attributeName) {
        this.lastEquationError = null;
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            return null;
        }
        if (type != 4) {
            throw new ClassCastException("definition for attributeName '" + attributeName + "' is not of TYPE_STRING");
        }
        Object attribValue = this.mmap.getAttributeValue(id, attributeName, null);
        if (attribValue == null) {
            return null;
        }
        if (attribValue instanceof String) {
            return (String)attribValue;
        }
        StringBuilder errorMessage = new StringBuilder();
        Object equationValue = this.evalEquation(id, attributeName, (Equation)attribValue, errorMessage);
        if (equationValue == null) {
            this.lastEquationError = errorMessage.toString();
            return null;
        }
        return equationValue.toString();
    }

    @Override
    public Object getAttribute(String id, String attributeName) {
        this.lastEquationError = null;
        byte type = this.getType(attributeName);
        if (type == -2) {
            return this.getListAttribute(id, attributeName);
        }
        if (type == -3) {
            return this.getMapAttribute(id, attributeName);
        }
        if (type == -1 || type == -4) {
            return null;
        }
        Object attribValue = this.mmap.getAttributeValue(id, attributeName, null);
        if (attribValue == null) {
            return null;
        }
        if (attribValue instanceof Equation) {
            StringBuilder errorMessage = new StringBuilder();
            Object equationValue = this.evalEquation(id, attributeName, (Equation)attribValue, errorMessage);
            if (equationValue == null) {
                this.lastEquationError = errorMessage.toString();
                return null;
            }
            if (type == 3) {
                return this.convertEqnRetValToInteger(id, attributeName, equationValue);
            }
            if (type == 2) {
                return this.convertEqnRetValToDouble(id, attributeName, equationValue);
            }
            if (type == 1) {
                return this.convertEqnRetValToBoolean(id, attributeName, equationValue);
            }
            if (type == 4) {
                return equationValue.toString();
            }
            return equationValue;
        }
        return attribValue;
    }

    @Override
    public byte getType(String attributeName) {
        byte valType = this.mmapDef.getAttributeValueType(attributeName);
        if (valType < 0) {
            return -1;
        }
        byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
        if (dimTypes.length == 0) {
            return valType;
        }
        if (dimTypes.length > 1) {
            return -4;
        }
        if (dimTypes[0] == 3) {
            return -2;
        }
        if (dimTypes[0] == 4) {
            return -3;
        }
        return -4;
    }

    @Override
    public byte getListElementType(String attributeName) {
        byte valType = this.mmapDef.getAttributeValueType(attributeName);
        if (valType < 0) {
            throw new IllegalArgumentException("'" + attributeName + "' is not a simple list attribute!");
        }
        byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
        if (dimTypes.length != 1 || dimTypes[0] != 3) {
            throw new IllegalArgumentException("'" + attributeName + "' is not a simple list attribute!");
        }
        return valType;
    }

    @Override
    public boolean deleteAttribute(String id, String attributeName) {
        boolean b = this.mmap.removeAllAttributeValues(id, attributeName);
        return b;
    }

    @Override
    public boolean deleteAttribute(String attributeName) {
        boolean b = this.mmapDef.undefineAttribute(attributeName);
        return b;
    }

    @Override
    public void setListAttribute(String id, String attributeName, List list) {
        byte type;
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        if (list == null) {
            throw new IllegalArgumentException("list is null");
        }
        Iterator itor = list.iterator();
        if (!itor.hasNext()) {
            return;
        }
        Object obj = itor.next();
        if (obj instanceof Double) {
            type = 2;
        } else if (obj instanceof Integer) {
            type = 3;
        } else if (obj instanceof Boolean) {
            type = 1;
        } else if (obj instanceof String) {
            type = 4;
        } else {
            throw new IllegalArgumentException("objects in list are of unrecognized type");
        }
        while (itor.hasNext()) {
            obj = itor.next();
            if (!(type == 2 && !(obj instanceof Double) || type == 3 && !(obj instanceof Integer) || type == 1 && !(obj instanceof Boolean)) && (type != 4 || obj instanceof String)) continue;
            throw new IllegalArgumentException("items in list are not all of the same type");
        }
        byte valType = this.mmapDef.getAttributeValueType(attributeName);
        if (valType < 0) {
            this.mmapDef.defineAttribute(attributeName, type, new byte[]{3});
        } else {
            if (valType != type) {
                throw new IllegalArgumentException("existing definition for attributeName '" + attributeName + "' is a TYPE_SIMPLE_LIST that stores other value types");
            }
            byte[] keyTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (keyTypes.length != 1 || keyTypes[0] != 3) {
                throw new IllegalArgumentException("existing definition for attributeName '" + attributeName + "' is not of TYPE_SIMPLE_LIST");
            }
        }
        this.mmap.removeAllAttributeValues(id, attributeName);
        itor = list.iterator();
        int inx = 0;
        Object[] key = new Object[1];
        while (itor.hasNext()) {
            key[0] = new Integer(inx++);
            this.mmap.setAttributeValue(id, attributeName, itor.next(), key);
        }
    }

    @Override
    public void setListAttribute(String id, String attributeName, Equation equation) {
        byte type;
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        if (equation == null) {
            throw new IllegalArgumentException("equation is null");
        }
        Class returnType = equation.getType();
        if (returnType == DoubleList.class) {
            type = 2;
        } else if (returnType == LongList.class) {
            type = 3;
        } else if (returnType == BooleanList.class) {
            type = 1;
        } else if (returnType == StringList.class) {
            type = 4;
        } else {
            throw new IllegalArgumentException("objects in list are of unrecognized type");
        }
        byte valType = this.mmapDef.getAttributeValueType(attributeName);
        if (valType < 0) {
            this.mmapDef.defineAttribute(attributeName, type, new byte[]{3});
        } else {
            if (valType != type) {
                throw new IllegalArgumentException("existing definition for attributeName '" + attributeName + "' is a TYPE_SIMPLE_LIST that stores other value types");
            }
            byte[] keyTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (keyTypes.length != 1 || keyTypes[0] != 3) {
                throw new IllegalArgumentException("existing definition for attributeName '" + attributeName + "' is not of TYPE_SIMPLE_LIST");
            }
        }
        this.mmap.removeAllAttributeValues(id, attributeName);
        Object[] key = new Object[]{new Integer(-1)};
        this.mmap.setAttributeValue(id, attributeName, equation, key);
    }

    @Override
    public List getAttributeList(String id, String attributeName) {
        return this.getListAttribute(id, attributeName);
    }

    @Override
    public List getListAttribute(String id, String attributeName) {
        this.lastEquationError = null;
        if (this.mmapDef.getAttributeValueType(attributeName) < 0) {
            return null;
        }
        byte[] keyTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
        if (keyTypes.length != 1 || keyTypes[0] != 3) {
            throw new ClassCastException("attributeName '" + attributeName + "' is not of TYPE_SIMPLE_LIST");
        }
        Object equation = this.mmap.getAttributeValue(id, attributeName, new Object[]{new Integer(-1)});
        if (equation != null) {
            StringBuilder errorMessage = new StringBuilder();
            Object equationValue = this.evalEquation(id, attributeName, (Equation)equation, errorMessage);
            if (equationValue == null) {
                this.lastEquationError = errorMessage.toString();
                return null;
            }
            if (equationValue instanceof LongList) {
                ArrayList<Integer> intList = new ArrayList<Integer>();
                for (Long l : (LongList)equationValue) {
                    intList.add((int)l.longValue());
                }
                return intList;
            }
            return (List)equationValue;
        }
        ArrayList<Object> returnThis = new ArrayList<Object>();
        Object[] key = new Object[1];
        int i = 0;
        while (true) {
            key[0] = new Integer(i);
            Object val = this.mmap.getAttributeValue(id, attributeName, key);
            if (val == null) break;
            returnThis.add(i, val);
            ++i;
        }
        return returnThis;
    }

    @Override
    public void setMapAttribute(String id, String attributeName, Map map) {
        byte type;
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        Set entrySet = map.entrySet();
        Iterator itor = entrySet.iterator();
        if (!itor.hasNext()) {
            return;
        }
        Map.Entry entry = itor.next();
        if (!(entry.getKey() instanceof String)) {
            throw new IllegalArgumentException("keys in map are not all String");
        }
        Object val = entry.getValue();
        if (val instanceof Double) {
            type = 2;
        } else if (val instanceof Integer) {
            type = 3;
        } else if (val instanceof Boolean) {
            type = 1;
        } else if (val instanceof String) {
            type = 4;
        } else {
            throw new IllegalArgumentException("values in map are of unrecognized type");
        }
        while (itor.hasNext()) {
            entry = itor.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("keys in map are not all String");
            }
            val = entry.getValue();
            if (!(type == 2 && !(val instanceof Double) || type == 3 && !(val instanceof Integer) || type == 1 && !(val instanceof Boolean)) && (type != 4 || val instanceof String)) continue;
            throw new IllegalArgumentException("values in map are not all of the same type");
        }
        byte valType = this.mmapDef.getAttributeValueType(attributeName);
        if (valType < 0) {
            this.mmapDef.defineAttribute(attributeName, type, new byte[]{4});
        } else {
            if (valType != type) {
                throw new IllegalArgumentException("existing definition for attributeName '" + attributeName + "' is a TYPE_SIMPLE_MAP that stores other value types");
            }
            byte[] keyTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (keyTypes.length != 1 || keyTypes[0] != 4) {
                throw new IllegalArgumentException("existing definition for attributeName '" + attributeName + "' is not of TYPE_SIMPLE_MAP");
            }
        }
        this.mmap.removeAllAttributeValues(id, attributeName);
        itor = entrySet.iterator();
        Object[] key = new Object[1];
        while (itor.hasNext()) {
            entry = itor.next();
            key[0] = entry.getKey();
            this.mmap.setAttributeValue(id, attributeName, entry.getValue(), key);
        }
    }

    @Override
    public Map getAttributeMap(String id, String attributeName) {
        return this.getMapAttribute(id, attributeName);
    }

    @Override
    public Map getMapAttribute(String id, String attributeName) {
        this.lastEquationError = null;
        if (this.mmapDef.getAttributeValueType(attributeName) < 0) {
            return null;
        }
        byte[] keyTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
        if (keyTypes.length != 1 || keyTypes[0] != 4) {
            throw new ClassCastException("attributeName '" + attributeName + "' is not of TYPE_SIMPLE_MAP");
        }
        HashMap<Object, Object> returnThis = new HashMap<Object, Object>();
        CountedIterator keyspan = this.mmap.getAttributeKeyspan(id, attributeName, null);
        Object[] key = new Object[1];
        while (keyspan.hasNext()) {
            key[0] = keyspan.next();
            returnThis.put(key[0], this.mmap.getAttributeValue(id, attributeName, key));
        }
        return returnThis;
    }

    @Override
    public MultiHashMap getMultiHashMap() {
        return this.mmap;
    }

    @Override
    public MultiHashMapDefinition getMultiHashMapDefinition() {
        return this.mmapDef;
    }

    @Override
    public Equation getEquation(String id, String attributeName) {
        byte type = this.getType(attributeName);
        if (type == -1) {
            return null;
        }
        if (type == -2) {
            Object equation = this.mmap.getAttributeValue(id, attributeName, new Object[]{new Integer(-1)});
            return equation == null ? null : (Equation)equation;
        }
        byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
        if (dimTypes.length > 0) {
            return null;
        }
        Object attribValue = this.mmap.getAttributeValue(id, attributeName, null);
        if (attribValue == null || !(attribValue instanceof Equation)) {
            return null;
        }
        return (Equation)attribValue;
    }

    @Override
    public String getLastEquationError() {
        return this.lastEquationError;
    }

    private Object evalEquation(String id, String attribName, Equation equation, StringBuilder errorMessage) {
        if (this.currentlyActiveAttributes.contains(attribName)) {
            this.currentlyActiveAttributes.clear();
            errorMessage.append("Recursive equation evaluation of \"" + attribName + "\"!");
            return null;
        }
        this.currentlyActiveAttributes.add(attribName);
        Set<String> attribReferences = equation.getAttribReferences();
        TreeMap<String, IdentDescriptor> nameToDescriptorMap = new TreeMap<String, IdentDescriptor>();
        for (String attribRef : attribReferences) {
            if (attribRef.equals("ID")) {
                nameToDescriptorMap.put("ID", new IdentDescriptor(id));
                continue;
            }
            Object attribValue = this.getAttribute(id, attribRef);
            if (attribValue == null) {
                this.currentlyActiveAttributes.clear();
                errorMessage.append("Missing value for referenced attribute \"" + attribRef + "\"!");
                logger.warn("Missing value for \"" + attribRef + "\" while evaluating an equation (ID:" + id + ", attribute name:" + attribName + ")");
                return null;
            }
            try {
                nameToDescriptorMap.put(attribRef, new IdentDescriptor(attribValue));
            }
            catch (Exception e) {
                this.currentlyActiveAttributes.clear();
                errorMessage.append("Bad attribute reference to \"" + attribRef + "\"!");
                logger.warn("Bad attribute reference to \"" + attribRef + "\" while evaluating an equation (ID:" + id + ", attribute name:" + attribName + ")");
                return null;
            }
        }
        Interpreter interpreter = new Interpreter(equation, nameToDescriptorMap);
        try {
            Object result = interpreter.run();
            this.currentlyActiveAttributes.remove(attribName);
            return result;
        }
        catch (Exception e) {
            this.currentlyActiveAttributes.clear();
            errorMessage.append(e.getMessage());
            logger.warn("Error while evaluating an equation: " + e.getMessage() + " (ID:" + id + ", attribute name:" + attribName + ")");
            return null;
        }
    }

    private List<String> topoSortAttribReferences(String id, String attribName) {
        Object equationCandidate = this.mmap.getAttributeValue(id, attribName, null);
        if (!(equationCandidate instanceof Equation)) {
            return new ArrayList<String>();
        }
        Equation equation = (Equation)equationCandidate;
        Set<String> attribReferences = equation.getAttribReferences();
        if (attribReferences.size() == 0) {
            return new ArrayList<String>();
        }
        TreeSet<String> alreadyProcessed = new TreeSet<String>();
        alreadyProcessed.add(attribName);
        ArrayList<TopoGraphNode> dependencies = new ArrayList<TopoGraphNode>();
        for (String attribReference : attribReferences) {
            this.followReferences(id, attribReference, alreadyProcessed, dependencies);
        }
        List<TopoGraphNode> topoOrder = TopologicalSort.sort(dependencies);
        ArrayList<String> retVal = new ArrayList<String>();
        for (TopoGraphNode node : topoOrder) {
            AttribTopoGraphNode attribTopoGraphNode = (AttribTopoGraphNode)node;
            String nodeName = attribTopoGraphNode.getNodeName();
            if (nodeName.equals(attribName)) {
                return retVal;
            }
            retVal.add(nodeName);
        }
        throw new IllegalStateException("\"" + attribName + "\" was not found in the toplogical order, which should be impossible!");
    }

    private void followReferences(String id, String attribName, Collection<String> alreadyProcessed, Collection<TopoGraphNode> dependencies) {
        if (alreadyProcessed.contains(attribName)) {
            return;
        }
        alreadyProcessed.add(attribName);
        Object equationCandidate = this.mmap.getAttributeValue(id, attribName, null);
        if (!(equationCandidate instanceof Equation)) {
            return;
        }
        Equation equation = (Equation)equationCandidate;
        Set<String> attribReferences = equation.getAttribReferences();
        for (String attribReference : attribReferences) {
            this.followReferences(id, attribReference, alreadyProcessed, dependencies);
        }
    }

    private static double excelTrunc(double x) {
        boolean isNegative = x < 0.0;
        return Math.round(x + (isNegative ? 0.5 : -0.5));
    }

    private static Integer doubleToInteger(double d) {
        if (d > 2.147483647E9 || d < -2.147483648E9) {
            return null;
        }
        double x = Double.valueOf(d).intValue();
        if (x != d && x < 0.0) {
            x -= 1.0;
        }
        return (int)x;
    }

    private static Integer longToInteger(double l) {
        if (l >= -2.147483648E9 && l <= 2.147483647E9) {
            return (int)l;
        }
        return null;
    }

    private Integer convertEqnRetValToInteger(String id, String attribName, Object equationValue) {
        if (equationValue.getClass() == Double.class) {
            Integer retVal = CyAttributesImpl.doubleToInteger((Double)equationValue);
            if (retVal == null) {
                logger.warn("Cannot convert a floating point value (" + equationValue + ") to an integer!  (ID:" + id + ", attribute name:" + attribName + ")");
            }
            return retVal;
        }
        if (equationValue.getClass() == Long.class) {
            Integer retVal = CyAttributesImpl.longToInteger(((Long)equationValue).longValue());
            if (retVal == null) {
                logger.warn("Cannot convert a large integer (long) value (" + equationValue + ") to an integer! (ID:" + id + ", attribute name:" + attribName + ")");
            }
            return retVal;
        }
        if (equationValue.getClass() == Boolean.class) {
            Boolean boolValue = (Boolean)equationValue;
            return boolValue != false ? 1 : 0;
        }
        throw new IllegalStateException("we should never get here!");
    }

    private Double convertEqnRetValToDouble(String id, String attribName, Object equationValue) {
        if (equationValue.getClass() == Double.class) {
            return (Double)equationValue;
        }
        if (equationValue.getClass() == Long.class) {
            return (double)((Long)equationValue);
        }
        if (equationValue.getClass() == Boolean.class) {
            Boolean boolValue = (Boolean)equationValue;
            return boolValue != false ? 1.0 : 0.0;
        }
        if (equationValue.getClass() == String.class) {
            String valueAsString = (String)equationValue;
            try {
                return Double.parseDouble(valueAsString);
            }
            catch (NumberFormatException e) {
                logger.warn("Cannot convert a string (\"" + valueAsString + "\") to a floating point value! (ID:" + id + ", attribute name:" + attribName + ")");
                return null;
            }
        }
        throw new IllegalStateException("we should never get here!");
    }

    private Boolean convertEqnRetValToBoolean(String id, String attribName, Object equationValue) {
        if (equationValue.getClass() == Double.class) {
            return (Double)equationValue != 0.0;
        }
        if (equationValue.getClass() == Long.class) {
            return (Long)equationValue != 0L;
        }
        if (equationValue.getClass() == Boolean.class) {
            return (Boolean)equationValue;
        }
        if (equationValue.getClass() == String.class) {
            String stringValue = (String)equationValue;
            if (stringValue.compareToIgnoreCase("true") == 0) {
                return true;
            }
            if (stringValue.compareToIgnoreCase("false") == 0) {
                return false;
            }
            logger.warn("Cannot convert a string (\"" + stringValue + "\") to a boolean value! (ID:" + id + ", attribute name:" + attribName + ")");
            return null;
        }
        throw new IllegalStateException("we should never get here!");
    }
}

