/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Interaction {
    private String source;
    private List<String> targets = new ArrayList<String>();
    private String interactionType;

    public Interaction(String source, String target, String interactionType) {
        this.source = source;
        this.interactionType = interactionType;
        this.targets.add(target);
    }

    public Interaction(String rawText) {
        this(rawText, " ");
    }

    public Interaction(String rawText, String delimiter) {
        StringTokenizer strtok = new StringTokenizer(rawText, delimiter);
        int counter = 0;
        while (strtok.hasMoreTokens()) {
            if (counter == 0) {
                this.source = strtok.nextToken().trim();
            } else if (counter == 1) {
                this.interactionType = strtok.nextToken().trim();
            } else {
                this.targets.add(strtok.nextToken().trim());
            }
            ++counter;
        }
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.interactionType;
    }

    public int numberOfTargets() {
        return this.targets.size();
    }

    public String[] getTargets() {
        return this.targets.toArray(new String[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.interactionType);
        sb.append("::");
        sb.append(this.source);
        sb.append("::");
        int targetSize = this.targets.size();
        for (int i = 0; i < targetSize; ++i) {
            sb.append(this.targets.get(i));
            if (i >= targetSize - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

