/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.Cytoscape;
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class ImportAttributeMatrixDialog
extends JDialog {
    private boolean status;
    private String currentKeyAttributeName = "ID";
    private DefaultComboBoxModel keyAttributeModel = new DefaultComboBoxModel();
    private JComboBox keyAttributeBox = new JComboBox(this.keyAttributeModel);
    private JButton cancelButton;
    private JButton importButton;
    private JSeparator jSeparator1;
    private JTextField attributeMatrixFileNameTextField;
    private JLabel attributeSelectionSliderLabel;
    private JButton selectAttributeMatrixFileButton;
    private JLabel titleLabel;

    public ImportAttributeMatrixDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.status = false;
        this.pack();
    }

    public String getKeyAttributeName() {
        return this.currentKeyAttributeName;
    }

    public String getFilename() {
        String attributeMatrixFilename = this.attributeMatrixFileNameTextField.getText();
        return attributeMatrixFilename;
    }

    public boolean getStatus() {
        return this.status;
    }

    private void initComponents() {
        this.setTitle("Import an Attribute/Expression Matrix");
        this.titleLabel = new JLabel();
        this.attributeMatrixFileNameTextField = new JTextField();
        this.selectAttributeMatrixFileButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.cancelButton = new JButton();
        this.importButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.titleLabel.setFont(new Font("Dialog", 1, 14));
        this.titleLabel.setText("Import Attribute/Expression Matrix File");
        this.attributeMatrixFileNameTextField.setText("Please select an attribute or expression matrix file...");
        this.attributeSelectionSliderLabel = new JLabel();
        this.attributeSelectionSliderLabel.setText("Assign values to nodes using...");
        this.selectAttributeMatrixFileButton.setText("Select");
        this.selectAttributeMatrixFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportAttributeMatrixDialog.this.selectAttributeMatrixFileButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportAttributeMatrixDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.importButton.setText("Import");
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportAttributeMatrixDialog.this.importButtonActionPerformed(evt);
            }
        });
        this.importButton.setEnabled(false);
        this.keyAttributeBox = new JComboBox(this.keyAttributeModel);
        this.keyAttributeBox.setBounds(10, 75, 260, 20);
        String[] attribs = Cytoscape.getNodeAttributes().getAttributeNames();
        boolean hasCanonicalNameAttribute = false;
        this.keyAttributeModel.addElement("ID");
        for (int ii = 0; ii < attribs.length; ++ii) {
            this.keyAttributeModel.addElement(attribs[ii]);
        }
        this.keyAttributeBox.setEditable(true);
        this.keyAttributeBox.setSelectedItem("ID");
        KeyAttributeListener listen = new KeyAttributeListener();
        this.keyAttributeBox.addItemListener(listen);
        this.keyAttributeBox.setVisible(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jSeparator1, -1, 379, Short.MAX_VALUE).add(this.titleLabel, -2, 367, -2).add(layout.createSequentialGroup().add(this.attributeMatrixFileNameTextField, -1, 302, Short.MAX_VALUE).addPreferredGap(0).add(this.selectAttributeMatrixFileButton).add(1, 1, 1)).add(this.keyAttributeBox).add(this.attributeSelectionSliderLabel, -1, 312, Short.MAX_VALUE).add(2, layout.createSequentialGroup().add(this.importButton).addPreferredGap(0).add(this.cancelButton).addPreferredGap(0))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.titleLabel).addPreferredGap(0).add(this.jSeparator1, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.attributeMatrixFileNameTextField, -2, 23, -2).add(this.selectAttributeMatrixFileButton)).addPreferredGap(0).add(this.attributeSelectionSliderLabel).add(this.keyAttributeBox).addPreferredGap(0).add(29, 29, 29).add(layout.createParallelGroup(3).add(this.importButton).add(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.status = false;
        this.dispose();
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        this.status = true;
        this.dispose();
    }

    private void selectAttributeMatrixFileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("mrna");
        filter.addExtension("mRNA");
        filter.addExtension("pvals");
        filter.setDescription("All Attribute Matrix files");
        File file = FileUtil.getFile("Import AttributeMatrix File", FileUtil.LOAD, new CyFileFilter[]{filter});
        if (file != null) {
            this.attributeMatrixFileNameTextField.setText(file.getAbsolutePath());
            this.attributeMatrixFileNameTextField.setToolTipText(file.getAbsolutePath());
            this.importButton.setEnabled(true);
        }
    }

    protected class KeyAttributeListener
    implements ItemListener {
        protected KeyAttributeListener() {
        }

        public void itemStateChanged(ItemEvent event) {
            ImportAttributeMatrixDialog.this.currentKeyAttributeName = (String)ImportAttributeMatrixDialog.this.keyAttributeBox.getSelectedItem();
        }
    }
}

