/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout.ui;

import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.CyLayouts;
import cytoscape.layout.ui.LayoutMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutMenuManager
implements MenuListener {
    private static Map<String, List<CyLayoutAlgorithm>> menuAlgorithmMap = new HashMap<String, List<CyLayoutAlgorithm>>();
    private static Map<String, LayoutMenu> menuMap = new HashMap<String, LayoutMenu>();
    private static Set<CyLayoutAlgorithm> existingLayouts = new HashSet<CyLayoutAlgorithm>();

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        Object o = e.getSource();
        if (o instanceof JMenu) {
            this.updateMenus((JMenu)o);
        }
    }

    private void updateMenus(JMenu parentMenu) {
        for (CyLayoutAlgorithm la : CyLayouts.getAllLayouts()) {
            if (existingLayouts.contains(la)) continue;
            this.addLayout(la);
        }
        HashSet<CyLayoutAlgorithm> newLayouts = new HashSet<CyLayoutAlgorithm>(CyLayouts.getAllLayouts());
        for (CyLayoutAlgorithm la : existingLayouts) {
            if (newLayouts.contains(la)) continue;
            this.removeLayout(la);
        }
        for (String name : menuMap.keySet()) {
            LayoutMenu lm = menuMap.get(name);
            int size = menuAlgorithmMap.get(name).size();
            if (!parentMenu.isMenuComponent(lm) && size > 0) {
                parentMenu.add(lm);
                continue;
            }
            if (!parentMenu.isMenuComponent(lm) || size > 0) continue;
            parentMenu.remove(lm);
        }
    }

    private void addLayout(CyLayoutAlgorithm layout) {
        String menuName = CyLayouts.getMenuName(layout);
        if (menuName == null) {
            return;
        }
        existingLayouts.add(layout);
        if (!menuAlgorithmMap.containsKey(menuName)) {
            ArrayList menuList = new ArrayList();
            menuAlgorithmMap.put(menuName, menuList);
        }
        menuAlgorithmMap.get(menuName).add(layout);
        if (!menuMap.containsKey(menuName)) {
            LayoutMenu menu = new LayoutMenu(menuName);
            menuMap.put(menuName, menu);
        }
        menuMap.get(menuName).add(layout);
    }

    private void removeLayout(CyLayoutAlgorithm layout) {
        for (String menu : menuAlgorithmMap.keySet()) {
            List<CyLayoutAlgorithm> menuList = menuAlgorithmMap.get(menu);
            if (menuList.indexOf(layout) < 0) continue;
            menuList.remove(layout);
            menuMap.get(menu).remove(layout);
            existingLayouts.remove(layout);
            return;
        }
    }

    static List<CyLayoutAlgorithm> getLayoutsInMenu(String menu) {
        return menuAlgorithmMap.get(menu);
    }

    static Set<String> getLayoutMenuNames() {
        return menuAlgorithmMap.keySet();
    }
}

