/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.intr;

import cytoscape.util.intr.IntEnumerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntTHash<T>
implements Serializable {
    private static final int[] PRIMES = new int[]{11, 23, 53, 113, 251, 509, 1019, 2039, 4079, 8179, 16369, 32749, 65521, 131063, 262133, 524269, 1048571, 0x1FFFF7, 0x3FFFEF, 8388587, 0xFFFFDF, 33554393, 67108837, 134217689, 0xFFFFFC7, 0x1FFFFFDF, 0x3FFFFFDD, Integer.MAX_VALUE};
    private static final int INITIAL_SIZE = PRIMES[0];
    private static final double THRESHOLD_FACTOR = 0.77;
    private int[] m_keys = new int[INITIAL_SIZE];
    private List<T> m_vals = new ArrayList<T>();
    private int m_elements = 0;
    private int m_thresholdSize = (int)(0.77 * (double)this.m_keys.length);
    private int m_prevKey;
    private int m_prevInx;

    public IntTHash() {
        for (int i = 0; i < this.m_keys.length; ++i) {
            this.m_keys[i] = -1;
        }
        this.m_prevKey = -1;
        this.m_prevInx = -1;
    }

    public static final int maxCapacity(int num) {
        int inx;
        for (inx = 0; inx < PRIMES.length && num >= PRIMES[inx]; ++inx) {
        }
        int thresholdSize = (int)(0.77 * (double)PRIMES[inx]);
        if (thresholdSize >= num) {
            return thresholdSize;
        }
        if (++inx == PRIMES.length) {
            return -1;
        }
        return (int)(0.77 * (double)PRIMES[inx]);
    }

    public final int size() {
        return this.m_elements;
    }

    public final T put(int key, T value) {
        T returnVal;
        if (key < 0) {
            throw new IllegalArgumentException("key is negative");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (key != this.m_prevKey) {
            int incr = 0;
            this.m_prevInx = key % this.m_keys.length;
            while (this.m_keys[this.m_prevInx] >= 0 && this.m_keys[this.m_prevInx] != key) {
                if (incr == 0) {
                    incr = 1 + key % (this.m_keys.length - 1);
                }
                this.m_prevInx = (this.m_prevInx + incr) % this.m_keys.length;
            }
            this.m_prevKey = key;
        }
        if ((returnVal = this.m_vals.get(this.m_prevInx)) == null) {
            if (this.m_elements == this.m_thresholdSize) {
                this.incrSize();
                return this.put(key, value);
            }
            ++this.m_elements;
        }
        this.m_vals.set(this.m_prevInx, value);
        this.m_keys[this.m_prevInx] = key;
        return returnVal;
    }

    public final T get(int key) {
        if (key < 0) {
            throw new IllegalArgumentException("key is negative");
        }
        if (key != this.m_prevKey) {
            int incr = 0;
            this.m_prevInx = key % this.m_keys.length;
            while (this.m_keys[this.m_prevInx] >= 0 && this.m_keys[this.m_prevInx] != key) {
                if (incr == 0) {
                    incr = 1 + key % (this.m_keys.length - 1);
                }
                this.m_prevInx = (this.m_prevInx + incr) % this.m_keys.length;
            }
            this.m_prevKey = key;
        }
        return this.m_vals.get(this.m_prevInx);
    }

    public final IntEnumerator keys() {
        final int numElements = this.m_elements;
        return new IntEnumerator(){
            int elements;
            int index;
            {
                this.elements = numElements;
                this.index = -1;
            }

            public final int numRemaining() {
                return this.elements;
            }

            public final int nextInt() {
                while (IntTHash.this.m_keys[++this.index] < 0) {
                }
                --this.elements;
                return IntTHash.this.m_keys[this.index];
            }
        };
    }

    public final Iterator values() {
        final int numElements = this.m_elements;
        return new Iterator(){
            int elements;
            int index;
            {
                this.elements = numElements;
                this.index = -1;
            }

            public final boolean hasNext() {
                return this.elements == 0;
            }

            public final Object next() {
                try {
                    while (IntTHash.this.m_vals.get(++this.index) == null) {
                    }
                    --this.elements;
                    return IntTHash.this.m_vals.get(this.index);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private final void incrSize() {
        int newSize;
        try {
            int primesInx = 0;
            while (this.m_keys.length != PRIMES[primesInx++]) {
            }
            newSize = PRIMES[primesInx];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("too many elements in this hashtable");
        }
        int[] newKeys = new int[newSize];
        ArrayList<T> newVals = new ArrayList<T>(newSize);
        for (int i = 0; i < newKeys.length; ++i) {
            newKeys[i] = -1;
        }
        this.m_thresholdSize = (int)(0.77 * (double)newKeys.length);
        int oldIndex = -1;
        for (int i = 0; i < this.m_elements; ++i) {
            while (this.m_keys[++oldIndex] < 0) {
            }
            int incr = 0;
            int newIndex = this.m_keys[oldIndex] % newKeys.length;
            while (newKeys[newIndex] >= 0) {
                if (incr == 0) {
                    incr = 1 + this.m_keys[oldIndex] % (newKeys.length - 1);
                }
                newIndex = (newIndex + incr) % newKeys.length;
            }
            newKeys[newIndex] = this.m_keys[oldIndex];
            newVals.set(newIndex, this.m_vals.get(oldIndex));
        }
        this.m_keys = newKeys;
        this.m_vals = newVals;
        this.m_prevKey = -1;
        this.m_prevInx = -1;
    }
}

