/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.Cytoscape;
import java.awt.Dimension;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class CyDesktopManager {
    public static int MINIMUM_WIN_WIDTH = 200;
    public static int MINIMUM_WIN_HEIGHT = 200;
    public static int DEFAULT_WIN_WIDTH = 400;
    public static int DEFAULT_WIN_HEIGHT = 400;
    protected static JDesktopPane desktop;

    private CyDesktopManager() {
        desktop = Cytoscape.getDesktop().getNetworkViewManager().getDesktopPane();
    }

    public void closeAllWindows() {
        JInternalFrame[] allFrames = desktop.getAllFrames();
        for (int i = allFrames.length - 1; i >= 0; --i) {
            allFrames[i].dispose();
        }
    }

    private static void getGridLayout(int pTotal, int pCol, int pRow, int[] gridLayout) {
        if (pTotal > pRow) {
            int row = -1;
            if (pTotal % pCol == 0) {
                gridLayout[pCol - 1] = row = pTotal / pCol;
            } else {
                row = pRow;
                gridLayout[pCol - 1] = pRow;
            }
            CyDesktopManager.getGridLayout(pTotal - row, pCol - 1, row, gridLayout);
        } else {
            gridLayout[0] = pTotal;
        }
    }

    public static void arrangeFrames(Arrange pStyle) {
        if (desktop == null) {
            new CyDesktopManager();
        }
        Dimension desktopSize = desktop.getSize();
        JInternalFrame[] allFrames = desktop.getAllFrames();
        int frameCount = allFrames.length;
        if (frameCount == 0) {
            return;
        }
        if (pStyle == Arrange.CASCADE) {
            int i;
            int delta_x = 20;
            int delta_y = 20;
            int delta_block = 50;
            int[] x = new int[frameCount];
            int[] y = new int[frameCount];
            int[] w = new int[frameCount];
            int[] h = new int[frameCount];
            x[0] = 0;
            y[0] = 0;
            w[0] = 0;
            h[0] = 0;
            int width = 0;
            int height = 0;
            boolean multiBlock = false;
            int blockSize = 0;
            for (i = 1; i < frameCount; ++i) {
                ++blockSize;
                x[i] = x[i - 1] + delta_x;
                y[i] = y[i - 1] + delta_y;
                if (desktopSize.height - y[i] < MINIMUM_WIN_HEIGHT) {
                    y[i] = 0;
                    multiBlock = true;
                }
                if (desktopSize.width - x[i] < MINIMUM_WIN_WIDTH) {
                    x[i] = x[i - 1];
                }
                if (y[i] != 0 || !multiBlock) continue;
                if (i == blockSize) {
                    width = desktopSize.width - x[i - 1];
                    height = desktopSize.height - y[i - 1];
                }
                if (i > blockSize) {
                    width = w[i - blockSize - 1];
                    height = h[i - blockSize - 1];
                    if (desktopSize.width - x[i - 1] < width && (width = desktopSize.width - x[i - 1]) < MINIMUM_WIN_WIDTH) {
                        width = MINIMUM_WIN_WIDTH;
                    }
                    if (desktopSize.height - y[i - 1] < MINIMUM_WIN_HEIGHT) {
                        height = MINIMUM_WIN_HEIGHT;
                    }
                }
                for (int j = 0; j < blockSize; ++j) {
                    w[i - j - 1] = width;
                    h[i - j - 1] = height;
                }
                x[i] = x[i - blockSize] + delta_block;
                if (x[i] > desktopSize.width - delta_x * blockSize - MINIMUM_WIN_WIDTH) {
                    x[i] = x[i - blockSize];
                }
                blockSize = 0;
            }
            if (!multiBlock) {
                for (i = 0; i < frameCount; ++i) {
                    w[frameCount - 1 - i] = desktopSize.width - x[frameCount - 1];
                    h[frameCount - 1 - i] = desktopSize.height - y[frameCount - 1];
                    if (desktopSize.width - x[frameCount - 1 - i] < MINIMUM_WIN_WIDTH) {
                        w[frameCount - 1 - i] = MINIMUM_WIN_WIDTH;
                    }
                    if (desktopSize.height - y[frameCount - 1 - i] >= MINIMUM_WIN_HEIGHT) continue;
                    h[frameCount - 1 - i] = MINIMUM_WIN_HEIGHT;
                }
            } else {
                width = w[frameCount - blockSize - 1];
                height = h[frameCount - blockSize - 1];
                if (desktopSize.width - x[frameCount - 1] < width && (width = desktopSize.width - x[frameCount - 1]) < MINIMUM_WIN_WIDTH) {
                    width = MINIMUM_WIN_WIDTH;
                }
                if (desktopSize.height - y[frameCount - 1] < MINIMUM_WIN_HEIGHT) {
                    height = MINIMUM_WIN_HEIGHT;
                }
                for (i = 0; i < blockSize; ++i) {
                    w[frameCount - 1 - i] = width;
                    h[frameCount - 1 - i] = height;
                }
            }
            if (desktopSize.height - MINIMUM_WIN_HEIGHT < delta_y) {
                double delta_x1 = (double)(desktopSize.width - MINIMUM_WIN_WIDTH) / (double)(frameCount - 1);
                for (int i2 = 0; i2 < frameCount; ++i2) {
                    x[i2] = (int)Math.ceil((double)i2 * delta_x1);
                    y[i2] = 0;
                    w[i2] = MINIMUM_WIN_WIDTH;
                    h[i2] = MINIMUM_WIN_HEIGHT;
                }
            }
            for (int i3 = 0; i3 < frameCount; ++i3) {
                allFrames[frameCount - 1 - i3].setBounds(x[i3], y[i3], w[i3], h[i3]);
            }
        } else if (pStyle == Arrange.GRID) {
            int maxCol;
            int maxRow = maxCol = new Double(Math.ceil(Math.sqrt(frameCount))).intValue();
            while (frameCount <= maxCol * (maxRow - 1)) {
                --maxRow;
            }
            int[] gridLayout = new int[maxCol];
            CyDesktopManager.getGridLayout(frameCount, maxCol, maxRow, gridLayout);
            int w = desktopSize.width / maxCol;
            int curFrame = frameCount - 1;
            for (int col = maxCol - 1; col >= 0; --col) {
                int h = desktopSize.height / gridLayout[col];
                for (int i = 0; i < gridLayout[col]; ++i) {
                    int x = col * w;
                    int y = (gridLayout[col] - i - 1) * h;
                    allFrames[curFrame--].setBounds(x, y, w, h);
                }
            }
        } else if (pStyle == Arrange.HORIZONTAL) {
            int x = 0;
            int y = 0;
            int w = desktopSize.width;
            int h = desktopSize.height / frameCount;
            if (h < MINIMUM_WIN_HEIGHT) {
                h = MINIMUM_WIN_HEIGHT;
            }
            double delta_y = 0.0;
            if (frameCount > 1) {
                delta_y = h < MINIMUM_WIN_HEIGHT ? (double)(desktopSize.height - MINIMUM_WIN_HEIGHT) / (double)(frameCount - 1) : (double)desktopSize.height / (double)frameCount;
            }
            for (int i = 0; i < frameCount; ++i) {
                y = (int)(delta_y * (double)i);
                if (y > desktopSize.height - MINIMUM_WIN_HEIGHT) {
                    y = desktopSize.height - MINIMUM_WIN_HEIGHT;
                }
                allFrames[frameCount - i - 1].setBounds(x, y, w, h);
            }
        } else if (pStyle == Arrange.VERTICAL) {
            int x = 0;
            int y = 0;
            int w = desktopSize.width / frameCount;
            int h = desktopSize.height;
            if (w < MINIMUM_WIN_WIDTH) {
                w = MINIMUM_WIN_WIDTH;
            }
            double delta_x = 0.0;
            if (frameCount > 1) {
                delta_x = w < MINIMUM_WIN_WIDTH ? (double)(desktopSize.width - MINIMUM_WIN_WIDTH) / (double)(frameCount - 1) : (double)desktopSize.width / (double)frameCount;
            }
            for (int i = 0; i < frameCount; ++i) {
                x = (int)(delta_x * (double)i);
                if (x > desktopSize.width - MINIMUM_WIN_WIDTH) {
                    x = desktopSize.width - MINIMUM_WIN_WIDTH;
                }
                allFrames[frameCount - i - 1].setBounds(x, y, w, h);
            }
        } else if (pStyle == Arrange.DEFAULT) {
            int x = 0;
            int y = 0;
            int w = DEFAULT_WIN_WIDTH;
            int h = DEFAULT_WIN_HEIGHT;
            for (int i = 0; i < frameCount; ++i) {
                allFrames[frameCount - i - 1].setBounds(x, y, w, h);
            }
        }
        System.gc();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arrange {
        GRID,
        CASCADE,
        HORIZONTAL,
        VERTICAL,
        DEFAULT;

    }
}

