/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.customgraphic.impl;

import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.customgraphic.CyCustomGraphicsParser;
import cytoscape.visual.customgraphic.IDGenerator;
import cytoscape.visual.customgraphic.Layer;
import cytoscape.visual.customgraphic.Taggable;
import ding.view.ObjectPositionImpl;
import giny.view.ObjectPosition;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDCustomGraphics
implements CyCustomGraphics,
Taggable {
    protected static final String DELIMITER = ",";
    public static final String LIST_DELIMITER = "|";
    protected float fitRatio = 0.9f;
    protected final Long id;
    protected List<Layer> layers;
    protected String displayName;
    protected int width = 50;
    protected int height = 50;
    protected CyCustomGraphicsParser parser;
    protected ObjectPosition position;
    protected final SortedSet<String> tags;

    public AbstractDCustomGraphics(String displayName) {
        this(IDGenerator.getIDGenerator().getNextId(), displayName);
    }

    public AbstractDCustomGraphics(Long id, String displayName) {
        this.id = id;
        this.layers = new ArrayList<Layer>();
        this.displayName = displayName;
        this.tags = new TreeSet<String>();
        this.position = new ObjectPositionImpl();
    }

    @Override
    public Long getIdentifier() {
        return this.id;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public List<Layer> getLayers() {
        return this.layers;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public Image getRenderedImage() {
        return null;
    }

    @Override
    public Collection<String> getTags() {
        return this.tags;
    }

    @Override
    public ObjectPosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(ObjectPosition position) {
        this.position = position;
    }

    public String toString() {
        String tagStr = "";
        if (this.tags.size() != 0) {
            StringBuilder builder = new StringBuilder();
            for (String tag : this.tags) {
                builder.append(tag + LIST_DELIMITER);
            }
            String temp = builder.toString();
            tagStr = temp.substring(0, temp.length() - 1);
        }
        String name = this.displayName;
        if (this.displayName.contains(DELIMITER)) {
            name = this.displayName.replace(DELIMITER, "___");
        }
        return this.getClass().getName() + DELIMITER + this.getIdentifier() + DELIMITER + name + DELIMITER + tagStr;
    }

    @Override
    public void setFitRatio(float fitRatio) {
        this.fitRatio = fitRatio;
    }

    @Override
    public float getFitRatio() {
        return this.fitRatio;
    }
}

