/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.customgraphic.ui;

import cytoscape.Cytoscape;
import cytoscape.visual.customgraphic.CustomGraphicsManager;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.customgraphic.NullCustomGraphics;
import cytoscape.visual.customgraphic.impl.bitmap.URLImageCustomGraphics;
import cytoscape.visual.customgraphic.ui.CustomGraphicsCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdesktop.swingx.JXList;

public class CustomGraphicsBrowser
extends JXList
implements PropertyChangeListener {
    private static final long serialVersionUID = -8342056297304400824L;
    private DefaultListModel model;
    private final CustomGraphicsManager pool = Cytoscape.getVisualMappingManager().getCustomGraphicsManager();
    private static DataFlavor urlFlavor;

    public CustomGraphicsBrowser() throws IOException {
        this.initComponents();
        this.addAllImages();
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(Cytoscape.SESSION_LOADED, this);
    }

    private void initComponents() {
        this.setMaximumSize(new Dimension(300, 10000));
        this.setBackground(new Color(255, 255, 255));
        this.model = new DefaultListModel();
        this.setModel((ListModel)this.model);
        this.setCellRenderer((ListCellRenderer)new CustomGraphicsCellRenderer());
        this.setDropTarget(new URLDropTarget());
    }

    public void removeCustomGraphics(CyCustomGraphics cg) {
        this.model.removeElement(cg);
    }

    private void addAllImages() {
        Collection<CyCustomGraphics> graphics = this.pool.getAll();
        for (CyCustomGraphics cg : graphics) {
            if (cg instanceof NullCustomGraphics) continue;
            this.model.addElement(cg);
        }
    }

    private void addCustomGraphics(String urlStr) {
        URLImageCustomGraphics cg = null;
        try {
            cg = new URLImageCustomGraphics(urlStr);
            if (cg != null) {
                this.pool.addGraphics(cg, new URL(urlStr));
                this.model.addElement(cg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.model.removeAllElements();
        this.model.clear();
        this.addAllImages();
    }

    static {
        try {
            urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
    }

    private class URLDropTarget
    extends DropTarget {
        private static final long serialVersionUID = -7007999535331084109L;

        private URLDropTarget() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(3);
            Transferable trans = dtde.getTransferable();
            boolean gotData = false;
            try {
                block7: {
                    try {
                        if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            List fileList = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                            for (File file : fileList) {
                                CustomGraphicsBrowser.this.addCustomGraphics(file.toURI().toURL().toString());
                            }
                            gotData = true;
                            break block7;
                        }
                        if (trans.isDataFlavorSupported(urlFlavor)) {
                            URL url = (URL)trans.getTransferData(urlFlavor);
                            CustomGraphicsBrowser.this.addCustomGraphics(url.toString());
                            gotData = true;
                            break block7;
                        }
                        if (!trans.isDataFlavorSupported(DataFlavor.stringFlavor)) break block7;
                        String s = (String)trans.getTransferData(DataFlavor.stringFlavor);
                        URL url = new URL(s);
                        CustomGraphicsBrowser.this.addCustomGraphics(url.toString());
                        gotData = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Object var8_12 = null;
                        dtde.dropComplete(gotData);
                    }
                }
                Object var8_11 = null;
                dtde.dropComplete(gotData);
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                dtde.dropComplete(gotData);
                throw throwable;
            }
        }

        private void dumpDataFlavors(Transferable trans) {
            System.out.println("Flavors:");
            DataFlavor[] flavors = trans.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                System.out.println("*** " + i + ": " + flavors[i]);
            }
        }
    }
}

