/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.ui.CellEditorFactory;
import cytoscape.visual.ui.CellRendererFactory;
import cytoscape.visual.ui.VizMapperProperty;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscretePropertySetter {
    private final PropertyRendererRegistry rendReg;
    private final PropertyEditorRegistry editorReg;
    private final CellRendererFactory rendFactory;
    private final CellEditorFactory editorFactory;

    DiscretePropertySetter(PropertyChangeListener pcl, PropertyRendererRegistry rendReg, PropertyEditorRegistry editorReg, CellRendererFactory rendFactory, CellEditorFactory editorFactory) {
        this.rendReg = rendReg;
        this.editorReg = editorReg;
        this.rendFactory = rendFactory;
        this.editorFactory = editorFactory;
    }

    protected final <K, V> void setDiscreteProps(VisualPropertyType type, Map<K, V> discMapping, Set<K> attrKeys, DefaultProperty parent) {
        if (attrKeys == null) {
            return;
        }
        Object val = null;
        ArrayList<VizMapperProperty> children = new ArrayList<VizMapperProperty>();
        for (K key : attrKeys) {
            VizMapperProperty valProp = new VizMapperProperty();
            String strVal = key.toString();
            valProp.setDisplayName(strVal);
            valProp.setName(strVal + "-" + type.toString());
            valProp.setParentProperty(parent);
            val = discMapping.get(key);
            if (val != null) {
                valProp.setType(val.getClass());
            }
            children.add(valProp);
            this.rendReg.registerRenderer((Property)valProp, this.rendFactory.getCellRenderer(type.getDataType()));
            this.editorReg.registerEditor((Property)valProp, this.editorFactory.getPropertyEditor(type.getDataType()));
            valProp.setValue(val);
        }
        parent.addSubProperties(children);
    }
}

