/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.continuous;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.ui.editors.continuous.ContinuousMappingEditorPanel;
import cytoscape.visual.ui.editors.continuous.DiscreteTrackRenderer;
import cytoscape.visual.ui.editors.continuous.EditorValueRangeTracer;
import cytoscape.visual.ui.editors.continuous.TriangleThumbRenderer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.ImageIcon;
import org.jdesktop.swingx.multislider.Thumb;

public class C2DMappingEditor
extends ContinuousMappingEditorPanel {
    private static final long serialVersionUID = 2146889489175240626L;

    public C2DMappingEditor(VisualPropertyType type) {
        super(type);
        this.iconPanel.setVisible(false);
        this.belowPanel.setVisible(false);
        this.abovePanel.setVisible(false);
        this.setSlider();
    }

    public static Object showDialog(int width, int height, String title, VisualPropertyType type) {
        editor = new C2DMappingEditor(type);
        Dimension size = new Dimension(width, height);
        editor.setPreferredSize(size);
        editor.setSize(size);
        editor.setTitle(title);
        editor.setAlwaysOnTop(true);
        editor.setLocationRelativeTo(Cytoscape.getDesktop());
        editor.setVisible(true);
        return editor;
    }

    public static ImageIcon getIcon(int iconWidth, int iconHeight, VisualPropertyType type) {
        editor = new C2DMappingEditor(type);
        if (!(C2DMappingEditor.editor.slider.getTrackRenderer() instanceof DiscreteTrackRenderer)) {
            return null;
        }
        DiscreteTrackRenderer rend = (DiscreteTrackRenderer)C2DMappingEditor.editor.slider.getTrackRenderer();
        rend.getRendererComponent(C2DMappingEditor.editor.slider);
        return rend.getTrackGraphicIcon(iconWidth, iconHeight);
    }

    public static ImageIcon getLegend(int width, int height, VisualPropertyType type) {
        editor = new C2DMappingEditor(type);
        if (!(C2DMappingEditor.editor.slider.getTrackRenderer() instanceof DiscreteTrackRenderer)) {
            return null;
        }
        DiscreteTrackRenderer rend = (DiscreteTrackRenderer)C2DMappingEditor.editor.slider.getTrackRenderer();
        rend.getRendererComponent(C2DMappingEditor.editor.slider);
        return rend.getLegend(width, height);
    }

    protected void addButtonActionPerformed(ActionEvent evt) {
        Object defValue = Cytoscape.getVisualMappingManager().getVisualStyle().getNodeAppearanceCalculator().getDefaultAppearance().get(this.type);
        double maxValue = EditorValueRangeTracer.getTracer().getMax(this.type);
        if (this.mapping.getPointCount() == 0) {
            this.slider.getModel().addThumb(50.0f, defValue);
            BoundaryRangeValues newRange = new BoundaryRangeValues(this.below, defValue, this.above);
            this.mapping.addPoint(maxValue / 2.0, newRange);
            Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            this.slider.repaint();
            this.repaint();
            return;
        }
        this.slider.getModel().addThumb(100.0f, defValue);
        ContinuousMappingPoint previousPoint = this.mapping.getPoint(this.mapping.getPointCount() - 1);
        BoundaryRangeValues previousRange = previousPoint.getRange();
        BoundaryRangeValues newRange = new BoundaryRangeValues(previousRange);
        newRange.lesserValue = this.slider.getModel().getSortedThumbs().get(this.slider.getModel().getThumbCount() - 1);
        newRange.equalValue = defValue;
        newRange.greaterValue = previousRange.greaterValue;
        this.mapping.addPoint(maxValue, newRange);
        this.updateMap();
        Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
        this.slider.repaint();
        this.repaint();
    }

    protected void updateMap() {
        List thumbs = this.slider.getModel().getSortedThumbs();
        double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        double valRange = EditorValueRangeTracer.getTracer().getRange(this.type);
        if (thumbs.size() == 1) {
            this.mapping.getPoint((int)0).getRange().equalValue = this.below;
            this.mapping.getPoint((int)0).getRange().lesserValue = this.below;
            this.mapping.getPoint((int)0).getRange().greaterValue = this.above;
            Double newVal = (double)(thumbs.get(0).getPosition() / 100.0f) * valRange + minValue;
            this.mapping.getPoint(0).setValue(newVal);
            return;
        }
        for (int i = 0; i < thumbs.size(); ++i) {
            Thumb t = thumbs.get(i);
            if (i == 0) {
                this.mapping.getPoint((int)i).getRange().lesserValue = this.below;
                this.mapping.getPoint((int)i).getRange().equalValue = this.below;
                this.mapping.getPoint((int)i).getRange().greaterValue = thumbs.get(i + 1).getObject();
            } else if (i == thumbs.size() - 1) {
                this.mapping.getPoint((int)i).getRange().greaterValue = this.above;
                this.mapping.getPoint((int)i).getRange().equalValue = t.getObject();
                this.mapping.getPoint((int)i).getRange().lesserValue = t.getObject();
            } else {
                this.mapping.getPoint((int)i).getRange().lesserValue = t.getObject();
                this.mapping.getPoint((int)i).getRange().equalValue = t.getObject();
                this.mapping.getPoint((int)i).getRange().greaterValue = thumbs.get(i + 1).getObject();
            }
            Double newVal = (double)(t.getPosition() / 100.0f) * valRange + minValue;
            this.mapping.getPoint(i).setValue(newVal);
        }
    }

    protected void deleteButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.slider.getSelectedIndex();
        if (0 <= selectedIndex) {
            this.slider.getModel().removeThumb(selectedIndex);
            this.mapping.removePoint(selectedIndex);
            this.updateMap();
            this.mapping.fireStateChanged();
            Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            this.repaint();
        }
    }

    private void setSlider() {
        this.slider.updateUI();
        double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        double maxValue = EditorValueRangeTracer.getTracer().getMax(this.type);
        this.slider.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void mouseClicked(MouseEvent e) {
                Object newValue;
                int range;
                block9: {
                    range = ((DiscreteTrackRenderer)C2DMappingEditor.this.slider.getTrackRenderer()).getRangeID(e.getX(), e.getY());
                    newValue = null;
                    if (e.getClickCount() != 2) return;
                    try {
                        try {
                            C2DMappingEditor.this.setAlwaysOnTop(false);
                            newValue = C2DMappingEditor.this.type.showDiscreteEditor();
                        }
                        catch (Exception e1) {
                            CyLogger.getLogger(C2DMappingEditor.class).warn("Unable to show discrete editor!", e1);
                            Object var6_5 = null;
                            C2DMappingEditor.this.setAlwaysOnTop(true);
                            break block9;
                        }
                        Object var6_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        C2DMappingEditor.this.setAlwaysOnTop(true);
                        throw throwable;
                    }
                    C2DMappingEditor.this.setAlwaysOnTop(true);
                }
                if (newValue == null) {
                    return;
                }
                if (range == 0) {
                    C2DMappingEditor.this.below = newValue;
                } else if (range == C2DMappingEditor.this.slider.getModel().getThumbCount()) {
                    C2DMappingEditor.this.above = newValue;
                } else {
                    C2DMappingEditor.this.slider.getModel().getSortedThumbs().get(range).setObject(newValue);
                }
                C2DMappingEditor.this.updateMap();
                C2DMappingEditor.this.slider.setTrackRenderer(new DiscreteTrackRenderer<Object>(C2DMappingEditor.this.type, C2DMappingEditor.this.below, C2DMappingEditor.this.above));
                C2DMappingEditor.this.slider.repaint();
                Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            }
        });
        double actualRange = EditorValueRangeTracer.getTracer().getRange(this.type);
        if (this.allPoints == null) {
            return;
        }
        for (ContinuousMappingPoint point : this.allPoints) {
            BoundaryRangeValues bound = point.getRange();
            Float fraction = Float.valueOf(((Number)((point.getValue() - minValue) / actualRange)).floatValue() * 100.0f);
            this.slider.getModel().addThumb(fraction.floatValue(), bound.equalValue);
        }
        if (this.allPoints.size() != 0) {
            this.below = ((ContinuousMappingPoint)this.allPoints.get((int)0)).getRange().lesserValue;
            this.above = ((ContinuousMappingPoint)this.allPoints.get((int)(this.allPoints.size() - 1))).getRange().greaterValue;
        } else {
            Object defaultVal;
            this.below = defaultVal = Cytoscape.getVisualMappingManager().getVisualStyle().getNodeAppearanceCalculator().getDefaultAppearance().get(this.type);
            this.above = defaultVal;
        }
        TriangleThumbRenderer thumbRend = new TriangleThumbRenderer(this.slider);
        DiscreteTrackRenderer<Object> dRend = new DiscreteTrackRenderer<Object>(this.type, this.below, this.above);
        this.slider.setThumbRenderer(thumbRend);
        this.slider.setTrackRenderer(dRend);
        this.slider.addMouseListener(new ContinuousMappingEditorPanel.ThumbMouseListener(this));
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }
}

