/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.continuous;

import cytoscape.visual.VisualPropertyType;
import java.util.HashMap;
import java.util.Map;

public class EditorValueRangeTracer {
    private static final EditorValueRangeTracer tracer = new EditorValueRangeTracer();
    private Map<VisualPropertyType, Range> rangeMap = new HashMap<VisualPropertyType, Range>();

    private EditorValueRangeTracer() {
        for (VisualPropertyType v : VisualPropertyType.values()) {
            Range r = new Range(0.0, 0.0);
            this.rangeMap.put(v, r);
        }
    }

    public static EditorValueRangeTracer getTracer() {
        return tracer;
    }

    public Double getRange(VisualPropertyType t) {
        return this.rangeMap.get((Object)t).getRange();
    }

    public Double getMin(VisualPropertyType t) {
        return this.rangeMap.get((Object)t).getMin();
    }

    public Double getMax(VisualPropertyType t) {
        return this.rangeMap.get((Object)t).getMax();
    }

    public void setMin(VisualPropertyType t, Double min) {
        this.rangeMap.get((Object)t).setMin(min);
    }

    public void setMax(VisualPropertyType t, Double max) {
        this.rangeMap.get((Object)t).setMax(max);
    }

    private static final class Range {
        private Double min;
        private Double max;

        public Range(Double min, Double max) {
            this.min = min;
            this.max = max;
        }

        public void setMin(Double min) {
            this.min = min;
        }

        public void setMax(Double max) {
            this.max = max;
        }

        public Double getMin() {
            return this.min;
        }

        public Double getMax() {
            return this.max;
        }

        public Double getRange() {
            return Math.abs(this.min - this.max);
        }
    }
}

