/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.dist.AbstractOrderNDistribution;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

class GeneralNthOrderDistribution
extends AbstractOrderNDistribution
implements Serializable {
    private Map dists = new HashMap();
    private static final long serialVersionUID = 42388921L;

    GeneralNthOrderDistribution(Alphabet alpha, DistributionFactory df) throws IllegalAlphabetException {
        super(alpha);
        Iterator i = ((FiniteAlphabet)this.getConditioningAlphabet()).iterator();
        while (i.hasNext()) {
            Symbol si = (Symbol)i.next();
            this.dists.put(si.getName(), df.createDistribution(this.getConditionedAlphabet()));
        }
    }

    public Distribution getDistribution(Symbol sym) throws IllegalSymbolException {
        Distribution d = (Distribution)this.dists.get(sym.getName());
        if (d == null) {
            this.getConditioningAlphabet().validate(sym);
        }
        return d;
    }

    public void setDistribution(Symbol sym, Distribution dist) throws IllegalSymbolException, IllegalAlphabetException {
        this.getConditioningAlphabet().validate(sym);
        if (dist.getAlphabet() != this.getConditionedAlphabet()) {
            throw new IllegalAlphabetException("The distribution must be over " + this.getConditionedAlphabet() + ", not " + dist.getAlphabet());
        }
        Distribution old = (Distribution)this.dists.get(sym);
        if (old != null && this.weightForwarder != null) {
            old.removeChangeListener(this.weightForwarder);
        }
        if (this.weightForwarder != null) {
            dist.addChangeListener(this.weightForwarder);
        }
        this.dists.put(sym.getName(), dist);
    }

    public Collection conditionedDistributions() {
        return this.dists.values();
    }
}

