/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.AlignmentFormat;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;

public class MSFAlignmentFormat
implements AlignmentFormat {
    private static final boolean DEBUGPRINT = false;
    private static final int DNA = 1;
    private static final int PROTEIN = 2;

    public static void main(String[] args) {
        String filename = args.length < 1 ? "SimpleMSF.msf" : args[0];
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            MSFAlignmentFormat MSFAlignmentFormat1 = new MSFAlignmentFormat();
            MSFAlignmentFormat1.read(reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Alignment read(BufferedReader reader) {
        Vector<String> sequenceNames = new Vector<String>();
        String sequenceName = null;
        StringBuffer[] sequenceData = null;
        int startOfData = 0;
        int currSeqCount = 0;
        try {
            Matcher matcher;
            Pattern mtc = Pattern.compile("(Name:|NAME:)\\s+(.*?)\\s+(oo|OO|Len:|LEN:)");
            Pattern removewhitespace = Pattern.compile("\\s");
            String line = reader.readLine();
            while (line.toUpperCase().indexOf("NAME:") == -1) {
                line = reader.readLine();
            }
            while (line.indexOf("//") == -1 && line.trim().length() != 0 && (matcher = mtc.matcher(line)).find() && line.trim().length() != 0) {
                sequenceName = matcher.group(2).trim();
                sequenceNames.add(sequenceName);
                line = reader.readLine();
            }
            sequenceData = new StringBuffer[sequenceNames.size()];
            for (int it = 0; it < sequenceNames.size(); ++it) {
                sequenceData[it] = new StringBuffer();
            }
            while (line.indexOf((String)sequenceNames.get(0)) == -1) {
                line = reader.readLine();
            }
            while (line != null) {
                for (currSeqCount = 0; currSeqCount < sequenceNames.size() && line.indexOf((String)sequenceNames.get(currSeqCount)) != -1; ++currSeqCount) {
                    startOfData = line.indexOf((String)sequenceNames.get(currSeqCount)) + ((String)sequenceNames.get(currSeqCount)).length();
                    line = line.substring(startOfData);
                    line = removewhitespace.matcher(line).replaceAll("");
                    sequenceData[currSeqCount].append(line);
                    line = reader.readLine();
                    if (currSeqCount < sequenceNames.size() - 1 && line.trim().length() == 0) break;
                }
                while (line != null && line.indexOf((String)sequenceNames.get(0)) == -1) {
                    line = reader.readLine();
                }
            }
            StringBuffer testString = new StringBuffer();
            boolean agct = false;
            for (currSeqCount = 0; currSeqCount < sequenceNames.size(); ++currSeqCount) {
                testString.append(sequenceData[currSeqCount]);
            }
            String testStringUpper = testString.toString().toUpperCase();
            LinkedHashMap<String, SimpleSymbolList> sequenceDataMap = new LinkedHashMap<String, SimpleSymbolList>();
            Object sym = null;
            FiniteAlphabet alph = null;
            for (int i = 0; i < testStringUpper.length(); ++i) {
                char c = testStringUpper.charAt(i);
                if (c != 'F' && c != 'L' && c != 'I' && c != 'P' && c != 'Q' && c != 'E') continue;
                alph = ProteinTools.getTAlphabet();
                break;
            }
            if (alph == null) {
                alph = DNATools.getDNA();
            }
            SymbolTokenization parse = alph.getTokenization("token");
            for (currSeqCount = 0; currSeqCount < sequenceNames.size(); ++currSeqCount) {
                String sd = sequenceData[currSeqCount].toString();
                sd = sd.replace('~', '-');
                sd = sd.replace('.', '-');
                sequenceDataMap.put((String)sequenceNames.get(currSeqCount), new SimpleSymbolList(parse, sd));
            }
            SimpleAlignment sa = new SimpleAlignment(sequenceDataMap);
            return sa;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("MSFFormatReader " + e.getMessage());
            return null;
        }
    }

    public void write(OutputStream os, Alignment align, int fileType) throws BioException, IllegalSymbolException {
        int j;
        int i;
        PrintStream out = new PrintStream(os);
        Object[] labels = align.getLabels().toArray();
        int numSeqs = labels.length;
        Iterator[] seqIts = new Iterator[numSeqs];
        int maxLabelLength = 0;
        for (int i2 = 0; i2 < numSeqs; ++i2) {
            seqIts[i2] = align.symbolListForLabel(labels[i2]).iterator();
            if (((String)labels[i2]).length() <= maxLabelLength) continue;
            maxLabelLength = ((String)labels[i2]).length();
        }
        String nl = System.getProperty("line.separator");
        SymbolTokenization toke = null;
        if (align.symbolListForLabel(labels[0]).getAlphabet() == DNATools.getDNA()) {
            fileType = 1;
        } else if (align.symbolListForLabel(labels[0]).getAlphabet() == ProteinTools.getAlphabet() || align.symbolListForLabel(labels[0]).getAlphabet() == ProteinTools.getTAlphabet()) {
            fileType = 2;
        }
        if (fileType == 1) {
            out.print("PileUp" + nl);
            out.print(nl);
            out.print(" MSF: " + align.length() + "  Type: ");
            out.print("N");
            out.print("   Check: 0   .." + nl);
            toke = DNATools.getDNA().getTokenization("token");
        } else if (fileType == 2) {
            out.print("PileUp" + nl);
            out.print(nl);
            out.print(" MSF: " + align.length() + "  Type: ");
            out.print("P");
            out.print("   Check: 0   .." + nl);
            toke = ProteinTools.getTAlphabet().getTokenization("token");
        } else {
            System.out.println("MSFAlignment.write -- File type not recognized.");
            return;
        }
        out.print(nl);
        for (i = 0; i < numSeqs; ++i) {
            out.print(" Name: " + labels[i]);
            for (j = 0; j < maxLabelLength - ((String)labels[i]).length(); ++j) {
                out.print(" ");
            }
            out.print("  Len: " + align.length() + " \tCheck: " + 0 + "\tWeight: " + 0 + nl);
        }
        out.println(nl + "//" + nl + nl);
        while (seqIts[0].hasNext()) {
            for (i = 0; i < numSeqs; ++i) {
                while (((String)labels[i]).length() < maxLabelLength + 1) {
                    labels[i] = " " + labels[i];
                }
                out.print(labels[i] + " ");
                block6: for (j = 0; j < 5; ++j) {
                    out.print(" ");
                    for (int k = 0; k < 10; ++k) {
                        if (!seqIts[i].hasNext()) break block6;
                        out.print(toke.tokenizeSymbol((Symbol)seqIts[i].next()));
                    }
                }
                out.print(nl);
            }
            out.print(nl);
        }
    }

    public void writeDna(OutputStream os, Alignment align) throws BioException, IllegalSymbolException {
        this.write(os, align, 1);
    }

    public void writeProtein(OutputStream os, Alignment align) throws BioException, IllegalSymbolException {
        this.write(os, align, 2);
    }
}

