/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;

public class Value
extends AbstractFunction {
    public Value() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.STRING, "text_or_number", "A number or a string representing a number.")});
    }

    public String getName() {
        return "VALUE";
    }

    public String getFunctionSummary() {
        return "Converts a string or a number to a number.";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        if (args[0].getClass() == Double.class) {
            return (Double)args[0];
        }
        if (args[0].getClass() == Long.class) {
            return (double)((Long)args[0]).longValue();
        }
        if (args[0].getClass() == Boolean.class) {
            return (Boolean)args[0] != false ? 1.0 : 0.0;
        }
        try {
            return Double.parseDouble((String)args[0]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("text argument \"" + args[0] + "\"of VALUE() function is not a valid number!");
        }
    }
}

