## ----knitr, echo = FALSE-------------------------------------------------
library(knitr)
opts_chunk$set(echo = TRUE)
opts_chunk$set(cache = FALSE)

## ----netrc_req, echo = FALSE---------------------------------------------
# This chunk is only useful for BioConductor checks and shouldn't affect any other setup
if (!any(file.exists("~/.netrc", "~/_netrc"))) {
    labkey.netrc.file <- ImmuneSpaceR:::get_env_netrc()
    labkey.url.base <- ImmuneSpaceR:::get_env_url()
}

## ----CreateConection, cache=FALSE, message = FALSE-----------------------
library(ImmuneSpaceR)
sdy269 <- CreateConnection("SDY269")
all <- CreateConnection("")

## ----listDatasets--------------------------------------------------------
sdy269$listDatasets()

## ----listDatasets-which--------------------------------------------------
all$listDatasets(output = "expression")

## ----getGEMatrix---------------------------------------------------------
TIV_2008 <- sdy269$getGEMatrix("TIV_2008")
TIV_2011 <- all$getGEMatrix(matrixName = "SDY144_TIV2011")

## ----ExpressionSet-------------------------------------------------------
TIV_2008

## ----getGEMatrix-cohorts-------------------------------------------------
LAIV_2008 <- sdy269$getGEMatrix(cohort = "LAIV group 2008")

## ----summary-------------------------------------------------------------
TIV_2008_sum <- sdy269$getGEMatrix("TIV_2008", outputType = "summary", annotation = "latest")

## ----summary-print-------------------------------------------------------
TIV_2008_sum

## ----multi---------------------------------------------------------------
# Within a study
em269 <- sdy269$getGEMatrix(c("TIV_2008", "LAIV_2008"))
# Combining across studies
TIV_seasons <- all$getGEMatrix(c("TIV_2008", "SDY144_TIV2011"),
                               outputType = "summary",
                               annotation = "latest")

## ----caching-dataset-----------------------------------------------------
names(sdy269$data_cache)

## ----caching-reload------------------------------------------------------
TIV_2008 <- sdy269$getGEMatrix("TIV_2008", reload = TRUE)

## ----caching-clear-------------------------------------------------------
sdy269$clear_cache()

## ----sessionInfo---------------------------------------------------------
sessionInfo()

