/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.script;

import com.compomics.mascotdatfile.util.interfaces.FragmentIon;
import com.compomics.mascotdatfile.util.mascot.MascotDatfile;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.PeptideHitAnnotation;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.mascotdatfile.util.mascot.QueryToPeptideMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SequenceCoverage {
    private static Logger logger = Logger.getLogger(SequenceCoverage.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args == null || args.length != 4) {
            SequenceCoverage.printUsage();
        }
        String lDatfilePathAndFilename = args[0];
        String lTargetPath = args[1];
        String lTargetFilename = args[2];
        double lIDentityThreshold = Double.parseDouble(args[3]);
        BufferedWriter bw = null;
        try {
            File lTargetPathFile = new File(lTargetPath);
            lTargetPathFile.mkdirs();
            File lTarget = new File(lTargetPathFile, lTargetFilename);
            lTarget.createNewFile();
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(lTarget)));
            SequenceCoverage.printCSVheaders(bw, lDatfilePathAndFilename);
            MascotDatfile mdf = new MascotDatfile(lDatfilePathAndFilename);
            QueryToPeptideMap lQuery2P = mdf.getQueryToPeptideMap();
            Vector lQueries = mdf.getQueryList();
            for (int i = 0; i < lQuery2P.getNumberOfQueries(); ++i) {
                PeptideHit ph = lQuery2P.getPeptideHitOfOneQuery(i + 1);
                if (ph == null || !ph.scoresAboveIdentityThreshold(lIDentityThreshold)) continue;
                PeptideHitAnnotation lPha = ph.getPeptideHitAnnotation(mdf.getMasses(), mdf.getParametersSection());
                Query q = (Query)lQueries.get(i);
                Vector lFM = lPha.getFusedMatchedIons(q.getPeakList(), ph.getPeaksUsedFromIons1(), q.getMaxIntensity(), 0.1);
                int[] lFusedCoverage = SequenceCoverage.getCoverage(lFM, ph.getSequence().length());
                lFM = lPha.getMatchedIonsByMascot(q.getPeakList(), ph.getPeaksUsedFromIons1());
                int[] lMascotCoverage = SequenceCoverage.getCoverage(lFM, ph.getSequence().length());
                bw.write("Query _ " + (i + 1) + ";" + ph.getModifiedSequence() + ";" + ph.getSequence() + ";" + ph.getSequence().length() + ";" + ph.getIonsScore() + ";" + ph.calculateIdentityThreshold(lIDentityThreshold) + ";" + lMascotCoverage[0] + ";" + lMascotCoverage[1] + ";" + lMascotCoverage[2] + ";" + lFusedCoverage[0] + ";" + lFusedCoverage[1] + ";" + lFusedCoverage[2] + ";");
                bw.newLine();
                bw.flush();
            }
            bw.flush();
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static int[] getCoverage(Vector aFM, int aLength) {
        int[] lCoverage = new int[3];
        int[] lB = new int[aLength - 1];
        int[] lY = new int[aLength - 1];
        int[] lAll = new int[aLength];
        for (FragmentIon fm : aFM) {
            int lNumber = fm.getNumber() - 1;
            if (0 < fm.getID() && fm.getID() < 7) {
                if (lB[lNumber] == 0) {
                    lB[lNumber] = 1;
                }
                if (lAll[lNumber] != 0) continue;
                lAll[lNumber] = 1;
                continue;
            }
            if (12 < fm.getID() && fm.getID() < 19) {
                if (lB[lNumber] == 0) {
                    lB[lNumber] = 1;
                }
                if (lAll[lNumber] != 0) continue;
                lAll[lNumber] = 1;
                continue;
            }
            if (6 < fm.getID() && fm.getID() < 13) {
                if (lY[lNumber] == 0) {
                    lY[lNumber] = 1;
                }
                if (lAll[aLength - (lNumber + 1)] != 0) continue;
                lAll[aLength - (lNumber + 1)] = 1;
                continue;
            }
            if (20 < fm.getID() && fm.getID() < 23) {
                if (lB[lNumber] == 0) {
                    lB[lNumber] = 1;
                }
                if (lAll[lNumber] != 0) continue;
                lAll[lNumber] = 1;
                continue;
            }
            if (18 < fm.getID() && fm.getID() < 21) {
                if (lY[lNumber] == 0) {
                    lY[lNumber] = 1;
                }
                if (lAll[aLength - (lNumber + 1)] != 0) continue;
                lAll[aLength - (lNumber + 1)] = 1;
                continue;
            }
            if (22 >= fm.getID() || fm.getID() >= 25) continue;
            if (lY[lNumber] == 0) {
                lY[lNumber] = 1;
            }
            if (lAll[aLength - (lNumber + 1)] != 0) continue;
            lAll[aLength - (lNumber + 1)] = 1;
        }
        lCoverage[0] = SequenceCoverage.getDistinctNumber(lB);
        lCoverage[1] = SequenceCoverage.getDistinctNumber(lY);
        lCoverage[2] = SequenceCoverage.getDistinctNumber(lAll);
        return lCoverage;
    }

    private static int getDistinctNumber(int[] aCoverage) {
        int lCount = 0;
        for (int i = 0; i < aCoverage.length; ++i) {
            if (aCoverage[i] != 1) continue;
            ++lCount;
        }
        return lCount;
    }

    private static void printUsage() {
        String lMessage = "\"Usage:\tSequenceCoverage <1. Path and filename from datfile> <2. Target path> <3. Target filename> <4. Confidence (alpha)> \"\nExample:\n\t\tSequenceCoverage C:\\mascot\\datfiles\\F010345.dat C:\\target F010345.csv 0.05\nWill run the SequenCoverage script on F010345.dat and write the peptide identifications scoring above their 95% (1-0.05) identitythreshold into the F010345.csv file in the C:\\target directory.";
        SequenceCoverage.printError(lMessage);
    }

    private static void printError(String aMessage) {
        System.err.println(aMessage);
        System.exit(0);
    }

    private static void printCSVheaders(BufferedWriter bw, String aDatfilePathAndFilename) throws IOException {
        bw.write("SequenceCoverage.java analysis of " + aDatfilePathAndFilename + ".");
        bw.newLine();
        bw.write("Query_ID;ModifiedPeptideSequence;PeptideSequence;PeptideLength;PeptideScore;PeptideThreshold;MASCOT_b-covering ions;MASCOT_y-covering ions;MASCOT_all-covering ions;FUSED_b-covering ions;FUSED_y-covering ions;FUSED_all-covering ions");
        bw.newLine();
        bw.flush();
    }
}

