/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.script;

import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.interfaces.QueryToPeptideMapInf;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.ProteinHit;
import com.compomics.mascotdatfile.util.mascot.ProteinID;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.mascotdatfile.util.mascot.enumeration.MascotDatfileType;
import com.compomics.mascotdatfile.util.mascot.factory.MascotDatfileFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SimpleParser {
    private static Logger logger = Logger.getLogger(SimpleParser.class);
    private File iOutput = null;
    private char iSeparator;
    private BufferedWriter writer = null;

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("SimpleParser arguments:\n<alpha> <output> <input 1> [<input 2> <input 3> <input ...>]");
        } else {
            new SimpleParser(args);
        }
    }

    public SimpleParser(String[] lArguments) {
        try {
            int i;
            double lAlpha = Double.parseDouble(lArguments[0]);
            ArrayList<String> lInputs = new ArrayList<String>();
            for (i = 2; i < lArguments.length; ++i) {
                String lInput = lArguments[i];
                lInputs.add(lInput);
            }
            this.iOutput = new File(lArguments[1]);
            this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.iOutput)));
            this.iSeparator = (char)59;
            MascotDatfileInf iMascotDatfile = null;
            for (i = 0; i < lInputs.size(); ++i) {
                String lFileName = (String)lInputs.get(i);
                File iInput = new File(lFileName);
                System.gc();
                System.out.println("Processing " + iInput);
                iMascotDatfile = MascotDatfileFactory.create(lFileName, MascotDatfileType.MEMORY);
                int lQueries = iMascotDatfile.getHeaderSection().getQueries();
                System.out.println(lQueries);
                QueryToPeptideMapInf lQueryToPeptideMap = iMascotDatfile.getQueryToPeptideMap();
                ArrayList<Object> list = null;
                List<PeptideHit> lBestPeptideHits = lQueryToPeptideMap.getAllPeptideHitsAboveIdentityThreshold(lAlpha);
                Iterator iter = iMascotDatfile.getProteinMap().getProteinIDIterator();
                ProteinID lProteinID = null;
                while (iter.hasNext()) {
                    list = new ArrayList<Object>();
                    String lAccession = iter.next().toString();
                    lProteinID = iMascotDatfile.getProteinMap().getProteinID(lAccession);
                    list.add(lAccession);
                    list.add("PROTEIN");
                    list.add(lProteinID.getQueryNumbers().length);
                    list.add(lProteinID.getDescription());
                    this.writeOutput(list);
                }
                for (int j = 0; j < lBestPeptideHits.size(); ++j) {
                    PeptideHit lPeptideHit = lBestPeptideHits.get(j);
                    if (lPeptideHit == null) continue;
                    ArrayList lProteins = lPeptideHit.getProteinHits();
                    for (int k = 0; k < lProteins.size(); ++k) {
                        list = new ArrayList();
                        ProteinHit lProteinHit = (ProteinHit)lProteins.get(k);
                        String lAccession = lProteinHit.getAccession();
                        list.add(lAccession);
                        list.add("PEPTIDE");
                        list.add(lFileName);
                        list.add(j);
                        list.add(k);
                        list.add(((Query)iMascotDatfile.getQueryList().get(j)).getFilename());
                        list.add(lPeptideHit.getModifiedSequence());
                        list.add(lPeptideHit.getIonsScore());
                        list.add(lPeptideHit.calculateIdentityThreshold(0.05));
                        this.writeOutput(list);
                    }
                }
                iMascotDatfile.finish();
            }
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeOutput(ArrayList aList) throws IOException {
        for (int i = 0; i < aList.size(); ++i) {
            Object o = aList.get(i);
            this.writer.write(o.toString());
            this.writer.write(this.iSeparator);
        }
        this.writer.newLine();
        this.writer.flush();
    }
}

