/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.util;

import com.compomics.mascotdatfile.research.util.DatfileLocation;
import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.interfaces.QueryToPeptideMapInf;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.QueryToPeptideMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PeptideHitsAboveThreshold {
    private static Logger logger = Logger.getLogger(PeptideHitsAboveThreshold.class);

    public static void calculateAllPeptideHitsAboveThreshold(QueryToPeptideMap aQueryTP, File aOutput) {
        int lNumberOfQueries = aQueryTP.getPeptideMap().size();
        int lPeptideHitsAboveIdentityCount = 0;
        int lPeptideHitsCount = 0;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(aOutput));
            bw.write("The following is a list of identified PeptideHits in a QueryToPeptideMap:\n Each Query that has PeptideHits is listed.\n");
            bw.newLine();
            for (int i = 1; i < lNumberOfQueries + 1; ++i) {
                Vector lPeptideHits = aQueryTP.getAllPeptideHits(i);
                if (lPeptideHits.get(0) == null) continue;
                bw.write("\nQuery " + i + " has identified " + lPeptideHits.size() + " PeptideHits:");
                lPeptideHitsCount += lPeptideHits.size();
                PeptideHit lPh = null;
                for (int j = 0; j < lPeptideHits.size(); ++j) {
                    lPh = (PeptideHit)lPeptideHits.get(j);
                    if (!lPh.scoresAboveIdentityThreshold(0.01)) continue;
                    bw.write("\n" + (j + 1) + ".\t" + lPh.getModifiedSequence());
                    ++lPeptideHitsAboveIdentityCount;
                }
                bw.flush();
            }
            bw.newLine();
            bw.write("There were " + lPeptideHitsCount + " PeptideHits in " + lNumberOfQueries + " Queries.");
            bw.newLine();
            bw.write(lPeptideHitsAboveIdentityCount + " PeptideHits were above the threshold. (" + (double)lPeptideHitsAboveIdentityCount / (double)lPeptideHitsCount * 100.0);
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DatfileLocation dfl = null;
        MascotDatfileInf mdf = null;
        File file = new File("C:\\temp\\PeptideHitsAboveThreshold.txt");
        int lQueryNumber = Integer.parseInt(args[2]);
        int lPeptideHitNumber = Integer.parseInt(args[3]);
        int lDatfileLocationType = Integer.parseInt(args[0]);
        try {
            if (lDatfileLocationType == 0) {
                dfl = new DatfileLocation(0, new String[]{args[1]});
                mdf = dfl.getDatfile();
            } else if (lDatfileLocationType == 1) {
                dfl = new DatfileLocation(1, new String[]{args[4], args[5], args[1]});
                mdf = dfl.getDatfile();
            }
            System.out.println("Datfile received.");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        QueryToPeptideMapInf lQueryTP = mdf.getQueryToPeptideMap();
        PeptideHitsAboveThreshold.calculateBestPeptideHitAboveThreshold(lQueryTP, file);
    }

    public static void calculateBestPeptideHitAboveThreshold(QueryToPeptideMapInf aQueryTP, File aOutput) {
        int lNumberOfQueries = aQueryTP.getNumberOfQueries();
        int lPeptideHitsAboveIdentityCount = 0;
        boolean lPeptideHitsCount = false;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(aOutput));
            bw.write("The following is a list of identified PeptideHits in a QueryToPeptideMap:\n Each Query that has a PeptideHit above the threshold is listed followed by it's greatest scoring PeptideHit.");
            bw.newLine();
            PeptideHit lPh = null;
            for (int i = 1; i < lNumberOfQueries + 1; ++i) {
                List<PeptideHit> lPeptideHits = aQueryTP.getAllPeptideHits(i);
                if (lPeptideHits.get(0) == null) continue;
                lPh = lPeptideHits.get(0);
                if (lPh.scoresAboveIdentityThreshold(0.05)) {
                    bw.newLine();
                    bw.write(lPh.getModifiedSequence() + "," + i);
                    ++lPeptideHitsAboveIdentityCount;
                }
                bw.flush();
            }
            bw.newLine();
            bw.write("There were " + lNumberOfQueries + " Queries.");
            bw.newLine();
            bw.write(lPeptideHitsAboveIdentityCount + " PeptideHits were above the threshold. (" + (double)lPeptideHitsAboveIdentityCount / (double)lPeptideHitsCount * 100.0 + " percent of the Queries delivered a Peptide Identification.");
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

